/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;


/**
 * VaultInstructionAction to be used.
 */
public enum VaultInstructionAction {
    /**
     * Vault the payment method after API caller performs a successful POST on Payment Tokens.
     */
    ON_CREATE_PAYMENT_TOKENS,

    /**
     * Vault the payment method on successful payer authentication and approval.
     */
    ON_PAYER_APPROVAL,

    /**
     * Unknown values will be mapped by this enum member
     */
    _UNKNOWN;


    private static TreeMap<String, VaultInstructionAction> valueMap = new TreeMap<>();
    private String value;

    static {
        ON_CREATE_PAYMENT_TOKENS.value = "ON_CREATE_PAYMENT_TOKENS";
        ON_PAYER_APPROVAL.value = "ON_PAYER_APPROVAL";
        _UNKNOWN.value = null;

        valueMap.put("ON_CREATE_PAYMENT_TOKENS", ON_CREATE_PAYMENT_TOKENS);
        valueMap.put("ON_PAYER_APPROVAL", ON_PAYER_APPROVAL);
    }

    /**
     * Returns the enum member associated with the given string value.
     * @param toConvert String value to get enum member.
     * @return The enum member against the given string value.
     * @throws IOException when provided value is not mapped to any enum member.
     */
    @JsonCreator
    public static VaultInstructionAction constructFromString(String toConvert) throws IOException {
        VaultInstructionAction enumValue = fromString(toConvert);
        if (enumValue == null) {
            throw new IOException("Unable to create enum instance with value: " + toConvert);
        }
        return enumValue;
    }

    /**
     * Returns the enum member associated with the given string value.
     * @param toConvert String value to get enum member.
     * @return The enum member against the given string value.
     */
    public static VaultInstructionAction fromString(String toConvert) {
        if (!valueMap.containsKey(toConvert)) {
            return _UNKNOWN;
        }
        return valueMap.get(toConvert);
    }

    /**
     * Returns the string value associated with the enum member.
     * @return The string value against enum member.
     */
    @JsonValue
    public String value() {
        return value;
    }
        
    /**
     * Get string representation of this enum.
     */
    @Override
    public String toString() {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    /**
     * Convert list of VaultInstructionAction values to list of string values.
     * @param toConvert The list of VaultInstructionAction values to convert.
     * @return List of representative string values.
     */
    public static List<String> toValue(List<VaultInstructionAction> toConvert) {
        if (toConvert == null) {
            return null;
        }
        List<String> convertedValues = new ArrayList<>();
        for (VaultInstructionAction enumValue : toConvert) {
            convertedValues.add(enumValue.value);
        }
        return convertedValues;
    }
} 