/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for VaultPaypalWalletRequest type.
 */
public class VaultPaypalWalletRequest {
    private String description;
    private UsagePattern usagePattern;
    private VaultedDigitalWalletShippingDetails shipping;
    private Boolean permitMultiplePaymentTokens;
    private PaypalPaymentTokenUsageType usageType;
    private PaypalPaymentTokenCustomerType customerType;
    private Plan billingPlan;
    private VaultExperienceContext experienceContext;

    /**
     * Default constructor.
     */
    public VaultPaypalWalletRequest() {
        permitMultiplePaymentTokens = false;
    }

    /**
     * Initialization constructor.
     * @param  description  String value for description.
     * @param  usagePattern  UsagePattern value for usagePattern.
     * @param  shipping  VaultedDigitalWalletShippingDetails value for shipping.
     * @param  permitMultiplePaymentTokens  Boolean value for permitMultiplePaymentTokens.
     * @param  usageType  PaypalPaymentTokenUsageType value for usageType.
     * @param  customerType  PaypalPaymentTokenCustomerType value for customerType.
     * @param  billingPlan  Plan value for billingPlan.
     * @param  experienceContext  VaultExperienceContext value for experienceContext.
     */
    public VaultPaypalWalletRequest(
            String description,
            UsagePattern usagePattern,
            VaultedDigitalWalletShippingDetails shipping,
            Boolean permitMultiplePaymentTokens,
            PaypalPaymentTokenUsageType usageType,
            PaypalPaymentTokenCustomerType customerType,
            Plan billingPlan,
            VaultExperienceContext experienceContext) {
        this.description = description;
        this.usagePattern = usagePattern;
        this.shipping = shipping;
        this.permitMultiplePaymentTokens = permitMultiplePaymentTokens;
        this.usageType = usageType;
        this.customerType = customerType;
        this.billingPlan = billingPlan;
        this.experienceContext = experienceContext;
    }

    /**
     * Getter for Description.
     * The description displayed to the consumer on the approval flow for a digital wallet, as well
     * as on the merchant view of the payment token management experience. exp: PayPal.com.
     * @return Returns the String
     */
    @JsonGetter("description")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getDescription() {
        return description;
    }

    /**
     * Setter for Description.
     * The description displayed to the consumer on the approval flow for a digital wallet, as well
     * as on the merchant view of the payment token management experience. exp: PayPal.com.
     * @param description Value for String
     */
    @JsonSetter("description")
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * Getter for UsagePattern.
     * Expected business/charge model for the billing agreement.
     * @return Returns the UsagePattern
     */
    @JsonGetter("usage_pattern")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public UsagePattern getUsagePattern() {
        return usagePattern;
    }

    /**
     * Setter for UsagePattern.
     * Expected business/charge model for the billing agreement.
     * @param usagePattern Value for UsagePattern
     */
    @JsonSetter("usage_pattern")
    public void setUsagePattern(UsagePattern usagePattern) {
        this.usagePattern = usagePattern;
    }

    /**
     * Getter for Shipping.
     * The shipping details.
     * @return Returns the VaultedDigitalWalletShippingDetails
     */
    @JsonGetter("shipping")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public VaultedDigitalWalletShippingDetails getShipping() {
        return shipping;
    }

    /**
     * Setter for Shipping.
     * The shipping details.
     * @param shipping Value for VaultedDigitalWalletShippingDetails
     */
    @JsonSetter("shipping")
    public void setShipping(VaultedDigitalWalletShippingDetails shipping) {
        this.shipping = shipping;
    }

    /**
     * Getter for PermitMultiplePaymentTokens.
     * Create multiple payment tokens for the same payer, merchant/platform combination. Use this
     * when the customer has not logged in at merchant/platform. The payment token thus generated,
     * can then also be used to create the customer account at merchant/platform. Use this also when
     * multiple payment tokens are required for the same payer, different customer at
     * merchant/platform. This helps to identify customers distinctly even though they may share the
     * same PayPal account. This only applies to PayPal payment source.
     * @return Returns the Boolean
     */
    @JsonGetter("permit_multiple_payment_tokens")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Boolean getPermitMultiplePaymentTokens() {
        return permitMultiplePaymentTokens;
    }

    /**
     * Setter for PermitMultiplePaymentTokens.
     * Create multiple payment tokens for the same payer, merchant/platform combination. Use this
     * when the customer has not logged in at merchant/platform. The payment token thus generated,
     * can then also be used to create the customer account at merchant/platform. Use this also when
     * multiple payment tokens are required for the same payer, different customer at
     * merchant/platform. This helps to identify customers distinctly even though they may share the
     * same PayPal account. This only applies to PayPal payment source.
     * @param permitMultiplePaymentTokens Value for Boolean
     */
    @JsonSetter("permit_multiple_payment_tokens")
    public void setPermitMultiplePaymentTokens(Boolean permitMultiplePaymentTokens) {
        this.permitMultiplePaymentTokens = permitMultiplePaymentTokens;
    }

    /**
     * Getter for UsageType.
     * The usage type associated with a digital wallet payment token.
     * @return Returns the PaypalPaymentTokenUsageType
     */
    @JsonGetter("usage_type")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public PaypalPaymentTokenUsageType getUsageType() {
        return usageType;
    }

    /**
     * Setter for UsageType.
     * The usage type associated with a digital wallet payment token.
     * @param usageType Value for PaypalPaymentTokenUsageType
     */
    @JsonSetter("usage_type")
    public void setUsageType(PaypalPaymentTokenUsageType usageType) {
        this.usageType = usageType;
    }

    /**
     * Getter for CustomerType.
     * The customer type associated with a digital wallet payment token. This is to indicate whether
     * the customer acting on the merchant / platform is either a business or a consumer.
     * @return Returns the PaypalPaymentTokenCustomerType
     */
    @JsonGetter("customer_type")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public PaypalPaymentTokenCustomerType getCustomerType() {
        return customerType;
    }

    /**
     * Setter for CustomerType.
     * The customer type associated with a digital wallet payment token. This is to indicate whether
     * the customer acting on the merchant / platform is either a business or a consumer.
     * @param customerType Value for PaypalPaymentTokenCustomerType
     */
    @JsonSetter("customer_type")
    public void setCustomerType(PaypalPaymentTokenCustomerType customerType) {
        this.customerType = customerType;
    }

    /**
     * Getter for BillingPlan.
     * The merchant level Recurring Billing plan metadata for the Billing Agreement.
     * @return Returns the Plan
     */
    @JsonGetter("billing_plan")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Plan getBillingPlan() {
        return billingPlan;
    }

    /**
     * Setter for BillingPlan.
     * The merchant level Recurring Billing plan metadata for the Billing Agreement.
     * @param billingPlan Value for Plan
     */
    @JsonSetter("billing_plan")
    public void setBillingPlan(Plan billingPlan) {
        this.billingPlan = billingPlan;
    }

    /**
     * Getter for ExperienceContext.
     * Customizes the Vault creation flow experience for your customers.
     * @return Returns the VaultExperienceContext
     */
    @JsonGetter("experience_context")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public VaultExperienceContext getExperienceContext() {
        return experienceContext;
    }

    /**
     * Setter for ExperienceContext.
     * Customizes the Vault creation flow experience for your customers.
     * @param experienceContext Value for VaultExperienceContext
     */
    @JsonSetter("experience_context")
    public void setExperienceContext(VaultExperienceContext experienceContext) {
        this.experienceContext = experienceContext;
    }

    /**
     * Converts this VaultPaypalWalletRequest into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "VaultPaypalWalletRequest [" + "description=" + description + ", usagePattern="
                + usagePattern + ", shipping=" + shipping + ", permitMultiplePaymentTokens="
                + permitMultiplePaymentTokens + ", usageType=" + usageType + ", customerType="
                + customerType + ", billingPlan=" + billingPlan + ", experienceContext="
                + experienceContext + "]";
    }

    /**
     * Builds a new {@link VaultPaypalWalletRequest.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link VaultPaypalWalletRequest.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder()
                .description(getDescription())
                .usagePattern(getUsagePattern())
                .shipping(getShipping())
                .permitMultiplePaymentTokens(getPermitMultiplePaymentTokens())
                .usageType(getUsageType())
                .customerType(getCustomerType())
                .billingPlan(getBillingPlan())
                .experienceContext(getExperienceContext());
        return builder;
    }

    /**
     * Class to build instances of {@link VaultPaypalWalletRequest}.
     */
    public static class Builder {
        private String description;
        private UsagePattern usagePattern;
        private VaultedDigitalWalletShippingDetails shipping;
        private Boolean permitMultiplePaymentTokens = false;
        private PaypalPaymentTokenUsageType usageType;
        private PaypalPaymentTokenCustomerType customerType;
        private Plan billingPlan;
        private VaultExperienceContext experienceContext;



        /**
         * Setter for description.
         * @param  description  String value for description.
         * @return Builder
         */
        public Builder description(String description) {
            this.description = description;
            return this;
        }

        /**
         * Setter for usagePattern.
         * @param  usagePattern  UsagePattern value for usagePattern.
         * @return Builder
         */
        public Builder usagePattern(UsagePattern usagePattern) {
            this.usagePattern = usagePattern;
            return this;
        }

        /**
         * Setter for shipping.
         * @param  shipping  VaultedDigitalWalletShippingDetails value for shipping.
         * @return Builder
         */
        public Builder shipping(VaultedDigitalWalletShippingDetails shipping) {
            this.shipping = shipping;
            return this;
        }

        /**
         * Setter for permitMultiplePaymentTokens.
         * @param  permitMultiplePaymentTokens  Boolean value for permitMultiplePaymentTokens.
         * @return Builder
         */
        public Builder permitMultiplePaymentTokens(Boolean permitMultiplePaymentTokens) {
            this.permitMultiplePaymentTokens = permitMultiplePaymentTokens;
            return this;
        }

        /**
         * Setter for usageType.
         * @param  usageType  PaypalPaymentTokenUsageType value for usageType.
         * @return Builder
         */
        public Builder usageType(PaypalPaymentTokenUsageType usageType) {
            this.usageType = usageType;
            return this;
        }

        /**
         * Setter for customerType.
         * @param  customerType  PaypalPaymentTokenCustomerType value for customerType.
         * @return Builder
         */
        public Builder customerType(PaypalPaymentTokenCustomerType customerType) {
            this.customerType = customerType;
            return this;
        }

        /**
         * Setter for billingPlan.
         * @param  billingPlan  Plan value for billingPlan.
         * @return Builder
         */
        public Builder billingPlan(Plan billingPlan) {
            this.billingPlan = billingPlan;
            return this;
        }

        /**
         * Setter for experienceContext.
         * @param  experienceContext  VaultExperienceContext value for experienceContext.
         * @return Builder
         */
        public Builder experienceContext(VaultExperienceContext experienceContext) {
            this.experienceContext = experienceContext;
            return this;
        }

        /**
         * Builds a new {@link VaultPaypalWalletRequest} object using the set fields.
         * @return {@link VaultPaypalWalletRequest}
         */
        public VaultPaypalWalletRequest build() {
            return new VaultPaypalWalletRequest(description, usagePattern, shipping,
                    permitMultiplePaymentTokens, usageType, customerType, billingPlan,
                    experienceContext);
        }
    }
}
