/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public enum CaptureStatus {
    COMPLETED,
    DECLINED,
    PARTIALLY_REFUNDED,
    PENDING,
    REFUNDED,
    FAILED,
    _UNKNOWN;

    private static TreeMap<String, CaptureStatus> valueMap;
    private String value;

    @JsonCreator
    public static CaptureStatus constructFromString(String toConvert) throws IOException {
        CaptureStatus enumValue = CaptureStatus.fromString(toConvert);
        if (enumValue == null) {
            throw new IOException("Unable to create enum instance with value: " + toConvert);
        }
        return enumValue;
    }

    public static CaptureStatus fromString(String toConvert) {
        if (!valueMap.containsKey(toConvert)) {
            return _UNKNOWN;
        }
        return valueMap.get(toConvert);
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public String toString() {
        if (this.value == null) {
            return null;
        }
        return this.value.toString();
    }

    public static List<String> toValue(List<CaptureStatus> toConvert) {
        if (toConvert == null) {
            return null;
        }
        ArrayList<String> convertedValues = new ArrayList<String>();
        for (CaptureStatus enumValue : toConvert) {
            convertedValues.add(enumValue.value);
        }
        return convertedValues;
    }

    static {
        valueMap = new TreeMap();
        CaptureStatus.COMPLETED.value = "COMPLETED";
        CaptureStatus.DECLINED.value = "DECLINED";
        CaptureStatus.PARTIALLY_REFUNDED.value = "PARTIALLY_REFUNDED";
        CaptureStatus.PENDING.value = "PENDING";
        CaptureStatus.REFUNDED.value = "REFUNDED";
        CaptureStatus.FAILED.value = "FAILED";
        CaptureStatus._UNKNOWN.value = null;
        valueMap.put("COMPLETED", COMPLETED);
        valueMap.put("DECLINED", DECLINED);
        valueMap.put("PARTIALLY_REFUNDED", PARTIALLY_REFUNDED);
        valueMap.put("PENDING", PENDING);
        valueMap.put("REFUNDED", REFUNDED);
        valueMap.put("FAILED", FAILED);
    }
}

