/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.OrderRequest;

public class CreateOrderInput {
    private String contentType;
    private OrderRequest body;
    private String paypalMockResponse;
    private String paypalRequestId;
    private String paypalPartnerAttributionId;
    private String paypalClientMetadataId;
    private String prefer;
    private String paypalAuthAssertion;

    public CreateOrderInput() {
        this.contentType = "application/json";
        this.prefer = "return=minimal";
    }

    public CreateOrderInput(String contentType, OrderRequest body, String paypalMockResponse, String paypalRequestId, String paypalPartnerAttributionId, String paypalClientMetadataId, String prefer, String paypalAuthAssertion) {
        this.contentType = contentType;
        this.body = body;
        this.paypalMockResponse = paypalMockResponse;
        this.paypalRequestId = paypalRequestId;
        this.paypalPartnerAttributionId = paypalPartnerAttributionId;
        this.paypalClientMetadataId = paypalClientMetadataId;
        this.prefer = prefer;
        this.paypalAuthAssertion = paypalAuthAssertion;
    }

    @JsonGetter(value="Content-Type")
    public String getContentType() {
        return this.contentType;
    }

    @JsonSetter(value="Content-Type")
    private void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @JsonGetter(value="body")
    public OrderRequest getBody() {
        return this.body;
    }

    @JsonSetter(value="body")
    public void setBody(OrderRequest body) {
        this.body = body;
    }

    @JsonGetter(value="PayPal-Mock-Response")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPaypalMockResponse() {
        return this.paypalMockResponse;
    }

    @JsonSetter(value="PayPal-Mock-Response")
    public void setPaypalMockResponse(String paypalMockResponse) {
        this.paypalMockResponse = paypalMockResponse;
    }

    @JsonGetter(value="PayPal-Request-Id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPaypalRequestId() {
        return this.paypalRequestId;
    }

    @JsonSetter(value="PayPal-Request-Id")
    public void setPaypalRequestId(String paypalRequestId) {
        this.paypalRequestId = paypalRequestId;
    }

    @JsonGetter(value="PayPal-Partner-Attribution-Id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPaypalPartnerAttributionId() {
        return this.paypalPartnerAttributionId;
    }

    @JsonSetter(value="PayPal-Partner-Attribution-Id")
    public void setPaypalPartnerAttributionId(String paypalPartnerAttributionId) {
        this.paypalPartnerAttributionId = paypalPartnerAttributionId;
    }

    @JsonGetter(value="PayPal-Client-Metadata-Id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPaypalClientMetadataId() {
        return this.paypalClientMetadataId;
    }

    @JsonSetter(value="PayPal-Client-Metadata-Id")
    public void setPaypalClientMetadataId(String paypalClientMetadataId) {
        this.paypalClientMetadataId = paypalClientMetadataId;
    }

    @JsonGetter(value="Prefer")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPrefer() {
        return this.prefer;
    }

    @JsonSetter(value="Prefer")
    public void setPrefer(String prefer) {
        this.prefer = prefer;
    }

    @JsonGetter(value="PayPal-Auth-Assertion")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPaypalAuthAssertion() {
        return this.paypalAuthAssertion;
    }

    @JsonSetter(value="PayPal-Auth-Assertion")
    public void setPaypalAuthAssertion(String paypalAuthAssertion) {
        this.paypalAuthAssertion = paypalAuthAssertion;
    }

    public String toString() {
        return "CreateOrderInput [contentType=" + this.contentType + ", body=" + this.body + ", paypalMockResponse=" + this.paypalMockResponse + ", paypalRequestId=" + this.paypalRequestId + ", paypalPartnerAttributionId=" + this.paypalPartnerAttributionId + ", paypalClientMetadataId=" + this.paypalClientMetadataId + ", prefer=" + this.prefer + ", paypalAuthAssertion=" + this.paypalAuthAssertion + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.contentType, this.body).paypalMockResponse(this.getPaypalMockResponse()).paypalRequestId(this.getPaypalRequestId()).paypalPartnerAttributionId(this.getPaypalPartnerAttributionId()).paypalClientMetadataId(this.getPaypalClientMetadataId()).prefer(this.getPrefer()).paypalAuthAssertion(this.getPaypalAuthAssertion());
        return builder;
    }

    public static class Builder {
        private String contentType = "application/json";
        private OrderRequest body;
        private String paypalMockResponse;
        private String paypalRequestId;
        private String paypalPartnerAttributionId;
        private String paypalClientMetadataId;
        private String prefer = "return=minimal";
        private String paypalAuthAssertion;

        public Builder() {
        }

        public Builder(String contentType, OrderRequest body) {
            this.contentType = contentType;
            this.body = body;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder body(OrderRequest body) {
            this.body = body;
            return this;
        }

        public Builder paypalMockResponse(String paypalMockResponse) {
            this.paypalMockResponse = paypalMockResponse;
            return this;
        }

        public Builder paypalRequestId(String paypalRequestId) {
            this.paypalRequestId = paypalRequestId;
            return this;
        }

        public Builder paypalPartnerAttributionId(String paypalPartnerAttributionId) {
            this.paypalPartnerAttributionId = paypalPartnerAttributionId;
            return this;
        }

        public Builder paypalClientMetadataId(String paypalClientMetadataId) {
            this.paypalClientMetadataId = paypalClientMetadataId;
            return this;
        }

        public Builder prefer(String prefer) {
            this.prefer = prefer;
            return this;
        }

        public Builder paypalAuthAssertion(String paypalAuthAssertion) {
            this.paypalAuthAssertion = paypalAuthAssertion;
            return this;
        }

        public CreateOrderInput build() {
            return new CreateOrderInput(this.contentType, this.body, this.paypalMockResponse, this.paypalRequestId, this.paypalPartnerAttributionId, this.paypalClientMetadataId, this.prefer, this.paypalAuthAssertion);
        }
    }
}

