/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.CardBrand;

public class NetworkTransactionReference {
    private String id;
    private String date;
    private CardBrand network;
    private String acquirerReferenceNumber;

    public NetworkTransactionReference() {
    }

    public NetworkTransactionReference(String id, String date, CardBrand network, String acquirerReferenceNumber) {
        this.id = id;
        this.date = date;
        this.network = network;
        this.acquirerReferenceNumber = acquirerReferenceNumber;
    }

    @JsonGetter(value="id")
    public String getId() {
        return this.id;
    }

    @JsonSetter(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonGetter(value="date")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDate() {
        return this.date;
    }

    @JsonSetter(value="date")
    public void setDate(String date) {
        this.date = date;
    }

    @JsonGetter(value="network")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CardBrand getNetwork() {
        return this.network;
    }

    @JsonSetter(value="network")
    public void setNetwork(CardBrand network) {
        this.network = network;
    }

    @JsonGetter(value="acquirer_reference_number")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAcquirerReferenceNumber() {
        return this.acquirerReferenceNumber;
    }

    @JsonSetter(value="acquirer_reference_number")
    public void setAcquirerReferenceNumber(String acquirerReferenceNumber) {
        this.acquirerReferenceNumber = acquirerReferenceNumber;
    }

    public String toString() {
        return "NetworkTransactionReference [id=" + this.id + ", date=" + this.date + ", network=" + (Object)((Object)this.network) + ", acquirerReferenceNumber=" + this.acquirerReferenceNumber + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.id).date(this.getDate()).network(this.getNetwork()).acquirerReferenceNumber(this.getAcquirerReferenceNumber());
        return builder;
    }

    public static class Builder {
        private String id;
        private String date;
        private CardBrand network;
        private String acquirerReferenceNumber;

        public Builder() {
        }

        public Builder(String id) {
            this.id = id;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder date(String date) {
            this.date = date;
            return this;
        }

        public Builder network(CardBrand network) {
            this.network = network;
            return this;
        }

        public Builder acquirerReferenceNumber(String acquirerReferenceNumber) {
            this.acquirerReferenceNumber = acquirerReferenceNumber;
            return this;
        }

        public NetworkTransactionReference build() {
            return new NetworkTransactionReference(this.id, this.date, this.network, this.acquirerReferenceNumber);
        }
    }
}

