/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.ExperienceContext;

public class P24PaymentRequest {
    private String name;
    private String email;
    private String countryCode;
    private ExperienceContext experienceContext;

    public P24PaymentRequest() {
    }

    public P24PaymentRequest(String name, String email, String countryCode, ExperienceContext experienceContext) {
        this.name = name;
        this.email = email;
        this.countryCode = countryCode;
        this.experienceContext = experienceContext;
    }

    @JsonGetter(value="name")
    public String getName() {
        return this.name;
    }

    @JsonSetter(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonGetter(value="email")
    public String getEmail() {
        return this.email;
    }

    @JsonSetter(value="email")
    public void setEmail(String email) {
        this.email = email;
    }

    @JsonGetter(value="country_code")
    public String getCountryCode() {
        return this.countryCode;
    }

    @JsonSetter(value="country_code")
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    @JsonGetter(value="experience_context")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ExperienceContext getExperienceContext() {
        return this.experienceContext;
    }

    @JsonSetter(value="experience_context")
    public void setExperienceContext(ExperienceContext experienceContext) {
        this.experienceContext = experienceContext;
    }

    public String toString() {
        return "P24PaymentRequest [name=" + this.name + ", email=" + this.email + ", countryCode=" + this.countryCode + ", experienceContext=" + this.experienceContext + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.name, this.email, this.countryCode).experienceContext(this.getExperienceContext());
        return builder;
    }

    public static class Builder {
        private String name;
        private String email;
        private String countryCode;
        private ExperienceContext experienceContext;

        public Builder() {
        }

        public Builder(String name, String email, String countryCode) {
            this.name = name;
            this.email = email;
            this.countryCode = countryCode;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            return this;
        }

        public Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public Builder experienceContext(ExperienceContext experienceContext) {
            this.experienceContext = experienceContext;
            return this;
        }

        public P24PaymentRequest build() {
            return new P24PaymentRequest(this.name, this.email, this.countryCode, this.experienceContext);
        }
    }
}

