/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

public class PayerBase {
    private String emailAddress;
    private String payerId;

    public PayerBase() {
    }

    public PayerBase(String emailAddress, String payerId) {
        this.emailAddress = emailAddress;
        this.payerId = payerId;
    }

    @JsonGetter(value="email_address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @JsonSetter(value="email_address")
    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    @JsonGetter(value="payer_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPayerId() {
        return this.payerId;
    }

    @JsonSetter(value="payer_id")
    public void setPayerId(String payerId) {
        this.payerId = payerId;
    }

    public String toString() {
        return "PayerBase [emailAddress=" + this.emailAddress + ", payerId=" + this.payerId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().emailAddress(this.getEmailAddress()).payerId(this.getPayerId());
        return builder;
    }

    public static class Builder {
        private String emailAddress;
        private String payerId;

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public Builder payerId(String payerId) {
            this.payerId = payerId;
            return this;
        }

        public PayerBase build() {
            return new PayerBase(this.emailAddress, this.payerId);
        }
    }
}

