/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.Customer;
import com.paypal.sdk.models.PaymentTokenRequestPaymentSource;

public class PaymentTokenRequest {
    private Customer customer;
    private PaymentTokenRequestPaymentSource paymentSource;

    public PaymentTokenRequest() {
    }

    public PaymentTokenRequest(PaymentTokenRequestPaymentSource paymentSource, Customer customer) {
        this.customer = customer;
        this.paymentSource = paymentSource;
    }

    @JsonGetter(value="customer")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Customer getCustomer() {
        return this.customer;
    }

    @JsonSetter(value="customer")
    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    @JsonGetter(value="payment_source")
    public PaymentTokenRequestPaymentSource getPaymentSource() {
        return this.paymentSource;
    }

    @JsonSetter(value="payment_source")
    public void setPaymentSource(PaymentTokenRequestPaymentSource paymentSource) {
        this.paymentSource = paymentSource;
    }

    public String toString() {
        return "PaymentTokenRequest [paymentSource=" + this.paymentSource + ", customer=" + this.customer + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.paymentSource).customer(this.getCustomer());
        return builder;
    }

    public static class Builder {
        private PaymentTokenRequestPaymentSource paymentSource;
        private Customer customer;

        public Builder() {
        }

        public Builder(PaymentTokenRequestPaymentSource paymentSource) {
            this.paymentSource = paymentSource;
        }

        public Builder paymentSource(PaymentTokenRequestPaymentSource paymentSource) {
            this.paymentSource = paymentSource;
            return this;
        }

        public Builder customer(Customer customer) {
            this.customer = customer;
            return this;
        }

        public PaymentTokenRequest build() {
            return new PaymentTokenRequest(this.paymentSource, this.customer);
        }
    }
}

