/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.PaypalWalletCustomerRequest;
import com.paypal.sdk.models.PaypalWalletVaultInstruction;

public class PaypalWalletAttributes {
    private PaypalWalletCustomerRequest customer;
    private PaypalWalletVaultInstruction vault;

    public PaypalWalletAttributes() {
    }

    public PaypalWalletAttributes(PaypalWalletCustomerRequest customer, PaypalWalletVaultInstruction vault) {
        this.customer = customer;
        this.vault = vault;
    }

    @JsonGetter(value="customer")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public PaypalWalletCustomerRequest getCustomer() {
        return this.customer;
    }

    @JsonSetter(value="customer")
    public void setCustomer(PaypalWalletCustomerRequest customer) {
        this.customer = customer;
    }

    @JsonGetter(value="vault")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public PaypalWalletVaultInstruction getVault() {
        return this.vault;
    }

    @JsonSetter(value="vault")
    public void setVault(PaypalWalletVaultInstruction vault) {
        this.vault = vault;
    }

    public String toString() {
        return "PaypalWalletAttributes [customer=" + this.customer + ", vault=" + this.vault + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().customer(this.getCustomer()).vault(this.getVault());
        return builder;
    }

    public static class Builder {
        private PaypalWalletCustomerRequest customer;
        private PaypalWalletVaultInstruction vault;

        public Builder customer(PaypalWalletCustomerRequest customer) {
            this.customer = customer;
            return this;
        }

        public Builder vault(PaypalWalletVaultInstruction vault) {
            this.vault = vault;
            return this;
        }

        public PaypalWalletAttributes build() {
            return new PaypalWalletAttributes(this.customer, this.vault);
        }
    }
}

