/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

public class Phone {
    private String countryCode;
    private String nationalNumber;
    private String extensionNumber;

    public Phone() {
    }

    public Phone(String countryCode, String nationalNumber, String extensionNumber) {
        this.countryCode = countryCode;
        this.nationalNumber = nationalNumber;
        this.extensionNumber = extensionNumber;
    }

    @JsonGetter(value="country_code")
    public String getCountryCode() {
        return this.countryCode;
    }

    @JsonSetter(value="country_code")
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    @JsonGetter(value="national_number")
    public String getNationalNumber() {
        return this.nationalNumber;
    }

    @JsonSetter(value="national_number")
    public void setNationalNumber(String nationalNumber) {
        this.nationalNumber = nationalNumber;
    }

    @JsonGetter(value="extension_number")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getExtensionNumber() {
        return this.extensionNumber;
    }

    @JsonSetter(value="extension_number")
    public void setExtensionNumber(String extensionNumber) {
        this.extensionNumber = extensionNumber;
    }

    public String toString() {
        return "Phone [countryCode=" + this.countryCode + ", nationalNumber=" + this.nationalNumber + ", extensionNumber=" + this.extensionNumber + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.countryCode, this.nationalNumber).extensionNumber(this.getExtensionNumber());
        return builder;
    }

    public static class Builder {
        private String countryCode;
        private String nationalNumber;
        private String extensionNumber;

        public Builder() {
        }

        public Builder(String countryCode, String nationalNumber) {
            this.countryCode = countryCode;
            this.nationalNumber = nationalNumber;
        }

        public Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public Builder nationalNumber(String nationalNumber) {
            this.nationalNumber = nationalNumber;
            return this;
        }

        public Builder extensionNumber(String extensionNumber) {
            this.extensionNumber = extensionNumber;
            return this;
        }

        public Phone build() {
            return new Phone(this.countryCode, this.nationalNumber, this.extensionNumber);
        }
    }
}

