/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.Money;
import com.paypal.sdk.models.PricingModel;

public class PricingScheme {
    private Money price;
    private PricingModel pricingModel;
    private Money reloadThresholdAmount;

    public PricingScheme() {
    }

    public PricingScheme(PricingModel pricingModel, Money price, Money reloadThresholdAmount) {
        this.price = price;
        this.pricingModel = pricingModel;
        this.reloadThresholdAmount = reloadThresholdAmount;
    }

    @JsonGetter(value="price")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getPrice() {
        return this.price;
    }

    @JsonSetter(value="price")
    public void setPrice(Money price) {
        this.price = price;
    }

    @JsonGetter(value="pricing_model")
    public PricingModel getPricingModel() {
        return this.pricingModel;
    }

    @JsonSetter(value="pricing_model")
    public void setPricingModel(PricingModel pricingModel) {
        this.pricingModel = pricingModel;
    }

    @JsonGetter(value="reload_threshold_amount")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getReloadThresholdAmount() {
        return this.reloadThresholdAmount;
    }

    @JsonSetter(value="reload_threshold_amount")
    public void setReloadThresholdAmount(Money reloadThresholdAmount) {
        this.reloadThresholdAmount = reloadThresholdAmount;
    }

    public String toString() {
        return "PricingScheme [pricingModel=" + (Object)((Object)this.pricingModel) + ", price=" + this.price + ", reloadThresholdAmount=" + this.reloadThresholdAmount + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.pricingModel).price(this.getPrice()).reloadThresholdAmount(this.getReloadThresholdAmount());
        return builder;
    }

    public static class Builder {
        private PricingModel pricingModel;
        private Money price;
        private Money reloadThresholdAmount;

        public Builder() {
        }

        public Builder(PricingModel pricingModel) {
            this.pricingModel = pricingModel;
        }

        public Builder pricingModel(PricingModel pricingModel) {
            this.pricingModel = pricingModel;
            return this;
        }

        public Builder price(Money price) {
            this.price = price;
            return this;
        }

        public Builder reloadThresholdAmount(Money reloadThresholdAmount) {
            this.reloadThresholdAmount = reloadThresholdAmount;
            return this;
        }

        public PricingScheme build() {
            return new PricingScheme(this.pricingModel, this.price, this.reloadThresholdAmount);
        }
    }
}

