/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.Money;
import com.paypal.sdk.models.NetAmountBreakdownItem;
import com.paypal.sdk.models.PlatformFee;
import java.util.List;

public class SellerPayableBreakdown {
    private Money grossAmount;
    private Money paypalFee;
    private Money paypalFeeInReceivableCurrency;
    private Money netAmount;
    private Money netAmountInReceivableCurrency;
    private List<PlatformFee> platformFees;
    private List<NetAmountBreakdownItem> netAmountBreakdown;
    private Money totalRefundedAmount;

    public SellerPayableBreakdown() {
    }

    public SellerPayableBreakdown(Money grossAmount, Money paypalFee, Money paypalFeeInReceivableCurrency, Money netAmount, Money netAmountInReceivableCurrency, List<PlatformFee> platformFees, List<NetAmountBreakdownItem> netAmountBreakdown, Money totalRefundedAmount) {
        this.grossAmount = grossAmount;
        this.paypalFee = paypalFee;
        this.paypalFeeInReceivableCurrency = paypalFeeInReceivableCurrency;
        this.netAmount = netAmount;
        this.netAmountInReceivableCurrency = netAmountInReceivableCurrency;
        this.platformFees = platformFees;
        this.netAmountBreakdown = netAmountBreakdown;
        this.totalRefundedAmount = totalRefundedAmount;
    }

    @JsonGetter(value="gross_amount")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getGrossAmount() {
        return this.grossAmount;
    }

    @JsonSetter(value="gross_amount")
    public void setGrossAmount(Money grossAmount) {
        this.grossAmount = grossAmount;
    }

    @JsonGetter(value="paypal_fee")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getPaypalFee() {
        return this.paypalFee;
    }

    @JsonSetter(value="paypal_fee")
    public void setPaypalFee(Money paypalFee) {
        this.paypalFee = paypalFee;
    }

    @JsonGetter(value="paypal_fee_in_receivable_currency")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getPaypalFeeInReceivableCurrency() {
        return this.paypalFeeInReceivableCurrency;
    }

    @JsonSetter(value="paypal_fee_in_receivable_currency")
    public void setPaypalFeeInReceivableCurrency(Money paypalFeeInReceivableCurrency) {
        this.paypalFeeInReceivableCurrency = paypalFeeInReceivableCurrency;
    }

    @JsonGetter(value="net_amount")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getNetAmount() {
        return this.netAmount;
    }

    @JsonSetter(value="net_amount")
    public void setNetAmount(Money netAmount) {
        this.netAmount = netAmount;
    }

    @JsonGetter(value="net_amount_in_receivable_currency")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getNetAmountInReceivableCurrency() {
        return this.netAmountInReceivableCurrency;
    }

    @JsonSetter(value="net_amount_in_receivable_currency")
    public void setNetAmountInReceivableCurrency(Money netAmountInReceivableCurrency) {
        this.netAmountInReceivableCurrency = netAmountInReceivableCurrency;
    }

    @JsonGetter(value="platform_fees")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<PlatformFee> getPlatformFees() {
        return this.platformFees;
    }

    @JsonSetter(value="platform_fees")
    public void setPlatformFees(List<PlatformFee> platformFees) {
        this.platformFees = platformFees;
    }

    @JsonGetter(value="net_amount_breakdown")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<NetAmountBreakdownItem> getNetAmountBreakdown() {
        return this.netAmountBreakdown;
    }

    @JsonSetter(value="net_amount_breakdown")
    public void setNetAmountBreakdown(List<NetAmountBreakdownItem> netAmountBreakdown) {
        this.netAmountBreakdown = netAmountBreakdown;
    }

    @JsonGetter(value="total_refunded_amount")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTotalRefundedAmount() {
        return this.totalRefundedAmount;
    }

    @JsonSetter(value="total_refunded_amount")
    public void setTotalRefundedAmount(Money totalRefundedAmount) {
        this.totalRefundedAmount = totalRefundedAmount;
    }

    public String toString() {
        return "SellerPayableBreakdown [grossAmount=" + this.grossAmount + ", paypalFee=" + this.paypalFee + ", paypalFeeInReceivableCurrency=" + this.paypalFeeInReceivableCurrency + ", netAmount=" + this.netAmount + ", netAmountInReceivableCurrency=" + this.netAmountInReceivableCurrency + ", platformFees=" + this.platformFees + ", netAmountBreakdown=" + this.netAmountBreakdown + ", totalRefundedAmount=" + this.totalRefundedAmount + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().grossAmount(this.getGrossAmount()).paypalFee(this.getPaypalFee()).paypalFeeInReceivableCurrency(this.getPaypalFeeInReceivableCurrency()).netAmount(this.getNetAmount()).netAmountInReceivableCurrency(this.getNetAmountInReceivableCurrency()).platformFees(this.getPlatformFees()).netAmountBreakdown(this.getNetAmountBreakdown()).totalRefundedAmount(this.getTotalRefundedAmount());
        return builder;
    }

    public static class Builder {
        private Money grossAmount;
        private Money paypalFee;
        private Money paypalFeeInReceivableCurrency;
        private Money netAmount;
        private Money netAmountInReceivableCurrency;
        private List<PlatformFee> platformFees;
        private List<NetAmountBreakdownItem> netAmountBreakdown;
        private Money totalRefundedAmount;

        public Builder grossAmount(Money grossAmount) {
            this.grossAmount = grossAmount;
            return this;
        }

        public Builder paypalFee(Money paypalFee) {
            this.paypalFee = paypalFee;
            return this;
        }

        public Builder paypalFeeInReceivableCurrency(Money paypalFeeInReceivableCurrency) {
            this.paypalFeeInReceivableCurrency = paypalFeeInReceivableCurrency;
            return this;
        }

        public Builder netAmount(Money netAmount) {
            this.netAmount = netAmount;
            return this;
        }

        public Builder netAmountInReceivableCurrency(Money netAmountInReceivableCurrency) {
            this.netAmountInReceivableCurrency = netAmountInReceivableCurrency;
            return this;
        }

        public Builder platformFees(List<PlatformFee> platformFees) {
            this.platformFees = platformFees;
            return this;
        }

        public Builder netAmountBreakdown(List<NetAmountBreakdownItem> netAmountBreakdown) {
            this.netAmountBreakdown = netAmountBreakdown;
            return this;
        }

        public Builder totalRefundedAmount(Money totalRefundedAmount) {
            this.totalRefundedAmount = totalRefundedAmount;
            return this;
        }

        public SellerPayableBreakdown build() {
            return new SellerPayableBreakdown(this.grossAmount, this.paypalFee, this.paypalFeeInReceivableCurrency, this.netAmount, this.netAmountInReceivableCurrency, this.platformFees, this.netAmountBreakdown, this.totalRefundedAmount);
        }
    }
}

