/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public enum UsagePattern {
    IMMEDIATE,
    DEFERRED,
    RECURRING_PREPAID,
    RECURRING_POSTPAID,
    THRESHOLD_PREPAID,
    THRESHOLD_POSTPAID,
    SUBSCRIPTION_PREPAID,
    SUBSCRIPTION_POSTPAID,
    UNSCHEDULED_PREPAID,
    UNSCHEDULED_POSTPAID,
    INSTALLMENT_PREPAID,
    INSTALLMENT_POSTPAID,
    _UNKNOWN;

    private static TreeMap<String, UsagePattern> valueMap;
    private String value;

    @JsonCreator
    public static UsagePattern constructFromString(String toConvert) throws IOException {
        UsagePattern enumValue = UsagePattern.fromString(toConvert);
        if (enumValue == null) {
            throw new IOException("Unable to create enum instance with value: " + toConvert);
        }
        return enumValue;
    }

    public static UsagePattern fromString(String toConvert) {
        if (!valueMap.containsKey(toConvert)) {
            return _UNKNOWN;
        }
        return valueMap.get(toConvert);
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public String toString() {
        if (this.value == null) {
            return null;
        }
        return this.value.toString();
    }

    public static List<String> toValue(List<UsagePattern> toConvert) {
        if (toConvert == null) {
            return null;
        }
        ArrayList<String> convertedValues = new ArrayList<String>();
        for (UsagePattern enumValue : toConvert) {
            convertedValues.add(enumValue.value);
        }
        return convertedValues;
    }

    static {
        valueMap = new TreeMap();
        UsagePattern.IMMEDIATE.value = "IMMEDIATE";
        UsagePattern.DEFERRED.value = "DEFERRED";
        UsagePattern.RECURRING_PREPAID.value = "RECURRING_PREPAID";
        UsagePattern.RECURRING_POSTPAID.value = "RECURRING_POSTPAID";
        UsagePattern.THRESHOLD_PREPAID.value = "THRESHOLD_PREPAID";
        UsagePattern.THRESHOLD_POSTPAID.value = "THRESHOLD_POSTPAID";
        UsagePattern.SUBSCRIPTION_PREPAID.value = "SUBSCRIPTION_PREPAID";
        UsagePattern.SUBSCRIPTION_POSTPAID.value = "SUBSCRIPTION_POSTPAID";
        UsagePattern.UNSCHEDULED_PREPAID.value = "UNSCHEDULED_PREPAID";
        UsagePattern.UNSCHEDULED_POSTPAID.value = "UNSCHEDULED_POSTPAID";
        UsagePattern.INSTALLMENT_PREPAID.value = "INSTALLMENT_PREPAID";
        UsagePattern.INSTALLMENT_POSTPAID.value = "INSTALLMENT_POSTPAID";
        UsagePattern._UNKNOWN.value = null;
        valueMap.put("IMMEDIATE", IMMEDIATE);
        valueMap.put("DEFERRED", DEFERRED);
        valueMap.put("RECURRING_PREPAID", RECURRING_PREPAID);
        valueMap.put("RECURRING_POSTPAID", RECURRING_POSTPAID);
        valueMap.put("THRESHOLD_PREPAID", THRESHOLD_PREPAID);
        valueMap.put("THRESHOLD_POSTPAID", THRESHOLD_POSTPAID);
        valueMap.put("SUBSCRIPTION_PREPAID", SUBSCRIPTION_PREPAID);
        valueMap.put("SUBSCRIPTION_POSTPAID", SUBSCRIPTION_POSTPAID);
        valueMap.put("UNSCHEDULED_PREPAID", UNSCHEDULED_PREPAID);
        valueMap.put("UNSCHEDULED_POSTPAID", UNSCHEDULED_POSTPAID);
        valueMap.put("INSTALLMENT_PREPAID", INSTALLMENT_PREPAID);
        valueMap.put("INSTALLMENT_POSTPAID", INSTALLMENT_POSTPAID);
    }
}

