/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.io.File;

public final class PackageDeclarationCheck
extends Check {
    private boolean mDefined;
    private boolean mIgnoreDirectoryName;

    public void setIgnoreDirectoryName(boolean aValue) {
        this.mIgnoreDirectoryName = aValue;
    }

    public int[] getDefaultTokens() {
        return new int[]{16};
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void beginTree(DetailAST aAST) {
        this.mDefined = false;
    }

    public void finishTree(DetailAST aAST) {
        if (!this.mDefined) {
            this.log(aAST.getLineNo(), "missing.package.declaration", new Object[0]);
        }
    }

    public void visitToken(DetailAST aAST) {
        DetailAST nameAST;
        FullIdent full;
        String expected;
        int lastPos;
        this.mDefined = true;
        if (this.mIgnoreDirectoryName) {
            return;
        }
        String fname = this.getFileContents().getFilename();
        String dirname = fname.substring(0, lastPos = fname.lastIndexOf(File.separatorChar));
        if (!dirname.endsWith(expected = (full = FullIdent.createFullIdent(nameAST = aAST.getLastChild().getPreviousSibling())).getText().replace('.', File.separatorChar))) {
            this.log(full.getLineNo(), full.getColumnNo(), "package.dir.mismatch", expected);
        }
    }
}

