/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.BlockParentHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.ExpressionHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentLevel;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;

public class MethodDefHandler
extends BlockParentHandler {
    public MethodDefHandler(IndentationCheck aIndentCheck, DetailAST aAst, ExpressionHandler aParent) {
        super(aIndentCheck, aAst.getType() == 8 ? "ctor def" : "method def", aAst, aParent);
    }

    protected DetailAST getToplevelAST() {
        return null;
    }

    private void checkIdent() {
        DetailAST ident = this.getMainAst().findFirstToken(58);
        int columnNo = this.expandedTabsColumnNo(ident);
        if (this.startsLine(ident) && !this.getLevel().accept(columnNo)) {
            this.logError(ident, "", columnNo);
        }
    }

    private void checkThrows() {
        DetailAST throwsAst = this.getMainAst().findFirstToken(81);
        if (throwsAst == null) {
            return;
        }
        int columnNo = this.expandedTabsColumnNo(throwsAst);
        IndentLevel expectedColumnNo = new IndentLevel(this.getLevel(), this.getIndentCheck().getThrowsIndent());
        if (this.startsLine(throwsAst) && !expectedColumnNo.accept(columnNo)) {
            this.logError(throwsAst, "throws", columnNo, expectedColumnNo);
        }
    }

    private void checkType() {
        DetailAST type = this.getMainAst().findFirstToken(13);
        DetailAST ident = ExpressionHandler.getFirstToken(type);
        int columnNo = this.expandedTabsColumnNo(ident);
        if (this.startsLine(ident) && !this.getLevel().accept(columnNo)) {
            this.logError(ident, "return type", columnNo);
        }
    }

    private void checkParameters() {
        DetailAST params = this.getMainAst().findFirstToken(20);
        this.checkExpressionSubtree(params, this.getLevel(), false, false);
    }

    public void checkIndentation() {
        this.checkModifiers();
        this.checkIdent();
        this.checkThrows();
        if (this.getMainAst().getType() != 8) {
            this.checkType();
        }
        this.checkParameters();
        if (this.getLCurly() == null) {
            return;
        }
        super.checkIndentation();
    }
}

