/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.ExpressionHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentLevel;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;
import com.puppycrawl.tools.checkstyle.checks.indentation.LineSet;
import com.puppycrawl.tools.checkstyle.checks.indentation.LineWrappingHandler;

public class MethodCallHandler
extends ExpressionHandler {
    public MethodCallHandler(IndentationCheck indentCheck, DetailAST ast, ExpressionHandler parent) {
        super(indentCheck, ast.getType() == 27 ? "method call" : "ctor call", ast, parent);
    }

    @Override
    protected IndentLevel getLevelImpl() {
        if (this.getParent() instanceof MethodCallHandler) {
            MethodCallHandler container = (MethodCallHandler)this.getParent();
            if (container != null) {
                if (MethodCallHandler.areOnSameLine(container.getMainAst(), this.getMainAst())) {
                    return container.getLevel();
                }
                if (this.isChainedMethodCallWrapped()) {
                    return container.getLevel();
                }
                return new IndentLevel(container.getLevel(), this.getBasicOffset());
            }
            ExpressionHandler p = this.getParent();
            while (p instanceof MethodCallHandler) {
                p = p.getParent();
            }
            return p.suggestedChildLevel(this);
        }
        LineSet lines = new LineSet();
        this.findSubtreeLines(lines, this.getMainAst().getFirstChild(), true);
        int firstCol = lines.firstLineCol();
        int lineStart = this.getLineStart(this.getFirstAst(this.getMainAst()));
        if (lineStart != firstCol) {
            return new IndentLevel(lineStart);
        }
        return super.getLevelImpl();
    }

    private boolean isChainedMethodCallWrapped() {
        boolean result = false;
        DetailAST main = this.getMainAst();
        DetailAST dot = main.getFirstChild();
        DetailAST target = dot.getFirstChild();
        if (dot.getType() == 59 && target.getType() == 27) {
            DetailAST dot1 = target.getFirstChild();
            DetailAST target1 = dot1.getFirstChild();
            if (dot1.getType() == 59 && target1.getType() == 27) {
                result = true;
            }
        }
        return result;
    }

    private DetailAST getFirstAst(DetailAST ast) {
        DetailAST astNode;
        for (astNode = ast.getFirstChild(); astNode != null && astNode.getType() == 59; astNode = astNode.getFirstChild()) {
        }
        if (astNode == null) {
            astNode = ast;
        }
        return astNode;
    }

    @Override
    public IndentLevel suggestedChildLevel(ExpressionHandler child) {
        DetailAST first = this.getMainAst().getFirstChild();
        int indentLevel = this.getLineStart(first);
        if (!MethodCallHandler.areOnSameLine(child.getMainAst().getFirstChild(), this.getMainAst().getFirstChild())) {
            indentLevel += this.getBasicOffset();
        }
        return new IndentLevel(indentLevel);
    }

    @Override
    public void checkIndentation() {
        DetailAST exprNode = this.getMainAst().getParent();
        if (exprNode.getParent().getType() != 72 && exprNode.getParent().getType() != 7) {
            return;
        }
        DetailAST methodName = this.getMainAst().getFirstChild();
        this.checkExpressionSubtree(methodName, this.getLevel(), false, false);
        DetailAST lparen = this.getMainAst();
        DetailAST rparen = this.getMainAst().findFirstToken(77);
        this.checkLParen(lparen);
        if (rparen.getLineNo() == lparen.getLineNo()) {
            return;
        }
        this.checkExpressionSubtree(this.getMainAst().findFirstToken(34), new IndentLevel(this.getLevel(), this.getBasicOffset()), false, true);
        this.checkRParen(lparen, rparen);
        LineWrappingHandler lineWrap = new LineWrappingHandler(this.getIndentCheck(), this.getMainAst(), MethodCallHandler.getMethodCallLastNode(this.getMainAst()));
        lineWrap.checkIndentation();
    }

    @Override
    protected boolean shouldIncreaseIndent() {
        return false;
    }

    private static DetailAST getMethodCallLastNode(DetailAST firstNode) {
        DetailAST lastNode = firstNode.getNextSibling() == null ? firstNode.getLastChild() : firstNode.getNextSibling();
        return lastNode;
    }
}

