/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.auth;

import com.tencent.qcloud.core.auth.BasicLifecycleCredentialProvider;
import com.tencent.qcloud.core.auth.QCloudLifecycleCredentials;
import com.tencent.qcloud.core.auth.SessionQCloudCredentials;
import com.tencent.qcloud.core.common.QCloudAuthenticationException;
import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.http.HttpRequest;
import com.tencent.qcloud.core.http.HttpResult;
import com.tencent.qcloud.core.http.QCloudHttpClient;
import org.json.JSONException;
import org.json.JSONObject;

public class SessionCredentialProvider
extends BasicLifecycleCredentialProvider {
    private HttpRequest<String> httpRequest;
    private HttpRequest.Builder<String> requestBuilder;
    private StsVersion stsVersion = StsVersion.VERSION_2;

    public SessionCredentialProvider() {
    }

    public SessionCredentialProvider(HttpRequest<String> httpRequest) {
        this(httpRequest, StsVersion.VERSION_2);
    }

    public SessionCredentialProvider(HttpRequest.Builder<String> requestBuilder) {
        this(requestBuilder, StsVersion.VERSION_2);
    }

    public SessionCredentialProvider(HttpRequest<String> httpRequest, StsVersion stsVersion) {
        this.httpRequest = httpRequest;
        this.stsVersion = stsVersion;
    }

    public SessionCredentialProvider(HttpRequest.Builder<String> requestBuilder, StsVersion stsVersion) {
        this.requestBuilder = requestBuilder;
        this.stsVersion = stsVersion;
    }

    @Override
    protected QCloudLifecycleCredentials fetchNewCredentials() throws QCloudClientException {
        HttpRequest<String> fetchSTSRequest = null;
        if (this.httpRequest != null) {
            fetchSTSRequest = this.buildRequest(this.httpRequest);
        } else if (this.requestBuilder != null) {
            fetchSTSRequest = this.buildRequest(this.requestBuilder);
        }
        if (fetchSTSRequest != null) {
            try {
                HttpResult result = (HttpResult)QCloudHttpClient.getDefault().resolveRequest(fetchSTSRequest).executeNow();
                if (result.isSuccessful()) {
                    return this.parseServerResponse((String)result.content());
                }
                throw new QCloudClientException("fetch new credentials error ", new QCloudAuthenticationException(result.asException().getMessage()));
            }
            catch (QCloudServiceException e) {
                throw new QCloudClientException("fetch new credentials error ", new QCloudAuthenticationException(e.getMessage()));
            }
        }
        throw new QCloudClientException(new QCloudAuthenticationException("please pass http request object for fetching"));
    }

    protected HttpRequest<String> buildRequest(HttpRequest<String> httpRequest) {
        return httpRequest;
    }

    protected HttpRequest<String> buildRequest(HttpRequest.Builder<String> requestBuilder) {
        return requestBuilder.build();
    }

    protected SessionQCloudCredentials parseServerResponse(String jsonContent) throws QCloudClientException {
        return this.stsVersion == StsVersion.VERSION_2 ? SessionCredentialProvider.parseStandardSTSJsonResponse(jsonContent) : SessionCredentialProvider.parseStandardSTS3JsonResponse(jsonContent);
    }

    static SessionQCloudCredentials parseStandardSTS3JsonResponse(String jsonContent) throws QCloudClientException {
        if (jsonContent != null) {
            try {
                JSONObject jsonObject = new JSONObject(jsonContent);
                JSONObject data = jsonObject.optJSONObject("Response");
                if (data == null) {
                    data = jsonObject;
                }
                JSONObject credentials = data.optJSONObject("Credentials");
                JSONObject error = data.optJSONObject("Error");
                if (credentials != null) {
                    long expiredTime = data.optLong("ExpiredTime");
                    String sessionToken = credentials.optString("Token");
                    String tmpSecretId = credentials.optString("TmpSecretId");
                    String tmpSecretKey = credentials.optString("TmpSecretKey");
                    return new SessionQCloudCredentials(tmpSecretId, tmpSecretKey, sessionToken, expiredTime);
                }
                if (error != null) {
                    throw new QCloudClientException(new QCloudAuthenticationException("get credentials error : " + data.toString()));
                }
            }
            catch (JSONException e) {
                throw new QCloudClientException("parse sts3.0 session json fails", new QCloudAuthenticationException(e.getMessage()));
            }
        }
        throw new QCloudClientException(new QCloudAuthenticationException("fetch credential response content is null"));
    }

    static SessionQCloudCredentials parseStandardSTSJsonResponse(String jsonContent) throws QCloudClientException {
        if (jsonContent != null) {
            try {
                JSONObject jsonObject = new JSONObject(jsonContent);
                JSONObject data = jsonObject.optJSONObject("data");
                if (data == null) {
                    data = jsonObject;
                }
                JSONObject credentials = data.optJSONObject("credentials");
                int code = data.optInt("code", -1);
                if (credentials != null) {
                    long expiredTime = data.optLong("expiredTime");
                    long startTime = data.optLong("startTime");
                    String sessionToken = credentials.optString("sessionToken");
                    String tmpSecretId = credentials.optString("tmpSecretId");
                    String tmpSecretKey = credentials.optString("tmpSecretKey");
                    if (startTime > 0L) {
                        return new SessionQCloudCredentials(tmpSecretId, tmpSecretKey, sessionToken, startTime, expiredTime);
                    }
                    return new SessionQCloudCredentials(tmpSecretId, tmpSecretKey, sessionToken, expiredTime);
                }
                if (code > 0) {
                    throw new QCloudClientException(new QCloudAuthenticationException("get credentials error : " + data.toString()));
                }
            }
            catch (JSONException e) {
                throw new QCloudClientException("parse sts2.0 session json fails", new QCloudAuthenticationException(e.getMessage()));
            }
        }
        throw new QCloudClientException(new QCloudAuthenticationException("fetch credential response content is null"));
    }

    public static enum StsVersion {
        VERSION_2,
        VERSION_3;

    }
}

