/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

import com.tencent.qcloud.core.http.HttpLoggingInterceptor;
import com.tencent.qcloud.core.logger.FileLogAdapter;
import com.tencent.qcloud.core.logger.QCloudLogger;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Response;

public class HttpLogger
implements HttpLoggingInterceptor.Logger {
    private boolean debuggable;
    private FileLogAdapter fileLogAdapter;
    private List<String> mRequestBufferLogs;
    private String tag;

    public HttpLogger(boolean debuggable, String tag) {
        this.debuggable = debuggable;
        this.tag = tag;
        this.mRequestBufferLogs = new ArrayList<String>(10);
    }

    HttpLogger(boolean debuggable) {
        this(debuggable, "QCloudHttp");
    }

    public void setDebug(boolean debuggable) {
        this.debuggable = debuggable;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logRequest(String message) {
        if (this.debuggable) {
            QCloudLogger.i(this.tag, message, new Object[0]);
        }
        this.fileLogAdapter = QCloudLogger.getAdapter(FileLogAdapter.class);
        if (this.fileLogAdapter != null) {
            List<String> list = this.mRequestBufferLogs;
            synchronized (list) {
                this.mRequestBufferLogs.add(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logResponse(Response response, String message) {
        if (this.debuggable) {
            QCloudLogger.i(this.tag, message, new Object[0]);
        }
        if (this.fileLogAdapter != null && response != null && !response.isSuccessful()) {
            this.flushRequestBufferLogs();
            this.fileLogAdapter.log(4, this.tag, message, null);
        } else {
            List<String> list = this.mRequestBufferLogs;
            synchronized (list) {
                this.mRequestBufferLogs.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logException(Exception exception, String message) {
        QCloudLogger.i(this.tag, message, new Object[0]);
        if (this.fileLogAdapter != null && exception != null) {
            this.flushRequestBufferLogs();
            this.fileLogAdapter.log(4, this.tag, message, exception);
        } else {
            List<String> list = this.mRequestBufferLogs;
            synchronized (list) {
                this.mRequestBufferLogs.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void flushRequestBufferLogs() {
        List<String> list = this.mRequestBufferLogs;
        synchronized (list) {
            if (this.fileLogAdapter != null && this.mRequestBufferLogs.size() > 0) {
                for (String requestLog : this.mRequestBufferLogs) {
                    this.fileLogAdapter.log(4, this.tag, requestLog, null);
                }
                this.mRequestBufferLogs.clear();
            }
        }
    }
}

