/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http.interceptor;

import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.http.HttpConfiguration;
import com.tencent.qcloud.core.http.HttpTask;
import com.tencent.qcloud.core.http.HttpTaskMetrics;
import com.tencent.qcloud.core.http.QCloudHttpRetryHandler;
import com.tencent.qcloud.core.logger.QCloudLogger;
import com.tencent.qcloud.core.task.RetryStrategy;
import com.tencent.qcloud.core.task.TaskManager;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;

public class RetryInterceptor
implements Interceptor {
    private RetryStrategy retryStrategy;
    private RetryStrategy.WeightAndReliableAddition additionComputer = new RetryStrategy.WeightAndReliableAddition();
    private static volatile Map<String, HostReliable> hostReliables = new HashMap<String, HostReliable>();
    private static final int MIN_CLOCK_SKEWED_OFFSET = 600;

    public RetryInterceptor(RetryStrategy retryStrategy) {
        this.retryStrategy = retryStrategy;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        HttpTask task = (HttpTask)TaskManager.getInstance().get((String)request.tag());
        return this.processRequest(chain, request, task);
    }

    Response processRequest(Interceptor.Chain chain, Request request, HttpTask task) throws IOException {
        IOException e;
        Response response;
        block15: {
            int statusCode;
            response = null;
            if (task == null || task.isCanceled()) {
                throw new IOException("CANCELED");
            }
            int attempts = 0;
            long startTime = System.nanoTime();
            while (true) {
                String server;
                long delay;
                if ((delay = this.retryStrategy.getNextDelay(attempts)) > 0L) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(delay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                QCloudLogger.i("QCloudHttp", "%s start to execute, attempts is %d", request, attempts);
                HttpTaskMetrics metrics = task.metrics();
                if (metrics != null) {
                    metrics.setRetryCount(attempts);
                }
                ++attempts;
                statusCode = -1;
                try {
                    if (response != null && response.body() != null) {
                        response.close();
                    }
                    response = this.executeTaskOnce(chain, request, task);
                    statusCode = response.code();
                    e = null;
                }
                catch (IOException exception) {
                    e = exception;
                }
                String serverDate = null;
                if (response != null && "tencent-cos".equals(server = response.header("Server"))) {
                    serverDate = response.header("Date");
                    QCloudLogger.i("QCloudHttp", "serverDate is %s", serverDate);
                }
                if (e == null && response.isSuccessful()) {
                    if (serverDate != null) {
                        HttpConfiguration.calculateGlobalTimeOffset(serverDate, new Date(), 600);
                    }
                    this.increaseHostReliable(request.url().host());
                    this.retryStrategy.onTaskEnd(true, null);
                    break block15;
                }
                String clockSkewError = this.getClockSkewError(response, statusCode);
                if (clockSkewError != null) {
                    QCloudLogger.i("QCloudHttp", "%s failed for %s", request, clockSkewError);
                    long minTimeOffsetDeltaInMill = 2L;
                    if (serverDate != null && HttpConfiguration.calculateGlobalTimeOffset(serverDate, new Date()) > minTimeOffsetDeltaInMill) {
                        e = new IOException(new QCloudServiceException("client clock skewed").setErrorCode(clockSkewError));
                    }
                    break block15;
                }
                if (!this.shouldRetry(request, response, attempts, task.getWeight(), startTime, e, statusCode) || task.isCanceled()) break;
                QCloudLogger.i("QCloudHttp", "%s failed for %s, code is %d", request, e, statusCode);
                this.retryStrategy.onTaskEnd(false, e);
            }
            QCloudLogger.i("QCloudHttp", "%s ends for %s, code is %d", request, e, statusCode);
        }
        if (e != null) {
            this.decreaseHostAccess(request.url().host());
            this.retryStrategy.onTaskEnd(false, e);
            throw e;
        }
        return response;
    }

    private Response executeTaskOnce(Interceptor.Chain chain, Request request, HttpTask task) throws IOException {
        try {
            long transferBodySize;
            if (task.isCanceled()) {
                throw new IOException("CANCELED");
            }
            if (task.isResponseFilePathConverter() && (transferBodySize = task.getTransferBodySize()) > 0L) {
                request = this.buildNewRangeRequest(request, transferBodySize);
            }
            return this.processSingleRequest(chain, request);
        }
        catch (ProtocolException exception) {
            if (exception.getMessage() != null && exception.getMessage().contains("HTTP 204 had non-zero Content-Length: ")) {
                return new Response.Builder().request(request).message(exception.toString()).code(204).protocol(Protocol.HTTP_1_1).build();
            }
            exception.printStackTrace();
            throw exception;
        }
        catch (IOException exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    private boolean isUserCancelled(IOException exception) {
        return exception != null && exception.getMessage() != null && exception.getMessage().toLowerCase(Locale.ROOT).equals("canceled");
    }

    Response processSingleRequest(Interceptor.Chain chain, Request request) throws IOException {
        return chain.proceed(request);
    }

    String getClockSkewError(Response response, int statusCode) {
        if (response != null && statusCode == 403) {
            if (response.request().method().toUpperCase(Locale.ROOT).equals("HEAD")) {
                return "RequestIsExpired";
            }
            ResponseBody body = response.body();
            if (body != null) {
                try {
                    BufferedSource source = body.source();
                    source.request(Long.MAX_VALUE);
                    Buffer buffer = source.buffer();
                    String bodyString = buffer.clone().readString(Charset.forName("UTF-8"));
                    Pattern patternCode = Pattern.compile("<Code>(RequestTimeTooSkewed|AccessDenied)</Code>");
                    Pattern patternMessage = Pattern.compile("<Message>Request has expired</Message>");
                    Matcher matcherCode = patternCode.matcher(bodyString);
                    Matcher matcherMessage = patternMessage.matcher(bodyString);
                    if (matcherCode.find()) {
                        String code = matcherCode.group(1);
                        if ("RequestTimeTooSkewed".equals(code)) {
                            return "RequestTimeTooSkewed";
                        }
                        if ("AccessDenied".equals(code) && matcherMessage.find()) {
                            return "RequestIsExpired";
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private void increaseHostReliable(String host) {
        HostReliable hostReliable = hostReliables.get(host);
        if (hostReliable != null) {
            hostReliable.increaseReliable();
        } else {
            hostReliables.put(host, new HostReliable(host));
        }
    }

    private void decreaseHostAccess(String host) {
        HostReliable hostReliable = hostReliables.get(host);
        if (hostReliable != null) {
            hostReliable.decreaseReliable();
        } else {
            hostReliables.put(host, new HostReliable(host));
        }
    }

    private int getHostReliable(String host) {
        HostReliable hostReliable = hostReliables.get(host);
        if (hostReliable != null) {
            return hostReliable.getReliable();
        }
        return 2;
    }

    private boolean shouldRetry(Request request, Response response, int attempts, int weight, long startTime, IOException e, int statusCode) {
        if (this.isUserCancelled(e)) {
            return false;
        }
        int reliable = this.getHostReliable(request.url().host());
        int retryAddition = this.additionComputer.getRetryAddition(weight, reliable);
        QCloudLogger.i("QCloudHttp", String.format(Locale.ENGLISH, "attempts = %d, weight = %d, reliable = %d, addition = %d", attempts, weight, reliable, retryAddition), new Object[0]);
        if (!this.retryStrategy.shouldRetry(attempts, System.nanoTime() - startTime, retryAddition)) {
            return false;
        }
        QCloudHttpRetryHandler qCloudHttpRetryHandler = this.retryStrategy.getQCloudHttpRetryHandler();
        if (!qCloudHttpRetryHandler.shouldRetry(request, response, e)) {
            return false;
        }
        if (e != null && this.isRecoverable(e)) {
            return true;
        }
        return statusCode == 500 || statusCode == 502 || statusCode == 503 || statusCode == 504;
    }

    private boolean isRecoverable(IOException e) {
        if (e instanceof ProtocolException) {
            return false;
        }
        if (e instanceof InterruptedIOException) {
            return e instanceof SocketTimeoutException;
        }
        if (e instanceof SSLHandshakeException && e.getCause() instanceof CertificateException) {
            return false;
        }
        return !(e instanceof SSLPeerUnverifiedException);
    }

    private Request buildNewRangeRequest(Request request, long transferBodySize) {
        long start = -1L;
        long end = -1L;
        String range = request.header("Range");
        if (range != null) {
            String[] start_end = (range = range.replace("bytes=", "")).split("-");
            if (start_end.length > 0) {
                try {
                    start = Long.parseLong(start_end[0]);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            if (start_end.length > 1) {
                try {
                    end = Long.parseLong(start_end[1]);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        }
        start = start != -1L ? (start += transferBodySize) : transferBodySize;
        Request.Builder requestBuilder = request.newBuilder();
        Headers.Builder headerBuilder = request.headers().newBuilder();
        headerBuilder.set("Range", String.format("bytes=%s-%s", start, end == -1L ? "" : String.valueOf(end)));
        requestBuilder.headers(headerBuilder.build());
        return requestBuilder.build();
    }

    private static class HostReliable {
        private final int maxReliable = 4;
        private final int minReliable = 0;
        private static final int defaultReliable = 2;
        private final long resetPeriod = 300000L;
        private final String host;
        private int reliable;

        private HostReliable(String host) {
            this.host = host;
            this.reliable = 2;
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run() {
                }
            };
            new Timer(host + "reliable").schedule(timerTask, 300000L, 300000L);
        }

        private synchronized void increaseReliable() {
            if (this.reliable < 4) {
                ++this.reliable;
            }
        }

        private synchronized void decreaseReliable() {
            if (this.reliable > 0) {
                --this.reliable;
            }
        }

        private synchronized int getReliable() {
            return this.reliable;
        }

        private synchronized void zeroReliable() {
            this.reliable = 0;
        }

        private synchronized void resetReliable() {
            this.reliable = 2;
        }
    }
}

