/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.retry;

import com.qcloud.cos.retry.BackoffStrategy;
import com.qcloud.cos.utils.ValidationUtils;

public class PredefinedBackoffStrategies {
    private static final int SDK_DEFAULT_BASE_DELAY = 100;
    static final int SDK_DEFAULT_MAX_BACKOFF_IN_MILLISECONDS = 20000;
    private static final int MAX_RETRIES = 30;
    public static final BackoffStrategy DEFAULT = new ExponentialBackoffStrategy(100, 20000);

    private static int calculateExponentialDelay(int retriesAttempted, int baseDelay, int maxBackoffTime) {
        int retries = Math.min(retriesAttempted, 30);
        return (int)Math.min((1L << retries) * (long)baseDelay, (long)maxBackoffTime);
    }

    public static class ExponentialBackoffStrategy
    implements BackoffStrategy {
        private final int baseDelay;
        private final int maxBackoffTime;

        public ExponentialBackoffStrategy(int baseDelay, int maxBackoffTime) {
            this.baseDelay = ValidationUtils.assertIsPositive(baseDelay, "Base delay");
            this.maxBackoffTime = ValidationUtils.assertIsPositive(maxBackoffTime, "Max backoff");
        }

        @Override
        public long computeDelayBeforeNextRetry(int retryIndex) {
            return PredefinedBackoffStrategies.calculateExponentialDelay(retryIndex, this.baseDelay, this.maxBackoffTime);
        }
    }
}

