/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.exception;

import com.qcloud.cos.exception.CosServiceException;
import java.util.HashMap;
import java.util.Map;

public class CosServiceExceptionBuilder {
    private String requestId;
    private String errorCode;
    private String errorMessage;
    private int statusCode;
    private String traceId;
    private Map<String, String> additionalDetails;
    private String errorResponseXml;

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public Map<String, String> getAdditionalDetails() {
        return this.additionalDetails;
    }

    public void setAdditionalDetails(Map<String, String> additionalDetails) {
        this.additionalDetails = additionalDetails;
    }

    public void addAdditionalDetail(String key, String detail) {
        String additionalContent;
        if (detail == null || detail.trim().isEmpty()) {
            return;
        }
        if (this.additionalDetails == null) {
            this.additionalDetails = new HashMap<String, String>();
        }
        if ((additionalContent = this.additionalDetails.get(key)) != null && !additionalContent.trim().isEmpty()) {
            detail = additionalContent + "-" + detail;
        }
        if (!detail.isEmpty()) {
            this.additionalDetails.put(key, detail);
        }
    }

    public String getErrorResponseXml() {
        return this.errorResponseXml;
    }

    public void setErrorResponseXml(String errorResponseXml) {
        this.errorResponseXml = errorResponseXml;
    }

    public CosServiceException build() {
        CosServiceException cosException = this.errorResponseXml == null ? new CosServiceException(this.errorMessage) : new CosServiceException(this.errorMessage, this.errorResponseXml);
        cosException.setErrorCode(this.errorCode);
        cosException.setTraceId(this.traceId);
        cosException.setStatusCode(this.statusCode);
        cosException.setRequestId(this.requestId);
        cosException.setAdditionalDetails(this.additionalDetails);
        cosException.setErrorType(this.errorTypeOf(this.statusCode));
        return cosException;
    }

    private CosServiceException.ErrorType errorTypeOf(int statusCode) {
        return statusCode >= 500 ? CosServiceException.ErrorType.Service : CosServiceException.ErrorType.Client;
    }
}

