/*
 * Decompiled with CFR 0.152.
 */
package com.rudikershaw.gitbuildhook;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

@Mojo(name="initialize", defaultPhase=LifecyclePhase.INITIALIZE)
public class InitialiseMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;

    public void execute() throws MojoFailureException {
        FileRepositoryBuilder repoBuilder = new FileRepositoryBuilder();
        repoBuilder.findGitDir(this.project.getBasedir());
        if (repoBuilder.getGitDir() == null) {
            this.initialiseGitRepository();
        }
    }

    private void initialiseGitRepository() throws MojoFailureException {
        try {
            Git.init().setDirectory(this.project.getBasedir()).call();
        }
        catch (GitAPIException e) {
            throw new MojoFailureException("Could initialise a local git repository.", (Throwable)e);
        }
    }
}

