/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ColumnEncryptionKey;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.converters.AbstractConverter;
import com.sap.db.jdbc.converters.InputStreamFilter;
import com.sap.db.jdbc.converters.ReaderFilter;
import com.sap.db.jdbc.converters.ReaderInputStream;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.util.ByteUtils;
import com.sap.db.util.CharsetUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Set;

@ThreadSafe
class BinaryConverter
extends AbstractConverter {
    protected BinaryConverter(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, int fraction, String schemaName, String tableName, String columnName, String columnLabel, boolean isEncrypted, ColumnEncryptionKey columnEncryptionKey, boolean isDeterministic) throws SQLException {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, fraction, schemaName, tableName, columnName, columnLabel, isEncrypted, columnEncryptionKey, isDeterministic);
    }

    @Override
    public int getEstimatedColumnSize() {
        int dataLen = this._isEncrypted ? this._cipher.getEncryptedLength(this._isDeterministic ? this._length : this._length + 1) : this._length;
        int dataLengthIndicatorLen = HDataPart.getDataLengthIndicatorLength(dataLen);
        return dataLen + dataLengthIndicatorLen;
    }

    @Override
    protected int _getNonNullInputArgLength(Object data) throws SQLException {
        if (!(data instanceof byte[])) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        byte[] value = (byte[])data;
        int valueLength = value.length;
        int dataLen = this._isEncrypted ? this._cipher.getEncryptedLength(this._isDeterministic ? valueLength : valueLength + 1) : valueLength;
        int dataLengthIndicatorLen = HDataPart.getDataLengthIndicatorLength(dataLen);
        return dataLen + dataLengthIndicatorLen + 1;
    }

    @Override
    protected int _putNonNullInputArg(HDataPart dataPart, Object data) throws SQLException {
        if (!(data instanceof byte[])) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        byte[] value = (byte[])data;
        if (this._isEncrypted) {
            byte[] bytes;
            if (this._isDeterministic) {
                bytes = value;
            } else {
                bytes = new byte[value.length + 1];
                ByteUtils.putByte(1, bytes, 0);
                ByteUtils.putBytes(value, bytes, 1);
            }
            byte[] encrypted = this._getEncryptedBuffer(bytes);
            return dataPart.putEncryptedBytes(encrypted);
        }
        return dataPart.putBytesAsBinary(value);
    }

    @Override
    public Object getObject(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsByteArray(controller, dataPart, null);
    }

    @Override
    public Object setObject(Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this.setString((String)value);
        }
        if (value instanceof byte[]) {
            return this.setBytes((byte[])value);
        }
        return this._defaultSetObject(value);
    }

    @Override
    public byte getByte(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        byte[] value = this._getValueAsByteArray(controller, dataPart, outIsNull);
        return value != null && value.length > 0 ? value[0] : (byte)0;
    }

    public byte[] setByte(byte value) throws SQLException {
        return new byte[]{value};
    }

    @Override
    public String getString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        byte[] value = this._getValueAsByteArray(controller, dataPart, null);
        return value != null ? new String(value) : null;
    }

    public byte[] setString(String value) throws SQLException {
        return value != null ? this._checkLength(value.getBytes()) : null;
    }

    @Override
    public byte[] getBytes(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsByteArray(controller, dataPart, null);
    }

    public byte[] setBytes(byte[] value) throws SQLException {
        return value != null ? this._checkLength((byte[])value.clone()) : null;
    }

    @Override
    public Reader getCharacterStream(SQLParamController controller, HDataPart dataPart) throws SQLException {
        byte[] value = this._getValueAsByteArray(controller, dataPart, null);
        return value != null ? new StringReader(new String(value)) : null;
    }

    public byte[] setCharacterStream(Reader value, long length) throws SQLException {
        return value != null ? this._checkLength(BinaryConverter._convertInputStreamToBytes(new ReaderInputStream(length >= 0L ? new ReaderFilter(value, length) : value, 256), -1L)) : null;
    }

    @Override
    public InputStream getAsciiStream(SQLParamController controller, HDataPart dataPart) throws SQLException {
        byte[] value = this._getValueAsByteArray(controller, dataPart, null);
        return value != null ? new ByteArrayInputStream(new String(value).getBytes(CharsetUtils.ISO_8859_1)) : null;
    }

    public byte[] setAsciiStream(InputStream value, long length) throws SQLException {
        return value != null ? this._checkLength(BinaryConverter._convertInputStreamToBytes(new ReaderInputStream(new InputStreamReader(length >= 0L ? new InputStreamFilter(value, length) : value, CharsetUtils.ISO_8859_1), 4096), -1L)) : null;
    }

    @Override
    public InputStream getBinaryStream(SQLParamController controller, HDataPart dataPart) throws SQLException {
        byte[] value = this._getValueAsByteArray(controller, dataPart, null);
        return value != null ? new ByteArrayInputStream(value) : null;
    }

    public byte[] setBinaryStream(InputStream value, long length) throws SQLException {
        return value != null ? this._checkLength(BinaryConverter._convertInputStreamToBytes(value, length)) : null;
    }

    private byte[] _getValueAsByteArray(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        byte[] decrypted = this._isEncrypted && !this._isDeterministic ? this._getDecryptedBuffer(dataPart) : null;
        boolean isNull = dataPart.isNull(this, controller, decrypted);
        if (outIsNull != null) {
            outIsNull[0] = isNull;
        }
        if (isNull) {
            return null;
        }
        if (this._isEncrypted) {
            int len;
            int off;
            if (this._isDeterministic) {
                decrypted = this._getDecryptedBuffer(dataPart);
                off = 0;
                len = decrypted.length;
            } else {
                off = 1;
                len = decrypted.length - 1;
            }
            return ByteUtils.getBytes(decrypted, off, len);
        }
        return dataPart.getBinaryAsBytes();
    }

    private byte[] _checkLength(byte[] value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (this._isEncrypted && value.length > this._length) {
            throw this._newSetCharacterBinaryValueTooLargeException(Arrays.toString(value), String.valueOf(this._length));
        }
        return value;
    }
}

