/*
 * Decompiled with CFR 0.152.
 */
package com.ard.security.config;

import com.alibaba.fastjson.JSON;
import com.ard.security.config.SafeConfig;
import com.ard.security.config.SafeConstant;
import com.ard.security.config.model.ProSecurityConfig;
import com.ard.security.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.data.redis.core.RedisTemplate;

public class LoadSecurityConfig {
    private static final Logger log = LoggerFactory.getLogger(LoadSecurityConfig.class);

    public static void loadRedis(ApplicationContext context) {
        if (SafeConfig.redisTemplate == null) {
            log.info(" * * * * * * * * * * * * * * * * \u521d\u59cb\u5316\u9a8c\u7b7e redis \u5bf9\u8c61 * * * * * * * * * * * * * * * * ");
            try {
                if (context.getBean("redisTemplate") != null) {
                    SafeConfig.redisTemplate = (RedisTemplate)context.getBean("redisTemplate");
                    log.info(" * * * * * * * * * * * * * * * * \u8bfb\u53d6 redis\u5bf9\u8c61 \u5b8c\u6210 * * * * * * * * * * * * * * * * ");
                } else {
                    log.info(" * * * * * * * * * * * * * * * * \u672a\u8bfb\u53d6\u5230redis\u5bf9\u8c61 * * * * * * * * * * * * * * * * ");
                }
            }
            catch (Exception redisEx) {
                log.info("\u83b7\u53d6 redis \u914d\u7f6e\u9519\u8bef\uff01\u9519\u8bef\u539f\u56e0\uff1a{}", (Object)redisEx.getMessage());
            }
        }
    }

    public static void loadDBSecurityConfigBean(ApplicationContext context) {
        try {
            if (context.getBean(SafeConstant.SIG_VER_DB_QUERY_OBJ_NAME) != null) {
                SafeConfig.securityInitConfig.put("signVerDbQueryObj", context.getBean(SafeConstant.SIG_VER_DB_QUERY_OBJ_NAME));
                log.info(" * * * * * * * * * * * * * * * * \u83b7\u53d6\u67e5\u8be2\u6570\u636e\u5e93\u914d\u7f6e\u5bf9\u8c61\u5b8c\u6210 * * * * * * * * * * * * * * * * ");
            } else {
                log.info(" * * * * * * * * * * * * * * * * \u672a\u83b7\u53d6\u5230\u67e5\u8be2\u6570\u636e\u5e93\u914d\u7f6e\u5bf9\u8c61 * * * * * * * * * * * * * * * * ");
            }
        }
        catch (Exception dbEx) {
            log.info("\u83b7\u53d6\u67e5\u8be2\u6570\u636e\u5e93\u914d\u7f6e\u5bf9\u8c61\u5931\u8d25\uff01\u9519\u8bef\u539f\u56e0\uff1a{}", (Object)dbEx.getMessage());
        }
    }

    public static void loadProjectKey(String projectCode) {
        if (StringUtils.isNotNull(projectCode) && StringUtils.isEmpty(SafeConfig.PROJECT_CODE_KEY)) {
            log.info("\u52a0\u8f7d\u9879\u76ee\u5b89\u5168\u7f13\u5b58\u6807\u8bc6... \u4f20\u9012\u7cfb\u7edf\u6807\u8bc6\u4e3a\uff1a{}", (Object)projectCode);
            SafeConfig.PROJECT_CODE_KEY = projectCode;
            SafeConfig.PROJECT_SECURITY_KEY = SafeConfig.PROJECT_SECURITY_KEY + projectCode;
            log.info("\u52a0\u8f7d\u9879\u76ee\u5b89\u5168\u7f13\u5b58\u6807\u8bc6\u5b8c\u6210\uff0c\u5f53\u524d\u6807\u8bc6\u4e3a\uff1a{}", (Object)SafeConfig.PROJECT_SECURITY_KEY);
        }
    }

    public static void loadDataVeriConf(boolean verSwitch, String dataVerUrlStr) {
        SafeConfig.VER_SWITCH = verSwitch;
        log.info(" * * * * \u8bbe\u7f6e\u9a8c\u7b7e\u5f00\u5173\uff0c\u5f53\u524d\u5f00\u5173\u72b6\u6001 \uff1a{}", (Object)(SafeConfig.VER_SWITCH ? "\u3010\u5f00\u542f\u3011" : "\u3010\u5173\u95ed\u3011"));
        if (StringUtils.isNotEmpty(dataVerUrlStr)) {
            String[] split;
            log.info(" * * * * \u89e3\u6790\u9a8c\u7b7e\u767d\u540d\u5355 dataVerUrlStr\uff1a{}", (Object)dataVerUrlStr);
            SafeConfig.DATA_INTEGRITY_WHITE_URLS = new HashMap<String, String>();
            for (String s : split = dataVerUrlStr.split(",")) {
                SafeConfig.DATA_INTEGRITY_WHITE_URLS.put(s, null);
            }
            log.info(" * * * * \u52a0\u8f7d\u9a8c\u7b7e\u767d\u540d\u5355\u5b8c\u6210 \u5339\u914d\u5730\u5740\u6761\u6570\uff1a{}", (Object)SafeConfig.DATA_INTEGRITY_WHITE_URLS.size());
        }
    }

    public static void loadXssConf(boolean xssSwitch, String xssUrlStr) {
        SafeConfig.XSS_SWITCH = xssSwitch;
        log.info(" * * * * \u8bbe\u7f6e XSS \u5f00\u5173\uff0c\u5f53\u524d\u5f00\u5173\u72b6\u6001 \uff1a{}", (Object)(SafeConfig.XSS_SWITCH ? "\u3010\u5f00\u542f\u3011" : "\u3010\u5173\u95ed\u3011"));
        if (StringUtils.isNotEmpty(xssUrlStr)) {
            String[] split;
            log.info(" * * * * \u52a0\u8f7dXSS\u767d\u540d\u5355 xssSwitch\uff1a{}, xssUrlStr\uff1a{}", (Object)xssSwitch, (Object)xssUrlStr);
            SafeConfig.XSS_WHITE_URLS = new HashMap<String, String>();
            for (String s : split = xssUrlStr.split(",")) {
                SafeConfig.XSS_WHITE_URLS.put(s, null);
            }
            log.info(" * * * * \u52a0\u8f7dXSS\u767d\u540d\u5355\u5b8c\u6210 \u5339\u914d\u5730\u5740\u6761\u6570\uff1a{}", (Object)SafeConfig.XSS_WHITE_URLS.size());
        }
    }

    public static void loadPhishingConf(boolean phishingSwitch, String phishingUrlStr) {
        SafeConfig.PHISHING_SWITCH = phishingSwitch;
        log.info(" * * * * \u8bbe\u7f6e\u9493\u9c7c\u7f51\u7ad9\u5f00\u5173\uff0c\u5f53\u524d\u5f00\u5173\u72b6\u6001 \uff1a{}", (Object)(SafeConfig.PHISHING_SWITCH ? "\u3010\u5f00\u542f\u3011" : "\u3010\u5173\u95ed\u3011"));
        if (StringUtils.isNotEmpty(phishingUrlStr)) {
            log.info(" * * * * \u52a0\u8f7d\u57df\u540d\u767d\u540d\u5355 phishingSwitch\uff1a{}, phishingUrlStr\uff1a{}", (Object)phishingSwitch, (Object)phishingUrlStr);
            SafeConfig.PHISHING_WHITE_URLS = phishingUrlStr.split(",");
            log.info(" * * * * \u52a0\u8f7d\u57df\u540d\u767d\u540d\u5355\u5b8c\u6210 \u5339\u914d\u5730\u5740\u6761\u6570\uff1a{}", (Object)SafeConfig.PHISHING_WHITE_URLS.length);
        }
    }

    public static void loadRedisTest() {
        if (StringUtils.isNotEmpty(SafeConfig.PROJECT_SECURITY_KEY) && StringUtils.isNotNull(SafeConfig.redisTemplate)) {
            ArrayList<ProSecurityConfig> proSecurityConfigs = new ArrayList<ProSecurityConfig>();
            ProSecurityConfig proSecurityConfig = new ProSecurityConfig();
            proSecurityConfig.setSecurityType(1);
            proSecurityConfig.setSecuritySwitch(ProSecurityConfig.SecuritySwitchEnum.CLOSE.getCode());
            proSecurityConfig.setUrlText("/test,/user/verifyCode4Unifity,/goods/queryGoodsHomeByGoodsType,/goods/queryCatePageByGoodsType,/goods/itme,/goods/thirdStore/queryThirdDetailsByThirdId,/order/pay/aliNotify,/order/pay/wxNotify,/order/pay/doPay,/ardUserLogOut/acceptCancelation,/ardUserLogOut/cancelationNotice,/order/diyOrder/pushOrderCallBack,/content/activity/vote/userVote,/content/activity/signUp/userReplySignUp,/content/activity/survey/userReplySurvey,/upload/uploadFile,/df/pay/aliNotify,/df/pay/wxNotify,/redirectMyOrderListPage,/entertainmentRelay/insertData,,/entertainmentRelay/receiveAliCallback,/entertainmentRelay/logoutNotice,/tengXunYunDianBo/callback,/content/publicActivity/vote/userVote,/content/publicActivity/signUp/userReplySignUp,/content/publicActivity/survey/userReplySurvey,/logisticsCenter/getCustomerAddress,/thirdParty/cakeshop/getCustomerAddress,/test/wlzxResponAddress,/appHomeApplication/unLoginApply,/integral/updateIntegral,/customerInfo/updateBirthday,/customerInfo/updateCardId,/customerInfo/updateNickName,/customerInfo/updateSex,/user/unifiedUserLogin,/order/wxRefundNotify,/order/orderAftersaleRefund,/squareVideo/getOneSquare,/test/getAesStr,/test/testPush,/loveVideo/selection/saveExpertScore,/content/run1550/runInitData,/test/getUnifityTokenAndUserId,/organizationMoney/aliPayOrganizationMoneyAsynchCall,/test/testGetElectricCarLoginURL,/organizationMoney/weiXinPayOrganizationMoneyAsynchCall,/goods/es/addAllGoodsToEs,/ardUserLogOut/acceptSyncCancellation,/ardUserLogOut/syncCancellationNotice,/user/bindingCouponLogin,/user/send/bindCouponLoginSendVerifyCode,/user/querycustomer,/ticket/veriTicketCard,/goods/cart/queryMyCartList,/goods/es/queryGoods,/thirdCustomer/bandThirdCustomer,/newAdvice/findListByType,/content/proposal/proposalList,/ghw-topic/listPage,/counsel/law/list,/user/unifiedUserRegistry,/user/unifiedUserLogin,/user/send/smsverifycode,/user/querycustomer,/order/queryOrderListByCuId,/goods/cart/queryMyCartList,/goods/cart/queryMyCartList,/org/questionnaire/batchInsertOrUpdateQuestionnaireItem,/org/questionnaire/insertQuestionnaireItemReply,/goods/es/keysLenovoSearch,/mutualAssistance/getUserInfo,/mutualAssistance/getMutualAssistanceUrl,/mutualAssistance/unionMember/validate,/thirdCustomer/thidUserAuth");
            proSecurityConfigs.add(proSecurityConfig);
            proSecurityConfig = new ProSecurityConfig();
            proSecurityConfig.setSecurityType(2);
            proSecurityConfig.setSecuritySwitch(ProSecurityConfig.SecuritySwitchEnum.CLOSE.getCode());
            proSecurityConfig.setUrlText("/test,/user/verifyCode4Unifity,/goods/queryGoodsHomeByGoodsType,/goods/queryCatePageByGoodsType,/goods/itme,/goods/thirdStore/queryThirdDetailsByThirdId,/order/pay/aliNotify,/order/pay/wxNotify,/order/pay/doPay,/ardUserLogOut/acceptCancelation,/ardUserLogOut/cancelationNotice,/order/diyOrder/pushOrderCallBack,/content/activity/vote/userVote,/content/activity/signUp/userReplySignUp,/content/activity/survey/userReplySurvey,/upload/uploadFile,/df/pay/aliNotify,/df/pay/wxNotify,/redirectMyOrderListPage,/entertainmentRelay/insertData,,/entertainmentRelay/receiveAliCallback,/entertainmentRelay/logoutNotice,/tengXunYunDianBo/callback,/content/publicActivity/vote/userVote,/content/publicActivity/signUp/userReplySignUp,/content/publicActivity/survey/userReplySurvey,/logisticsCenter/getCustomerAddress,/thirdParty/cakeshop/getCustomerAddress,/test/wlzxResponAddress,/appHomeApplication/unLoginApply,/integral/updateIntegral,/customerInfo/updateBirthday,/customerInfo/updateCardId,/customerInfo/updateNickName,/customerInfo/updateSex,/user/unifiedUserLogin,/order/wxRefundNotify,/order/orderAftersaleRefund,/squareVideo/getOneSquare,/test/getAesStr,/test/testPush,/loveVideo/selection/saveExpertScore,/content/run1550/runInitData,/test/getUnifityTokenAndUserId,/organizationMoney/aliPayOrganizationMoneyAsynchCall,/test/testGetElectricCarLoginURL,/organizationMoney/weiXinPayOrganizationMoneyAsynchCall,/goods/es/addAllGoodsToEs,/ardUserLogOut/acceptSyncCancellation,/ardUserLogOut/syncCancellationNotice,/user/bindingCouponLogin,/user/send/bindCouponLoginSendVerifyCode,/user/querycustomer,/ticket/veriTicketCard,/goods/cart/queryMyCartList,/goods/es/queryGoods,/thirdCustomer/bandThirdCustomer,/newAdvice/findListByType,/content/proposal/proposalList,/ghw-topic/listPage,/counsel/law/list,/user/unifiedUserRegistry,/user/unifiedUserLogin,/user/send/smsverifycode,/user/querycustomer,/order/queryOrderListByCuId,/goods/cart/queryMyCartList,/goods/cart/queryMyCartList,/org/questionnaire/batchInsertOrUpdateQuestionnaireItem,/org/questionnaire/insertQuestionnaireItemReply,/goods/es/keysLenovoSearch,/mutualAssistance/getUserInfo,/mutualAssistance/getMutualAssistanceUrl,/mutualAssistance/unionMember/validate,/thirdCustomer/thidUserAuth");
            proSecurityConfigs.add(proSecurityConfig);
            proSecurityConfig = new ProSecurityConfig();
            proSecurityConfig.setSecurityType(3);
            proSecurityConfig.setSecuritySwitch(ProSecurityConfig.SecuritySwitchEnum.CLOSE.getCode());
            proSecurityConfig.setUrlText("zjmiec,www.w3.org,122.224.52.207,itegou.com,gh,boss,union,love,platform,http://h5ip.cn/rtsa,airudian,media.w3.org,mirror.aarnet.edu.au,vfx.mtime.cn,v.qq.com,v.smtcdns.com,vhot2.qqvideo.tc.qq.com,v.youku.com,a.xiumi.us,x.eqxiu.com,mp.weixin.qq.com,39.98.177.132,www.wenjuan.top,item.jd.com,detail.tmall.com,720yun,www.expoon.com,720yun.com,tencent.com,eqvrar.com,vrnews.v.cctv.com,aomenvr.peopleapp.com,vod2,cbt.shangjin618.com,cbt.shangjin618.com/lianxin-botserver/openApi/gotoPsyBot?http://cbt.shangjin618.com/lianxin-botserver/openApi/gotoPsyBot?channel=AIRUDIANAPP&chnlCode=8BFE42DF24C45563B5EA6E82C66FE90989C8681F9D7CE0D86997CE6608A023406D025BCBF4A61E9D862489B9A9C0B1711C&unionId=135****9287&userName=\u8fe6\u697c\u7f57&userIcon=https%3A%2F%2Fairudian.oss-cn-hangzhou.aliyuncs.com%2F20190326%2FIMG_3f9438062ec14f588b343c37fa4cabcb.jpg");
            proSecurityConfigs.add(proSecurityConfig);
            SafeConfig.redisTemplate.opsForValue().set((Object)SafeConfig.PROJECT_SECURITY_KEY, (Object)JSON.toJSONString(proSecurityConfigs), 10L, TimeUnit.DAYS);
        }
    }
}

