/*
 * Decompiled with CFR 0.152.
 */
package com.ard.security.config.model;

import com.ard.security.utils.StringUtils;
import com.ard.security.utils.ip.IpUtils;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;

public class ClientInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String clientType;
    private String requestAddr;
    private String requestIP;

    public ClientInfo(HttpServletRequest request) {
        if (!StringUtils.isNull(request)) {
            this.clientType = request.getHeader("user-agent");
            this.requestAddr = request.getServletPath();
            this.requestIP = IpUtils.getIpAddr(request);
        }
    }

    public String getClientType() {
        return this.clientType;
    }

    public void setClientType(String clientType) {
        this.clientType = clientType;
    }

    public String getRequestAddr() {
        return this.requestAddr;
    }

    public void setRequestAddr(String requestAddr) {
        this.requestAddr = requestAddr;
    }

    public String getRequestIP() {
        return this.requestIP;
    }

    public void setRequestIP(String requestIP) {
        this.requestIP = requestIP;
    }
}

