/*
 * Decompiled with CFR 0.152.
 */
package com.ard.security.exception;

import com.alibaba.fastjson.JSON;
import com.ard.security.config.model.ClientInfo;
import com.ard.security.config.status.SecurityStatus;
import com.ard.security.utils.StringUtils;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityAuthException
extends RuntimeException {
    private static final Logger log = LoggerFactory.getLogger(SecurityAuthException.class);
    private static final long serialVersionUID = 1L;
    private ClientInfo clientInfo;
    private SecurityStatus securityStatus;

    public SecurityAuthException(HttpServletRequest request, SecurityStatus securityStatus) {
        this.clientInfo = new ClientInfo(request);
        this.securityStatus = securityStatus;
        log.warn("\u5b89\u5168\u8ba4\u8bc1\u5931\u8d25\uff01 \u5ba2\u6237\u7aef\u4fe1\u606f\uff1a{},\u9519\u8bef\u7f16\u7801\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", new Object[]{JSON.toJSONString((Object)this.clientInfo), securityStatus.getCode(), securityStatus.getMsg()});
    }

    @Override
    public String getMessage() {
        StringBuilder message = new StringBuilder();
        if (!StringUtils.isNull(this.clientInfo)) {
            message.append("\u5b89\u5168\u8ba4\u8bc1\u5931\u8d25\uff01 \u5ba2\u6237\u7aef\u4fe1\u606f\uff1a").append(JSON.toJSONString((Object)this.clientInfo));
            message.append(" \u9519\u8bef\u4fe1\u606f\uff1a").append(JSON.toJSONString((Object)this.securityStatus));
        }
        return message.toString();
    }

    public ClientInfo getClientInfo() {
        return this.clientInfo;
    }

    public SecurityStatus getSecurityStatus() {
        return this.securityStatus;
    }
}

