/*
 * Decompiled with CFR 0.152.
 */
package com.ard.security.filter.sign;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ard.security.config.LoadSecurityConfig;
import com.ard.security.config.SafeConfig;
import com.ard.security.config.status.SecurityStatus;
import com.ard.security.domain.AjaxResult;
import com.ard.security.exception.SecurityAuthException;
import com.ard.security.utils.StringUtils;
import com.ard.security.utils.sign.SignCommon;
import com.ard.security.utils.sm3.SM3Digest;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class DataVerificationFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(DataVerificationFilter.class);

    public DataVerificationFilter() {
    }

    public DataVerificationFilter(Map<String, Object> securityInitConfig) {
        if (securityInitConfig.containsKey("projectCode")) {
            LoadSecurityConfig.loadProjectKey(String.valueOf(securityInitConfig.get("projectCode")));
        }
        LoadSecurityConfig.loadDataVeriConf(Boolean.valueOf(String.valueOf(securityInitConfig.get("dataVerSwitch"))), String.valueOf(securityInitConfig.get("dataUrlsStr")));
    }

    public void init(FilterConfig filterConfig) {
        log.info(" * * * * * * * * * * * * * * * * \u521d\u59cb\u5316\u9a8c\u7b7e\u8fc7\u6ee4\u5668 * * * * * * * * * * * * * * * * ");
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)filterConfig.getServletContext());
        LoadSecurityConfig.loadRedis((ApplicationContext)context);
        LoadSecurityConfig.loadDBSecurityConfigBean((ApplicationContext)context);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String url = request.getServletPath();
        if (!"POST".equalsIgnoreCase(request.getMethod()) || !SafeConfig.VER_SWITCH || SafeConfig.DATA_INTEGRITY_WHITE_URLS.containsKey(url)) {
            filterChain.doFilter(servletRequest, servletResponse);
        } else {
            try {
                this.dataIntegrityVerification(request);
                filterChain.doFilter(servletRequest, servletResponse);
            }
            catch (SecurityAuthException e) {
                this.outWriter((HttpServletResponse)servletResponse, e);
            }
        }
    }

    public void destroy() {
        log.info("= = = = = = = = = = = = = = = \u9500\u6bc1\u9a8c\u7b7e\u8fc7\u6ee4\u5668 = = = = = = = = = = = = = = ");
    }

    public void dataIntegrityVerification(HttpServletRequest request) {
        Map map = request.getParameterMap();
        if (null == map && map.size() < 1) {
            throw new SecurityAuthException(request, SecurityStatus.CODE_10003);
        }
        if (StringUtils.isNull(map.get("sign_cf")) || StringUtils.isEmpty(((String[])map.get("sign_cf"))[0])) {
            throw new SecurityAuthException(request, SecurityStatus.CODE_10008);
        }
        String apiSignCf = ((String[])map.get("sign_cf"))[0];
        this.verificationRequest(request, apiSignCf);
        if (StringUtils.isNull(map.get("sign_yq")) || StringUtils.isEmpty(((String[])map.get("sign_yq"))[0])) {
            throw new SecurityAuthException(request, SecurityStatus.CODE_10008);
        }
        String apiSignYq = ((String[])map.get("sign_yq"))[0];
        String requstParam = this.generateSignData(apiSignCf, JSON.toJSONString((Object)map));
        try {
            String backSign = SM3Digest.sm3Digest(requstParam);
            if (!apiSignYq.equalsIgnoreCase(backSign)) {
                log.info("\u5f53\u524d\u8bf7\u6c42\u8def\u5f84\uff1a{}, \u6570\u636e\u4e3a\uff1a{}", (Object)request.getServletPath(), (Object)JSONObject.toJSONString((Object)request.getParameterMap()));
                log.info("\u540e\u53f0\u751f\u4ea7\u53c2\u6570\uff1a{}", (Object)requstParam);
                log.info("\u524d\u53f0\u9a8c\u7b7e\u6570\u636e\u4e3a\uff1a{}", (Object)apiSignYq);
                log.info("\u540e\u53f0\u9a8c\u7b7e\u6570\u636e\u4e3a\uff1a{}", (Object)backSign);
                throw new SecurityAuthException(request, SecurityStatus.CODE_10004);
            }
        }
        catch (Exception e) {
            throw new SecurityAuthException(request, SecurityStatus.CODE_10005);
        }
    }

    private String generateSignData(String signCf, String reqParam) {
        JSONObject obj = JSONObject.parseObject((String)reqParam);
        obj.remove((Object)"sign_yq");
        reqParam = SignCommon.replaceParam(signCf, JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.MapSortField}));
        return reqParam;
    }

    public void verificationRequest(HttpServletRequest request, String sign_cf) {
        if (SafeConfig.redisTemplate != null) {
            if (SafeConfig.redisTemplate.hasKey((Object)sign_cf).booleanValue()) {
                log.error(sign_cf + " \uff1a\u5df2\u5b58\u5728\uff01");
                throw new SecurityAuthException(request, SecurityStatus.CODE_10007);
            }
            SafeConfig.redisTemplate.opsForValue().set((Object)sign_cf, null, 180L, TimeUnit.SECONDS);
        }
    }

    public void outWriter(HttpServletResponse response, SecurityAuthException e) throws IOException {
        response.setContentType("text/json; charset=UTF-8");
        response.getWriter().write(JSON.toJSONString((Object)AjaxResult.error(e.getSecurityStatus().getCode(), e.getSecurityStatus().getMsg())));
        response.flushBuffer();
    }
}

