/*
 * Decompiled with CFR 0.152.
 */
package com.ard.security.filter.xss;

import com.ard.security.config.SafeConfig;
import com.ard.security.utils.StringUtils;
import com.ard.security.utils.date.DateHelper;
import com.ard.security.utils.ip.IpUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringEscapeUtils;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AntiSamyFilter {
    private static final Logger log = LoggerFactory.getLogger(AntiSamyFilter.class);
    public static final int FLAG_START = 1;
    public static final int FLAG_CLOSE = 0;
    private static final String ANTISAMY_SLASHDOT = "antisamy-slashdot.xml";
    private static final String ANTISAMY_EBAY = "security/antisamy-ebay.xml";
    private static final String ANTISAMY_MYSPACE = "antisamy-myspace.xml";
    private static final String ANTISAMY_ANYTHINGGOES = "antisamy-anythinggoes.xml";
    private static final String ANTISAMY_TINYMCE = "antisamy-tinymce.xml";
    private static final String ANTISAMY_DEFAULT = "antisamy.xml";
    public static String requestUrl;
    private static Policy policy;
    private static String[] jsEvents;
    private static String jsEventsRegex;
    private static final int Max_rounds = 200;

    private static String xssReplace(String value) {
        try {
            Pattern scriptPattern = null;
            scriptPattern = Pattern.compile("eval\\((.*?)\\)", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("e\u00adxpression\\((.*?)\\)", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("javascript:", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("vbscript:", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("--");
            value = scriptPattern.matcher(value).replaceAll("\uff0d\uff0d");
            scriptPattern = Pattern.compile(";");
            value = scriptPattern.matcher(value).replaceAll("\uff1b");
            scriptPattern = Pattern.compile(".*on(.*?)=", 42);
            if (scriptPattern.matcher(value).lookingAt()) {
                scriptPattern = Pattern.compile(jsEventsRegex, 42);
                value = scriptPattern.matcher(value).replaceAll("");
            }
        }
        catch (Exception e) {
            log.error("\u6b63\u5219\u5904\u7406xss \u5f02\u5e38,\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
            return value;
        }
        return value;
    }

    public static String cleanXss(String value, HttpServletRequest request, int rounds) {
        if (!SafeConfig.XSS_SWITCH || StringUtils.isEmpty(value)) {
            return value;
        }
        String initValue = null;
        String equalsValue = null;
        String cleanValue = value;
        try {
            cleanValue = StringEscapeUtils.unescapeHtml((String)cleanValue);
            initValue = cleanValue.replaceAll("\\s", "");
            cleanValue = AntiSamyFilter.xssReplace(cleanValue);
            AntiSamy antiSamy = new AntiSamy();
            CleanResults cr = antiSamy.scan(cleanValue, policy);
            cleanValue = cr.getCleanHTML();
            cleanValue = StringEscapeUtils.unescapeHtml((String)cleanValue).replaceAll("\n", " ").trim();
            equalsValue = cleanValue.replaceAll("\\s", "");
            if (!initValue.equals(equalsValue)) {
                if (++rounds < 200) {
                    cleanValue = AntiSamyFilter.cleanXss(cleanValue, request, rounds);
                }
                String currentDateTime = DateHelper.getCurrentDateTime();
                String clientIp = StringUtils.isNull(request) ? "\u672a\u83b7\u53d6request" : IpUtils.getIpAddr(request);
                log.error("XSS\u653b\u51fb\u4fe1\u606f==> \u653b\u51fb\u8005\u8005IP\uff1a{}\r\n\u653b\u51fb\u65f6\u95f4\uff1a{}\r\n\u8fc7\u6ee4\u524d\u5185\u5bb9\u957f\u5ea6\uff1a{}\r\n\u8fc7\u6ee4\u540e\u5185\u5bb9\u957f\u5ea6\uff1a{}", new Object[]{clientIp, currentDateTime, value.length(), cleanValue.length()});
            }
        }
        catch (PolicyException | ScanException e) {
            log.error("xssClean Exception==>\uff1a{}", (Object)e.getMessage());
        }
        return cleanValue;
    }

    static {
        jsEvents = new String[]{"onabort", "onblur", "onchange", "onclick", "ondblclick", "onerror", "onfocus", "onkeydown", "onkeypress", "onkeyup", "onload", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "onreset", "onresize", "onselect", "onsubmit", "onunload"};
        jsEventsRegex = "";
        int len = jsEvents.length;
        for (int i = 0; i < len; ++i) {
            jsEventsRegex = i == len - 1 ? jsEventsRegex + ".*" + jsEvents[i] + "(.*?)=" : jsEventsRegex + ".*" + jsEvents[i] + "(.*?)=|";
        }
        InputStream inputStream = AntiSamyFilter.class.getClassLoader().getResourceAsStream(ANTISAMY_EBAY);
        try {
            if (null != inputStream) {
                policy = Policy.getInstance((InputStream)inputStream);
            }
        }
        catch (PolicyException e) {
            log.error("XssFilter - static policy instance error. PolicyException==>");
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error(e.getLocalizedMessage());
                }
            }
        }
    }
}

