/*
 * Decompiled with CFR 0.152.
 */
package com.ard.security.filter.xss;

import com.ard.security.config.LoadSecurityConfig;
import com.ard.security.config.SafeConfig;
import com.ard.security.filter.xss.XSSRequestWrapper;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XSSFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(XSSFilter.class);

    public XSSFilter() {
    }

    public XSSFilter(boolean xssSwitch, String xssUrlsStr) {
        LoadSecurityConfig.loadXssConf(xssSwitch, xssUrlsStr);
    }

    public XSSFilter(boolean xssSwitch, String xssUrlsStr, boolean phishingSwitch, String phishingUrlsStr) {
        LoadSecurityConfig.loadXssConf(xssSwitch, xssUrlsStr);
        LoadSecurityConfig.loadPhishingConf(phishingSwitch, phishingUrlsStr);
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (SafeConfig.XSS_SWITCH && !SafeConfig.XSS_WHITE_URLS.containsKey(httpRequest.getRequestURI())) {
            chain.doFilter((ServletRequest)new XSSRequestWrapper(httpRequest), response);
        } else {
            chain.doFilter((ServletRequest)httpRequest, response);
        }
    }

    public void destroy() {
        log.info("- - - - - - - - - \u9500\u6bc1xssFilter - - - - - - - - - - - ");
    }
}

