/*
 * Decompiled with CFR 0.152.
 */
package com.ard.security.filter.xss;

import com.ard.security.filter.xss.AntiSamyFilter;
import com.ard.security.utils.StringUtils;
import com.ard.security.utils.date.DateHelper;
import com.ard.security.utils.ip.IpUtils;
import com.ard.security.utils.xss.phishing.DomainNameHelper;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class XSSRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger log = LoggerFactory.getLogger(XSSRequestWrapper.class);

    public XSSRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public Map<String, String[]> getParameterMap() {
        Map request_map = super.getParameterMap();
        Iterator iterator = request_map.entrySet().iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                Map.Entry me = iterator.next();
                String[] values = (String[])me.getValue();
                for (int i = 0; i < values.length; ++i) {
                    values[i] = this.xssClean(values[i]);
                }
            }
        }
        return request_map;
    }

    public String getQueryString() {
        return this.xssClean(super.getQueryString());
    }

    public String[] getParameterValues(String parameter) {
        String[] values = super.getParameterValues(parameter);
        if (values == null) {
            return values;
        }
        int count = values.length;
        String[] encodedValues = new String[count];
        for (int i = 0; i < count; ++i) {
            encodedValues[i] = this.xssClean(values[i]);
        }
        return encodedValues;
    }

    public String getParameter(String parameter) {
        String value = super.getParameter(parameter);
        if (StringUtils.isNotEmpty(value)) {
            return this.xssClean(value);
        }
        return null;
    }

    private String xssClean(String value) {
        value = AntiSamyFilter.cleanXss(value, this.getHttpServletRequest(), 0);
        value = this.clearPhishing(value, this.getHttpServletRequest());
        return value;
    }

    public String clearPhishing(String fhishingUrl, HttpServletRequest request) {
        String fhishingDomainName;
        String requestDomainName;
        String initial = fhishingUrl;
        if (StringUtils.isEmpty(fhishingUrl)) {
            return fhishingUrl;
        }
        if (!DomainNameHelper.isDomainName(fhishingUrl)) {
            return fhishingUrl;
        }
        if (!StringUtils.isNull(request) && (requestDomainName = DomainNameHelper.getDomainName(request.getRequestURL().toString()).toLowerCase(Locale.ENGLISH)).equals(fhishingDomainName = DomainNameHelper.getDomainName(fhishingUrl).toLowerCase(Locale.ENGLISH))) {
            return fhishingUrl;
        }
        String oldFhishingUrl = fhishingUrl;
        if (!initial.equals(fhishingUrl = DomainNameHelper.cleanDomainName(fhishingUrl))) {
            String clientIp = IpUtils.getIpAddr(request);
            log.error("\u9493\u9c7c\u7f51\u7ad9\u4fe1\u606f==> \u653b\u51fb\u8005\u8005IP\uff1a{}\n\u653b\u51fb\u65f6\u95f4\uff1a{}\n\u8fc7\u6ee4\u524d\u5185\u5bb9\uff1a{}\n\u8fc7\u6ee4\u540e\u5185\u5bb9\uff1a{}", new Object[]{clientIp, DateHelper.getCurrentDateTime(), oldFhishingUrl, fhishingUrl});
        }
        return fhishingUrl;
    }

    public static String clearPhishing(String fhishingUrl) {
        String initial = fhishingUrl;
        if (StringUtils.isEmpty(fhishingUrl)) {
            return fhishingUrl;
        }
        if (!DomainNameHelper.isDomainName(fhishingUrl)) {
            return fhishingUrl;
        }
        String oldFhishingUrl = fhishingUrl;
        if (!initial.equals(fhishingUrl = DomainNameHelper.cleanDomainName(fhishingUrl))) {
            log.error("\u9493\u9c7c\u7f51\u7ad9\u4fe1\u606f==> \u653b\u51fb\u65f6\u95f4\uff1a{}\n\u8fc7\u6ee4\u524d\u5185\u5bb9\uff1a{}\n\u8fc7\u6ee4\u540e\u5185\u5bb9\uff1a{}", new Object[]{DateHelper.getCurrentDateTime(), oldFhishingUrl, fhishingUrl});
        }
        return fhishingUrl;
    }

    private HttpServletRequest getHttpServletRequest() {
        return (HttpServletRequest)super.getRequest();
    }
}

