/*
 * Decompiled with CFR 0.152.
 */
package com.ard.security.quartz;

import com.alibaba.fastjson.JSON;
import com.ard.security.config.LoadSecurityConfig;
import com.ard.security.config.SafeConfig;
import com.ard.security.config.SafeConstant;
import com.ard.security.config.model.ProSecurityConfig;
import com.ard.security.utils.StringUtils;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class SecurityTask {
    private static final Logger log = LoggerFactory.getLogger(SecurityTask.class);

    @Scheduled(cron="0 0/5 * * * ?")
    public void securityConfigTask() {
        this.loadSecurityConfig();
    }

    public static void loadSecurityConfig() {
        if (StringUtils.isNotEmpty(SafeConfig.PROJECT_CODE_KEY)) {
            long start = System.currentTimeMillis();
            log.info("- - - - - - - - - - - - \u8fdb\u5165\u540c\u6b65\u7cfb\u7edf\u5b89\u5168\u914d\u7f6e- - - \u5f53\u524d\u9879\u76ee\u7f13\u5b58key:({}) - - - - - - - ", (Object)SafeConfig.PROJECT_SECURITY_KEY);
            String pscStr = null;
            try {
                if (StringUtils.isNotNull(SafeConfig.redisTemplate)) {
                    pscStr = (String)SafeConfig.redisTemplate.opsForValue().get((Object)SafeConfig.PROJECT_SECURITY_KEY);
                }
                if (StringUtils.isEmpty(pscStr)) {
                    pscStr = SecurityTask.executeDatabaseQuery();
                }
                if (StringUtils.isNotNull(pscStr)) {
                    List projectSecurityConfigs = JSON.parseArray((String)pscStr, ProSecurityConfig.class);
                    SecurityTask.analysisOfSecurityConfiguration(projectSecurityConfigs);
                }
            }
            catch (Exception ex) {
                log.error("\u89e3\u6790\u5b89\u5168\u914d\u7f6e\u51fa\u9519,\u89e3\u6790\u6570\u636e\u4e3a\uff1a{}\uff0c\u9519\u8bef\u539f\u56e0\uff1a{}", (Object)pscStr, (Object)ex.getMessage());
            }
            long end = System.currentTimeMillis();
            log.info("- - - - - \u5b89\u5168\u914d\u7f6e\u52a0\u8f7d\u5b8c\u6210 - -  - - \u8fd0\u884c\u65f6\u95f4\uff1a{} \r ", (Object)(end - start));
        }
    }

    private static String executeDatabaseQuery() {
        String proConfingObjStr = null;
        log.info("\u7f13\u5b58\u672a\u83b7\u53d6\u5230\u6570\u636e\uff0c\u6267\u884c\u6570\u636e\u5e93\u540c\u6b65\uff1a\u5f53\u524d\u67e5\u8be2 KEY\uff1a{}", (Object)SafeConfig.PROJECT_SECURITY_KEY);
        if (!SafeConfig.securityInitConfig.containsKey("signVerDbQueryObj") || StringUtils.isNull(SafeConfig.securityInitConfig.get("signVerDbQueryObj"))) {
            return null;
        }
        try {
            Method proSecurityConfig = SafeConfig.securityInitConfig.get("signVerDbQueryObj").getClass().getDeclaredMethod(SafeConstant.SIG_VER_DB_QUERY_OBJ_METHOD_NAME, String.class);
            if (StringUtils.isNotNull(proSecurityConfig)) {
                proSecurityConfig.setAccessible(true);
                Object proConfigObj = null;
                proConfigObj = proSecurityConfig.invoke(SafeConfig.securityInitConfig.get("signVerDbQueryObj"), SafeConfig.PROJECT_CODE_KEY);
                if (StringUtils.isNotNull(proConfigObj)) {
                    proConfingObjStr = JSON.toJSONString((Object)proConfigObj);
                    log.info("\u83b7\u53d6\u5b89\u5168\u914d\u7f6e\u4e3a\uff1a{}", (Object)proConfingObjStr);
                    if (StringUtils.isNotNull(SafeConfig.redisTemplate)) {
                        SafeConfig.redisTemplate.opsForValue().set((Object)SafeConfig.PROJECT_SECURITY_KEY, (Object)proConfingObjStr, 10L, TimeUnit.MINUTES);
                        log.info("\u7f13\u5b58\u9879\u76ee\u5b89\u5168\u914d\u7f6e\u6267\u884c\u5b8c\u6210");
                    }
                }
            }
            return proConfingObjStr;
        }
        catch (Exception e) {
            log.info("\u6267\u884c\u6570\u636e\u5e93\u67e5\u8be2\u5e76\u7f13\u5b58\u914d\u7f6e\u9519\u8bef\uff1a\u9519\u8bef\u539f\u56e0\uff1a{}", (Object)e.getMessage());
            return null;
        }
    }

    private static void analysisOfSecurityConfiguration(List<ProSecurityConfig> projectSecurityConfigs) {
        if (StringUtils.isNotNull(projectSecurityConfigs) && projectSecurityConfigs.size() > 0) {
            projectSecurityConfigs.forEach(psConfig -> {
                try {
                    if (StringUtils.isNotNull(psConfig)) {
                        boolean securitySwitch;
                        log.info("\u89e3\u6790\u5f53\u524d\u914d\u7f6e\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)psConfig));
                        boolean bl = securitySwitch = psConfig.getSecuritySwitch() == 0;
                        if (psConfig.getSecurityType() == ProSecurityConfig.SecurityTypeEnum.DATA_VER_TYPE.getCode()) {
                            LoadSecurityConfig.loadDataVeriConf(securitySwitch, psConfig.getUrlText());
                        } else if (psConfig.getSecurityType() == ProSecurityConfig.SecurityTypeEnum.XSS_TEYPE.getCode()) {
                            LoadSecurityConfig.loadXssConf(securitySwitch, psConfig.getUrlText());
                        } else if (psConfig.getSecurityType() == ProSecurityConfig.SecurityTypeEnum.DOMAIN_TYPE.getCode()) {
                            LoadSecurityConfig.loadPhishingConf(securitySwitch, psConfig.getUrlText());
                        }
                    }
                }
                catch (Exception e) {
                    log.error("\u89e3\u6790\u5b89\u5168\u914d\u7f6e\u5f02\u5e38\uff01\u5f53\u524d\u6570\u636e\uff1a{},\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)psConfig), (Object)e.getMessage());
                }
            });
        } else {
            log.info("- - - - - \u672a\u83b7\u53d6\u9879\u76ee\u6807\u8bc6\u4e3a\uff1a({})\u5b89\u5168\u914d\u7f6e\u6570\u636e - - - - - - ", (Object)SafeConfig.PROJECT_CODE_KEY);
        }
    }
}

