/*
 * Decompiled with CFR 0.152.
 */
package com.ard.security.utils.date;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateHelper {
    private static final Logger log = LoggerFactory.getLogger(DateHelper.class);
    public static final String Y_M_D = "yyyy-MM-dd";
    public static final String Y_M_DHHMMSS = "yyyy-MM-dd HH:mm:ss";
    public static final String YMD = "yyyyMMdd";

    public static Date getDateFormat(Date date, String pattern) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat(pattern);
            String dateString = formatter.format(date);
            return formatter.parse(dateString);
        }
        catch (ParseException e) {
            log.error(e.getLocalizedMessage());
            throw new RuntimeException("\u83b7\u53d6\u6307\u5b9a\u7684\u65e5\u671f\u683c\u5f0f\u9519\u8bef", e);
        }
    }

    public static String getStringPattern(Date date, String pattern) {
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        return formatter.format(date);
    }

    public static Date getBeforeDay(Date date, int dayNumber) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, -dayNumber);
        return cal.getTime();
    }

    public static Date getAfterDay(Date date, int Day) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, Day);
        return cal.getTime();
    }

    public static Date parseStringToDate(String formatString, String pattern) {
        try {
            return new SimpleDateFormat(pattern).parse(formatString);
        }
        catch (ParseException e) {
            log.error(e.getLocalizedMessage());
            throw new RuntimeException("\u65e5\u671f\u4e3a\u7a7a\u6216\u683c\u5f0f\u4e0d\u6b63\u786e", e);
        }
    }

    public static String formatToyyyyMMdd(Date date) {
        return new SimpleDateFormat(YMD).format(date);
    }

    public static String formatToyyyyMMddHHmmss(Date date) {
        return new SimpleDateFormat(Y_M_DHHMMSS).format(date);
    }

    public static boolean isExprie(Date playingTime) {
        if (playingTime != null) {
            return !playingTime.after(new Date());
        }
        return false;
    }

    public static String getYear(Date time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        return String.valueOf(cal.get(1));
    }

    public static String getMonth(Date time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        return String.valueOf(cal.get(2) + 1);
    }

    public static String getDay(Date time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        return String.valueOf(cal.get(5));
    }

    public static String getChineDay(Date time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        StringBuilder str = new StringBuilder();
        str.append(cal.get(1)).append("\u5e74").append(cal.get(2) + 1).append("\u6708").append(cal.get(5)).append("\u65e5");
        return str.toString();
    }

    public static int subDay(Date minuend, Date subtrahend) {
        long diff = minuend.getTime() - subtrahend.getTime();
        int diffDay = (int)(diff / 1000L / 60L / 60L / 24L);
        return diffDay;
    }

    public static String format(Date date) {
        return new SimpleDateFormat(Y_M_DHHMMSS).format(date);
    }

    public static String format(Date date, String format) {
        return new SimpleDateFormat(format).format(date);
    }

    public static String formatShort(Date date) {
        return new SimpleDateFormat(Y_M_D).format(date);
    }

    public static String getDayToWeek(Date playingTime) {
        if (playingTime != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(playingTime);
            int day = cal.get(7);
            switch (day) {
                case 1: {
                    return "\u5468\u65e5";
                }
                case 2: {
                    return "\u5468\u4e00";
                }
                case 3: {
                    return "\u5468\u4e8c";
                }
                case 4: {
                    return "\u5468\u4e09";
                }
                case 5: {
                    return "\u5468\u56db";
                }
                case 6: {
                    return "\u5468\u4e94";
                }
                case 7: {
                    return "\u5468\u516d";
                }
            }
        }
        return "";
    }

    public static Date getBeforeHoursTime(Date date, int d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(10, -d);
        return cal.getTime();
    }

    public static Long calculateDifferenceMinute(Date endTime, Date beginTime) {
        long millSeconds = endTime.getTime() - beginTime.getTime();
        return millSeconds / 1000L / 60L;
    }

    public static Long calculateDifferenceSecond(Date endTime, Date beginTime) {
        long millSeconds = endTime.getTime() - beginTime.getTime();
        return millSeconds / 1000L;
    }

    public static Date parseFormatToDate(String dateStr, String dateFormat) {
        SimpleDateFormat simpleDate = new SimpleDateFormat(dateFormat);
        Date date = null;
        try {
            date = simpleDate.parse(dateStr);
        }
        catch (ParseException e) {
            log.error(e.getLocalizedMessage());
        }
        return date;
    }

    public static Date addDate(Date date, Integer cal, Integer num) {
        Calendar rightNow = Calendar.getInstance();
        rightNow.setTime(date);
        if (cal == 1) {
            rightNow.add(13, num);
        } else if (cal == 2) {
            rightNow.add(12, num);
        } else if (cal == 3) {
            rightNow.add(10, num);
        } else if (cal == 4) {
            rightNow.add(5, num);
        } else if (cal == 5) {
            rightNow.add(2, num);
        } else if (cal == 6) {
            rightNow.add(1, num);
        }
        return rightNow.getTime();
    }

    public static long addDate(Long date, Integer cal, Integer num) {
        Calendar rightNow = Calendar.getInstance();
        rightNow.setTime(new Date(date));
        if (cal == 1) {
            rightNow.add(13, num);
        } else if (cal == 2) {
            rightNow.add(12, num);
        } else if (cal == 3) {
            rightNow.add(10, num);
        } else if (cal == 4) {
            rightNow.add(5, num);
        } else if (cal == 5) {
            rightNow.add(2, num);
        } else if (cal == 6) {
            rightNow.add(1, num);
        }
        return rightNow.getTime().getTime();
    }

    public static Date parseLongToDate(Long time) throws ParseException {
        SimpleDateFormat simpleDate = new SimpleDateFormat(Y_M_DHHMMSS);
        String dateStr = simpleDate.format(time);
        return simpleDate.parse(dateStr);
    }

    public static String getCurrentDateTime() {
        LocalDateTime localDateTime = LocalDateTime.now();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(Y_M_DHHMMSS);
        String dateTime = dateTimeFormatter.format(localDateTime);
        return dateTime;
    }

    public static boolean sameDay(Date date1, Date date2) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(date1);
        int d1 = instance.get(6);
        instance.setTime(date2);
        int d2 = instance.get(6);
        return d1 == d2;
    }

    public static boolean isYesterday(Date date1, Date date2) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(date1);
        int d1 = instance.get(6);
        instance.setTime(date2);
        int d2 = instance.get(6);
        return d1 - d2 == 1 || d2 - d1 == 1;
    }

    public static boolean sameYear(Date date1, Date date2) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(date1);
        int year1 = instance.get(1);
        instance.setTime(date2);
        int year2 = instance.get(1);
        return year1 == year2;
    }

    public static Date getPreviousMonday() {
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        cal.add(5, -7);
        cal.set(7, 2);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getPreviousSunday() {
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        cal.add(5, -7);
        cal.set(7, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getPreviousMonthFirst() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        calendar.set(5, calendar.getActualMinimum(5));
        return calendar.getTime();
    }

    public static Date getPreviousMonthEnd() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    public static String getDatePoor(Date endDate, Date nowDate) {
        long nd = 86400000L;
        long nh = 3600000L;
        long nm = 60000L;
        long diff = endDate.getTime() - nowDate.getTime();
        long day = diff / nd;
        long hour = diff % nd / nh;
        long min = diff % nd % nh / nm;
        return day + "\u5929" + hour + "\u5c0f\u65f6" + min + "\u5206\u949f";
    }

    public static String timeUtile(String inTime) {
        try {
            if (StringUtils.isNotBlank((String)inTime)) {
                Date date = DateHelper.parseFormatToDate(inTime, Y_M_DHHMMSS);
                inTime = inTime.substring(0, 16);
                Date curTime = new Date();
                if (date.before(curTime) && DateHelper.sameYear(date, curTime)) {
                    if (DateHelper.sameDay(date, curTime)) {
                        Long minute = DateHelper.calculateDifferenceMinute(curTime, date);
                        if (minute >= 0L && minute < 60L) {
                            inTime = "\u521a\u521a";
                        } else if (minute >= 60L) {
                            inTime = minute / 60L + "\u5c0f\u65f6\u524d";
                        }
                    } else {
                        inTime = DateHelper.isYesterday(date, curTime) ? "\u6628\u5929 " + inTime.substring(11) : inTime.substring(5);
                    }
                }
            }
            return inTime;
        }
        catch (Exception e) {
            e.printStackTrace();
            return inTime;
        }
    }

    public static String getFormatStringPattern(String time, String pattern) {
        String dateFormat = "";
        try {
            if (StringUtils.isNotBlank((String)time)) {
                Date date = new SimpleDateFormat(pattern).parse(time);
                dateFormat = new SimpleDateFormat(pattern).format(date);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return dateFormat;
    }

    public static Date getTodayEnd() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(11, 24);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date end = calendar.getTime();
        return end;
    }

    public static String getTime() {
        long l = System.currentTimeMillis() / 1000L;
        return String.valueOf(l);
    }
}

