/*
 * Decompiled with CFR 0.152.
 */
package com.ard.security.utils.redis;

import com.ard.security.config.SafeConfig;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class RedisService {
    private static final Logger log = LoggerFactory.getLogger(RedisService.class);

    public boolean expire(String key, long time) {
        try {
            if (time > 0L) {
                SafeConfig.redisTemplate.expire((Object)key, time, TimeUnit.SECONDS);
            }
            return true;
        }
        catch (RuntimeException e) {
            log.error(e.getLocalizedMessage());
            return false;
        }
    }

    public boolean expire(String key, long time, TimeUnit timeUnit) {
        try {
            if (time > 0L) {
                SafeConfig.redisTemplate.expire((Object)key, time, timeUnit);
            }
            return true;
        }
        catch (RuntimeException e) {
            log.error(e.getLocalizedMessage());
            return false;
        }
    }

    public long getExpire(String key) {
        return SafeConfig.redisTemplate.getExpire((Object)key, TimeUnit.SECONDS);
    }

    public boolean isKeyExists(String key) {
        try {
            return SafeConfig.redisTemplate.hasKey((Object)key);
        }
        catch (RuntimeException e) {
            log.error(e.getLocalizedMessage());
            return false;
        }
    }

    public boolean isHashKeyExists(String key) {
        try {
            return SafeConfig.redisTemplate.opsForHash().hasKey((Object)"", (Object)key);
        }
        catch (RuntimeException e) {
            log.error(e.getLocalizedMessage());
            return false;
        }
    }

    public void del(String ... key) {
        if (key != null && key.length > 0) {
            if (key.length == 1) {
                SafeConfig.redisTemplate.delete((Object)key[0]);
            } else {
                SafeConfig.redisTemplate.delete((Collection)CollectionUtils.arrayToList((Object)key));
            }
        }
    }

    public boolean setNX(String lockKey, Long expireTime) {
        return (Boolean)SafeConfig.redisTemplate.execute(connection -> {
            boolean isLock = connection.setNX(lockKey.getBytes(), "".getBytes());
            if (isLock) {
                this.expire(lockKey, expireTime, TimeUnit.MILLISECONDS);
            }
            return isLock;
        });
    }

    public Set<String> keys(String keyPrefix) {
        return SafeConfig.redisTemplate.keys((Object)keyPrefix);
    }

    public Object get(String key) {
        return key == null ? null : SafeConfig.redisTemplate.opsForValue().get((Object)key);
    }

    public boolean set(String key, Object value) {
        try {
            SafeConfig.redisTemplate.opsForValue().set((Object)key, value);
            return true;
        }
        catch (RuntimeException e) {
            log.error(e.getLocalizedMessage());
            return false;
        }
    }

    public boolean set(String key, Object value, long time) {
        try {
            if (time > 0L) {
                SafeConfig.redisTemplate.opsForValue().set((Object)key, value, time, TimeUnit.SECONDS);
            } else {
                this.set(key, value);
            }
            return true;
        }
        catch (RuntimeException e) {
            log.error(e.getLocalizedMessage());
            return false;
        }
    }

    public boolean set(String key, Object value, long time, TimeUnit timeUnit) {
        try {
            if (time > 0L) {
                SafeConfig.redisTemplate.opsForValue().set((Object)key, value, time, timeUnit);
            } else {
                this.set(key, value);
            }
            return true;
        }
        catch (RuntimeException e) {
            log.error(e.getLocalizedMessage());
            return false;
        }
    }

    public long incr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return SafeConfig.redisTemplate.opsForValue().increment((Object)key, delta);
    }

    public long incr(String key) {
        return SafeConfig.redisTemplate.opsForValue().increment((Object)key, 1L);
    }

    public long decr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return SafeConfig.redisTemplate.opsForValue().increment((Object)key, -delta);
    }

    public Object hget(String key, String item) {
        return SafeConfig.redisTemplate.opsForHash().get((Object)key, (Object)item);
    }

    public Map<Object, Object> hmget(String key) {
        return SafeConfig.redisTemplate.opsForHash().entries((Object)key);
    }

    public boolean hmset(String key, Map<String, Object> map) {
        try {
            SafeConfig.redisTemplate.opsForHash().putAll((Object)key, map);
            return true;
        }
        catch (RuntimeException e) {
            log.error(e.getLocalizedMessage());
            return false;
        }
    }

    public long hSize(String key) {
        try {
            return SafeConfig.redisTemplate.opsForHash().size((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public boolean hmset(String key, Map<String, Object> map, long time) {
        try {
            SafeConfig.redisTemplate.opsForHash().putAll((Object)key, map);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (RuntimeException e) {
            log.error(e.getLocalizedMessage());
            return false;
        }
    }

    public boolean hset(String key, String item, Object value) {
        try {
            SafeConfig.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            return true;
        }
        catch (RuntimeException e) {
            log.error(e.getLocalizedMessage());
            return false;
        }
    }

    public boolean hset(String key, String item, Object value, long time) {
        try {
            SafeConfig.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (RuntimeException e) {
            log.error(e.getLocalizedMessage());
            return false;
        }
    }

    public void hdel(String key, Object ... item) {
        SafeConfig.redisTemplate.opsForHash().delete((Object)key, item);
    }

    public boolean hHasKey(String key, String item) {
        return SafeConfig.redisTemplate.opsForHash().hasKey((Object)key, (Object)item);
    }

    public double hincr(String key, String item, double by) {
        return SafeConfig.redisTemplate.opsForHash().increment((Object)key, (Object)item, by);
    }

    public double hdecr(String key, String item, double by) {
        return SafeConfig.redisTemplate.opsForHash().increment((Object)key, (Object)item, -by);
    }

    public Set<Object> sGet(String key) {
        try {
            return SafeConfig.redisTemplate.opsForSet().members((Object)key);
        }
        catch (RuntimeException e) {
            log.error(e.getLocalizedMessage());
            return null;
        }
    }

    public boolean isMember(String key, Object value) {
        try {
            return SafeConfig.redisTemplate.opsForSet().isMember((Object)key, value);
        }
        catch (RuntimeException e) {
            log.error(e.getLocalizedMessage());
            return false;
        }
    }

    public long sadd(String key, Object ... values) {
        try {
            return SafeConfig.redisTemplate.opsForSet().add((Object)key, values);
        }
        catch (RuntimeException e) {
            log.error(e.getLocalizedMessage());
            return 0L;
        }
    }

    public long saddAndTime(String key, long time, Object ... values) {
        try {
            Long count = SafeConfig.redisTemplate.opsForSet().add((Object)key, values);
            if (time > 0L) {
                this.expire(key, time);
            }
            return count;
        }
        catch (RuntimeException e) {
            log.error(e.getLocalizedMessage());
            return 0L;
        }
    }

    public long scard(String key) {
        try {
            return SafeConfig.redisTemplate.opsForSet().size((Object)key);
        }
        catch (RuntimeException e) {
            log.error(e.getLocalizedMessage());
            return 0L;
        }
    }

    public void addZset(String key, String value, double score) {
        SafeConfig.redisTemplate.opsForZSet().add((Object)key, (Object)value, score);
    }

    public void removeZset(String key, String value) {
        SafeConfig.redisTemplate.opsForZSet().remove((Object)key, new Object[]{value});
    }

    public Double incrScoreZset(String key, String value, double score) {
        return SafeConfig.redisTemplate.opsForZSet().incrementScore((Object)key, (Object)value, score);
    }

    public long srem(String key, Object ... values) {
        try {
            Long count = SafeConfig.redisTemplate.opsForSet().remove((Object)key, values);
            return count;
        }
        catch (RuntimeException e) {
            log.error(e.getLocalizedMessage());
            return 0L;
        }
    }

    public List<Object> lGet(String key, long start, long end) {
        try {
            return SafeConfig.redisTemplate.opsForList().range((Object)key, start, end);
        }
        catch (RuntimeException e) {
            log.error(e.getLocalizedMessage());
            return null;
        }
    }

    public long lGetListSize(String key) {
        try {
            return SafeConfig.redisTemplate.opsForList().size((Object)key);
        }
        catch (RuntimeException e) {
            log.error(e.getLocalizedMessage());
            return 0L;
        }
    }

    public Object lGetIndex(String key, long index) {
        try {
            return SafeConfig.redisTemplate.opsForList().index((Object)key, index);
        }
        catch (RuntimeException e) {
            log.error(e.getLocalizedMessage());
            return null;
        }
    }

    public boolean lSet(String key, Object value) {
        try {
            SafeConfig.redisTemplate.opsForList().rightPush((Object)key, value);
            return true;
        }
        catch (RuntimeException e) {
            log.error(e.getLocalizedMessage());
            return false;
        }
    }

    public boolean lSet(String key, Object value, long time) {
        try {
            SafeConfig.redisTemplate.opsForList().rightPush((Object)key, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (RuntimeException e) {
            log.error(e.getLocalizedMessage());
            return false;
        }
    }

    public boolean lSetAll(String key, List value) {
        try {
            SafeConfig.redisTemplate.opsForList().rightPushAll((Object)key, (Collection)value);
            return true;
        }
        catch (RuntimeException e) {
            log.error(e.getLocalizedMessage());
            return false;
        }
    }

    public boolean lSetAll(String key, List value, long time) {
        try {
            SafeConfig.redisTemplate.opsForList().rightPushAll((Object)key, (Collection)value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (RuntimeException e) {
            log.error(e.getLocalizedMessage());
            return false;
        }
    }

    public boolean lUpdateIndex(String key, long index, Object value) {
        try {
            SafeConfig.redisTemplate.opsForList().set((Object)key, index, value);
            return true;
        }
        catch (RuntimeException e) {
            log.error(e.getLocalizedMessage());
            return false;
        }
    }

    public long lRemove(String key, long count, Object value) {
        try {
            Long remove = SafeConfig.redisTemplate.opsForList().remove((Object)key, count, value);
            return remove;
        }
        catch (RuntimeException e) {
            log.error(e.getLocalizedMessage());
            return 0L;
        }
    }

    public boolean put(String key, Object value) {
        try {
            return (Boolean)SafeConfig.redisTemplate.execute(connection -> {
                connection.set(SafeConfig.redisTemplate.getStringSerializer().serialize((Object)key), new JdkSerializationRedisSerializer().serialize(value));
                return true;
            });
        }
        catch (RuntimeException e) {
            log.error(e.getLocalizedMessage());
            return false;
        }
    }

    public boolean expireByHOURS(String key, Long expireTime) {
        return SafeConfig.redisTemplate.expire((Object)key, expireTime.longValue(), TimeUnit.HOURS);
    }

    public long getIncrValue(String key) {
        return (Long)SafeConfig.redisTemplate.execute(connection -> {
            StringRedisSerializer serializer = (StringRedisSerializer)SafeConfig.redisTemplate.getKeySerializer();
            byte[] rowkey = serializer.serialize(key);
            byte[] rowval = connection.get(rowkey);
            try {
                String val = serializer.deserialize(rowval);
                return Long.parseLong(val);
            }
            catch (Exception e) {
                return 0L;
            }
        });
    }
}

