/*
 * Decompiled with CFR 0.152.
 */
package com.ard.security.utils.sign;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ard.security.utils.sm3.SM3Digest;
import java.security.SecureRandom;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignCommon {
    private static final Logger log = LoggerFactory.getLogger(SignCommon.class);

    public static String getSignYq(Map<String, ?> map) {
        String newSignYq = JSON.toJSONString(map);
        JSONObject obj = JSONObject.parseObject((String)newSignYq);
        if (map.get("sign_yq") != null) {
            obj.remove((Object)"sign_yq");
        }
        newSignYq = JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.MapSortField});
        String signCf = "";
        if (map.get("sign_cf") != null) {
            signCf = String.valueOf(map.get("sign_cf"));
        }
        newSignYq = SignCommon.replaceParam(signCf, newSignYq);
        try {
            newSignYq = SM3Digest.sm3Digest(newSignYq).toUpperCase();
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u9a8c\u7b7e\u5931\u8d25\uff01 \u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage());
        }
        return newSignYq;
    }

    public static String getH5SignCf() {
        return "h5_iden::" + new SecureRandom().nextInt(9999) + ":" + System.currentTimeMillis();
    }

    public static String getAppSignCf() {
        return new SecureRandom().nextInt(9999) + ":" + System.currentTimeMillis();
    }

    public static String replaceParam(String sign_cf, String requstParam) {
        requstParam = requstParam.replaceAll("\\[|\\]", "");
        if (sign_cf.contains("h5_iden:")) {
            requstParam = requstParam.replaceAll("\\[|\\]|\\+|\\\\r|\\\\n|\\\\t|\\\\|\\/|\"|'|\\s*|\\s|\\<|\\>", "");
            String regEx = "[@`~#\uffe5%&*\u2018\u201c\u2019\u201d\"'<>?=.;^]";
            Pattern pattern = Pattern.compile(regEx);
            Matcher matcher = pattern.matcher(requstParam);
            requstParam = matcher.replaceAll("");
            requstParam = requstParam.replaceAll(" ", "");
            requstParam = requstParam.replaceAll("\u00a0", "");
        }
        return requstParam;
    }
}

