/*
 * Decompiled with CFR 0.152.
 */
package com.ard.security.utils.sm3;

import java.math.BigInteger;
import org.springframework.util.StringUtils;

public class Util {
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static byte[] intToBytes(int num) {
        byte[] bytes = new byte[]{(byte)(0xFF & num >> 0), (byte)(0xFF & num >> 8), (byte)(0xFF & num >> 16), (byte)(0xFF & num >> 24)};
        return bytes;
    }

    public static int byteToInt(byte[] bytes) {
        int num = 0;
        int temp = (0xFF & bytes[0]) << 0;
        num |= temp;
        temp = (0xFF & bytes[1]) << 8;
        num |= temp;
        temp = (0xFF & bytes[2]) << 16;
        num |= temp;
        temp = (0xFF & bytes[3]) << 24;
        return num |= temp;
    }

    public static byte[] longToBytes(long num) {
        byte[] bytes = new byte[8];
        for (int i = 0; i < 8; ++i) {
            bytes[i] = (byte)(0xFFL & num >> i * 8);
        }
        return bytes;
    }

    public static byte[] byteConvert32Bytes(BigInteger n) {
        byte[] tmpd = null;
        if (n == null) {
            return null;
        }
        if (n.toByteArray().length == 33) {
            tmpd = new byte[32];
            System.arraycopy(n.toByteArray(), 1, tmpd, 0, 32);
        } else if (n.toByteArray().length == 32) {
            tmpd = n.toByteArray();
        } else {
            tmpd = new byte[32];
            for (int i = 0; i < 32 - n.toByteArray().length; ++i) {
                tmpd[i] = 0;
            }
            System.arraycopy(n.toByteArray(), 0, tmpd, 32 - n.toByteArray().length, n.toByteArray().length);
        }
        return tmpd;
    }

    public static BigInteger byteConvertInteger(byte[] b) {
        if (b[0] < 0) {
            byte[] temp = new byte[b.length + 1];
            temp[0] = 0;
            System.arraycopy(b, 0, temp, 1, b.length);
            return new BigInteger(temp);
        }
        return new BigInteger(b);
    }

    public static String getHexString(byte[] bytes) {
        boolean b = true;
        return Util.getHexString(bytes, b);
    }

    public static String getHexString(byte[] bytes, boolean upperCase) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            ret.append(Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return upperCase ? ret.toString().toUpperCase() : ret.toString();
    }

    public static void printHexString(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() != 1) continue;
            String string = '0' + hex;
        }
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (StringUtils.isEmpty((Object)hexString)) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(Util.charToByte(hexChars[pos]) << 4 | Util.charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    public static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static char[] encodeHex(byte[] data) {
        boolean b = true;
        return Util.encodeHex(data, b);
    }

    public static char[] encodeHex(byte[] data, boolean toLowerCase) {
        return Util.encodeHex(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    protected static char[] encodeHex(byte[] data, char[] toDigits) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0xF & data[i]];
        }
        return out;
    }

    public static String encodeHexString(byte[] data) {
        boolean b = true;
        return Util.encodeHexString(data, b);
    }

    public static String encodeHexString(byte[] data, boolean toLowerCase) {
        return Util.encodeHexString(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    protected static String encodeHexString(byte[] data, char[] toDigits) {
        return new String(Util.encodeHex(data, toDigits));
    }

    public static byte[] decodeHex(char[] data) {
        int len = data.length;
        if ((len & 1) != 0) {
            throw new RuntimeException("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = Util.toDigit(data[j], j) << 4;
            f |= Util.toDigit(data[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    protected static int toDigit(char ch, int index) {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new RuntimeException("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }

    public static String StringToAsciiString(String content) {
        StringBuilder result = new StringBuilder();
        int max = content.length();
        for (int i = 0; i < max; ++i) {
            char c = content.charAt(i);
            String b = Integer.toHexString(c);
            result.append(b);
        }
        return result.toString();
    }

    public static String hexStringToBinary(String hex) {
        hex = hex.toUpperCase();
        StringBuffer result = new StringBuffer();
        int max = hex.length();
        block18: for (int i = 0; i < max; ++i) {
            char c = hex.charAt(i);
            switch (c) {
                case '0': {
                    result.append("0000");
                    continue block18;
                }
                case '1': {
                    result.append("0001");
                    continue block18;
                }
                case '2': {
                    result.append("0010");
                    continue block18;
                }
                case '3': {
                    result.append("0011");
                    continue block18;
                }
                case '4': {
                    result.append("0100");
                    continue block18;
                }
                case '5': {
                    result.append("0101");
                    continue block18;
                }
                case '6': {
                    result.append("0110");
                    continue block18;
                }
                case '7': {
                    result.append("0111");
                    continue block18;
                }
                case '8': {
                    result.append("1000");
                    continue block18;
                }
                case '9': {
                    result.append("1001");
                    continue block18;
                }
                case 'A': {
                    result.append("1010");
                    continue block18;
                }
                case 'B': {
                    result.append("1011");
                    continue block18;
                }
                case 'C': {
                    result.append("1100");
                    continue block18;
                }
                case 'D': {
                    result.append("1101");
                    continue block18;
                }
                case 'E': {
                    result.append("1110");
                    continue block18;
                }
                case 'F': {
                    result.append("1111");
                    continue block18;
                }
            }
        }
        return result.toString();
    }

    public static String algorismToHexString(int algorism, int maxLength) {
        String result = "";
        result = Integer.toHexString(algorism);
        if (result.length() % 2 == 1) {
            result = "0" + result;
        }
        return Util.patchHexString(result.toUpperCase(), maxLength);
    }

    public static String byteToString(byte[] bytearray) {
        StringBuilder result = new StringBuilder();
        int length = bytearray.length;
        for (int i = 0; i < length; ++i) {
            char temp = (char)bytearray[i];
            result.append(temp);
        }
        return result.toString();
    }

    public static String algorismToHEXString(int algorism) {
        String result = "";
        result = Integer.toHexString(algorism);
        if (result.length() % 2 == 1) {
            result = "0" + result;
        }
        result = result.toUpperCase();
        return result;
    }

    public static String patchHexString(String str, int maxLength) {
        StringBuilder temp = new StringBuilder();
        for (int i = 0; i < maxLength - str.length(); ++i) {
            temp.append("0");
        }
        str = (temp.toString() + str).substring(0, maxLength);
        return str;
    }

    public static int parseToInt(String s, int defaultInt, int radix) {
        int i = 0;
        try {
            i = Integer.parseInt(s, radix);
        }
        catch (NumberFormatException ex) {
            i = defaultInt;
        }
        return i;
    }

    public static int parseToInt(String s, int defaultInt) {
        int i = 0;
        try {
            i = Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            i = defaultInt;
        }
        return i;
    }

    public static byte[] hexToByte(String hex) throws IllegalArgumentException {
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException();
        }
        char[] arr = hex.toCharArray();
        byte[] b = new byte[hex.length() / 2];
        int i = 0;
        int j = 0;
        int l = hex.length();
        while (i < l) {
            String swap = "" + arr[i++] + arr[i];
            int byteint = Integer.parseInt(swap, 16) & 0xFF;
            b[j] = Integer.valueOf(byteint).byteValue();
            ++i;
            ++j;
        }
        return b;
    }

    public static String byteToHex(byte[] b) {
        if (b == null) {
            throw new IllegalArgumentException("Argument b ( byte array ) is null! ");
        }
        StringBuilder hs = new StringBuilder();
        StringBuilder stmp = new StringBuilder();
        for (int n = 0; n < b.length; ++n) {
            stmp.append(Integer.toHexString(b[n] & 0xFF));
            if (stmp.length() == 1) {
                hs.append("0").append((CharSequence)stmp);
                continue;
            }
            hs.append((CharSequence)stmp);
        }
        return hs.toString().toUpperCase();
    }

    public static byte[] subByte(byte[] input, int startIndex, int length) {
        byte[] bt = new byte[length];
        for (int i = 0; i < length; ++i) {
            bt[i] = input[i + startIndex];
        }
        return bt;
    }
}

