/*
 * Decompiled with CFR 0.152.
 */
package com.ard.security.utils.xss.phishing;

import com.ard.security.config.SafeConfig;
import com.ard.security.utils.xss.phishing.Match;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class DomainNameHelper {
    private static String REGEX = "\\w+://(([\\u4e00-\\u9fa5\\w_!~*'().&=+$%-]+: )?[\\u4e00-\\u9fa5\\w_!~*'().&=+$%-]+@)?((\\d{1,3}\\.){3}\\d{1,3}|([\\u4e00-\\u9fa5\\w]+\\.)*[\\u4e00-\\u9fa5\\w]+)(:\\d+)?(/[\\w_!~*'().;?:@&=+$,%#-]*)*";

    public static String getDomainName(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return str;
        }
        str = Pattern.compile("^.+://").matcher(str).replaceFirst("");
        str = Pattern.compile("/.*$").matcher(str).replaceFirst("");
        return str;
    }

    public static boolean isDomainName(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return false;
        }
        if (!str.contains("://")) {
            return false;
        }
        return Pattern.compile(REGEX).matcher(str).find();
    }

    public static String cleanDomainName(String domainName) {
        if (!SafeConfig.PHISHING_SWITCH || StringUtils.isEmpty((String)domainName)) {
            return domainName;
        }
        Matcher m = Pattern.compile(REGEX).matcher(domainName);
        StringBuilder newDomainName = new StringBuilder(domainName);
        ArrayList<Match> list = new ArrayList<Match>();
        while (m.find()) {
            list.add(new Match(m.group(), m.start(), m.end()));
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            Match match = (Match)list.get(i);
            boolean isReplace = false;
            if (SafeConfig.PHISHING_WHITE_URLS != null && SafeConfig.PHISHING_WHITE_URLS.length > 0) {
                for (String url : SafeConfig.PHISHING_WHITE_URLS) {
                    if (!match.getUrl().contains(url)) continue;
                    isReplace = true;
                    break;
                }
            }
            if (isReplace) continue;
            newDomainName = newDomainName.replace(match.getStart(), match.getEnd(), "#");
        }
        return newDomainName.toString();
    }
}

