/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.google.typography.font.sfntly.table;

import cfca.sadk.com.google.typography.font.sfntly.Tag;
import cfca.sadk.com.google.typography.font.sfntly.data.ReadableFontData;
import cfca.sadk.com.google.typography.font.sfntly.data.WritableFontData;
import cfca.sadk.com.google.typography.font.sfntly.table.FontDataTable;
import cfca.sadk.com.google.typography.font.sfntly.table.GenericTableBuilder;
import cfca.sadk.com.google.typography.font.sfntly.table.Header;
import cfca.sadk.com.google.typography.font.sfntly.table.bitmap.EbdtTable;
import cfca.sadk.com.google.typography.font.sfntly.table.bitmap.EblcTable;
import cfca.sadk.com.google.typography.font.sfntly.table.bitmap.EbscTable;
import cfca.sadk.com.google.typography.font.sfntly.table.core.CMapTable;
import cfca.sadk.com.google.typography.font.sfntly.table.core.FontHeaderTable;
import cfca.sadk.com.google.typography.font.sfntly.table.core.HorizontalDeviceMetricsTable;
import cfca.sadk.com.google.typography.font.sfntly.table.core.HorizontalHeaderTable;
import cfca.sadk.com.google.typography.font.sfntly.table.core.HorizontalMetricsTable;
import cfca.sadk.com.google.typography.font.sfntly.table.core.MaximumProfileTable;
import cfca.sadk.com.google.typography.font.sfntly.table.core.NameTable;
import cfca.sadk.com.google.typography.font.sfntly.table.core.OS2Table;
import cfca.sadk.com.google.typography.font.sfntly.table.core.PostScriptTable;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.GSubTable;
import cfca.sadk.com.google.typography.font.sfntly.table.truetype.ControlProgramTable;
import cfca.sadk.com.google.typography.font.sfntly.table.truetype.ControlValueTable;
import cfca.sadk.com.google.typography.font.sfntly.table.truetype.GlyphTable;
import cfca.sadk.com.google.typography.font.sfntly.table.truetype.LocaTable;

public class Table
extends FontDataTable {
    private Header header;

    protected Table(Header header, ReadableFontData data) {
        super(data);
        this.header = header;
    }

    public long calculatedChecksum() {
        return this.data.checksum();
    }

    public Header header() {
        return this.header;
    }

    public int headerTag() {
        return this.header().tag();
    }

    public int headerOffset() {
        return this.header().offset();
    }

    public int headerLength() {
        return this.header().length();
    }

    public long headerChecksum() {
        return this.header().checksum();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(Tag.stringValue(this.header.tag()));
        sb.append(", cs=0x");
        sb.append(Long.toHexString(this.header.checksum()));
        sb.append(", offset=0x");
        sb.append(Integer.toHexString(this.header.offset()));
        sb.append(", size=0x");
        sb.append(Integer.toHexString(this.header.length()));
        sb.append("]");
        return sb.toString();
    }

    public static abstract class Builder<T extends Table>
    extends FontDataTable.Builder<T> {
        private Header header;

        protected Builder(Header header, WritableFontData data) {
            super(data);
            this.header = header;
        }

        protected Builder(Header header, ReadableFontData data) {
            super(data);
            this.header = header;
        }

        protected Builder(Header header) {
            this(header, null);
        }

        public String toString() {
            return "Table Builder for - " + this.header.toString();
        }

        public final Header header() {
            return this.header;
        }

        @Override
        protected void notifyPostTableBuild(T table) {
            if (this.modelChanged() || this.dataChanged()) {
                Header header = new Header(this.header().tag(), ((FontDataTable)table).dataLength());
                ((Table)table).header = header;
            }
        }

        public static Builder<? extends Table> getBuilder(Header header, WritableFontData tableData) {
            int tag = header.tag();
            if (tag == Tag.cmap) {
                return CMapTable.Builder.createBuilder(header, tableData);
            }
            if (tag == Tag.head) {
                return FontHeaderTable.Builder.createBuilder(header, tableData);
            }
            if (tag == Tag.hhea) {
                return HorizontalHeaderTable.Builder.createBuilder(header, tableData);
            }
            if (tag == Tag.hmtx) {
                return HorizontalMetricsTable.Builder.createBuilder(header, tableData);
            }
            if (tag == Tag.maxp) {
                return MaximumProfileTable.Builder.createBuilder(header, tableData);
            }
            if (tag == Tag.name) {
                return NameTable.Builder.createBuilder(header, tableData);
            }
            if (tag == Tag.OS_2) {
                return OS2Table.Builder.createBuilder(header, tableData);
            }
            if (tag == Tag.post) {
                return PostScriptTable.Builder.createBuilder(header, tableData);
            }
            if (tag == Tag.cvt) {
                return ControlValueTable.Builder.createBuilder(header, tableData);
            }
            if (tag == Tag.glyf) {
                return GlyphTable.Builder.createBuilder(header, tableData);
            }
            if (tag == Tag.loca) {
                return LocaTable.Builder.createBuilder(header, tableData);
            }
            if (tag == Tag.prep) {
                return ControlProgramTable.Builder.createBuilder(header, tableData);
            }
            if (tag == Tag.EBDT) {
                return EbdtTable.Builder.createBuilder(header, tableData);
            }
            if (tag == Tag.EBLC) {
                return EblcTable.Builder.createBuilder(header, tableData);
            }
            if (tag == Tag.EBSC) {
                return EbscTable.Builder.createBuilder(header, tableData);
            }
            if (tag == Tag.GSUB) {
                return GSubTable.Builder.createBuilder(header, tableData);
            }
            if (tag == Tag.hdmx) {
                return HorizontalDeviceMetricsTable.Builder.createBuilder(header, tableData);
            }
            if (tag == Tag.bhed) {
                return FontHeaderTable.Builder.createBuilder(header, tableData);
            }
            if (tag == Tag.bdat) {
                return EbdtTable.Builder.createBuilder(header, tableData);
            }
            if (tag == Tag.bloc) {
                return EblcTable.Builder.createBuilder(header, tableData);
            }
            return GenericTableBuilder.createBuilder(header, tableData);
        }
    }
}

