/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.google.typography.font.sfntly.table.bitmap;

import cfca.sadk.com.google.typography.font.sfntly.data.FontData;
import cfca.sadk.com.google.typography.font.sfntly.data.ReadableFontData;
import cfca.sadk.com.google.typography.font.sfntly.data.WritableFontData;
import cfca.sadk.com.google.typography.font.sfntly.math.FontMath;
import cfca.sadk.com.google.typography.font.sfntly.table.Header;
import cfca.sadk.com.google.typography.font.sfntly.table.SubTableContainerTable;
import cfca.sadk.com.google.typography.font.sfntly.table.bitmap.BigGlyphMetrics;
import cfca.sadk.com.google.typography.font.sfntly.table.bitmap.BitmapGlyph;
import cfca.sadk.com.google.typography.font.sfntly.table.bitmap.BitmapGlyphInfo;
import cfca.sadk.com.google.typography.font.sfntly.table.bitmap.BitmapSizeTable;
import cfca.sadk.com.google.typography.font.sfntly.table.bitmap.IndexSubTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class EblcTable
extends SubTableContainerTable {
    private static final boolean DEBUG = false;
    public static final int NOTDEF = -1;
    private final Object bitmapSizeTableLock = new Object();
    private volatile List<BitmapSizeTable> bitmapSizeTable;

    protected EblcTable(Header header, ReadableFontData data) {
        super(header, data);
    }

    public int version() {
        return this.data.readFixed(Offset.version.offset);
    }

    public int numSizes() {
        return this.data.readULongAsInt(Offset.numSizes.offset);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\nnum sizes = ");
        sb.append(this.numSizes());
        sb.append("\n");
        for (int i = 0; i < this.numSizes(); ++i) {
            sb.append(i);
            sb.append(": ");
            BitmapSizeTable size = this.bitmapSizeTable(i);
            sb.append(size.toString());
        }
        return sb.toString();
    }

    public BitmapSizeTable bitmapSizeTable(int index) {
        if (index < 0 || index > this.numSizes()) {
            throw new IndexOutOfBoundsException("Size table index is outside of the range of tables.");
        }
        List<BitmapSizeTable> bitmapSizeTableList = this.getBitmapSizeTableList();
        return bitmapSizeTableList.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BitmapSizeTable> getBitmapSizeTableList() {
        if (this.bitmapSizeTable == null) {
            Object object = this.bitmapSizeTableLock;
            synchronized (object) {
                if (this.bitmapSizeTable == null) {
                    this.bitmapSizeTable = EblcTable.createBitmapSizeTable(this.data, this.numSizes());
                }
            }
        }
        return this.bitmapSizeTable;
    }

    private static List<BitmapSizeTable> createBitmapSizeTable(ReadableFontData data, int numSizes) {
        ArrayList<BitmapSizeTable> bitmapSizeTable = new ArrayList<BitmapSizeTable>();
        for (int i = 0; i < numSizes; ++i) {
            BitmapSizeTable.Builder sizeBuilder = BitmapSizeTable.Builder.createBuilder(data.slice(Offset.bitmapSizeTableArrayStart.offset + i * Offset.bitmapSizeTableLength.offset, Offset.bitmapSizeTableLength.offset), data);
            BitmapSizeTable size = (BitmapSizeTable)sizeBuilder.build();
            bitmapSizeTable.add(size);
        }
        return Collections.unmodifiableList(bitmapSizeTable);
    }

    public static final class Builder
    extends SubTableContainerTable.Builder<EblcTable> {
        private final int version = 131072;
        private List<BitmapSizeTable.Builder> sizeTableBuilders;

        public static Builder createBuilder(Header header, WritableFontData data) {
            return new Builder(header, data);
        }

        public static Builder createBuilder(Header header, ReadableFontData data) {
            return new Builder(header, data);
        }

        protected Builder(Header header, WritableFontData data) {
            super(header, data);
        }

        protected Builder(Header header, ReadableFontData data) {
            super(header, data);
        }

        public List<BitmapSizeTable.Builder> bitmapSizeBuilders() {
            return this.getSizeList();
        }

        protected void revert() {
            this.sizeTableBuilders = null;
            this.setModelChanged(false);
        }

        public List<Map<Integer, BitmapGlyphInfo>> generateLocaList() {
            List<BitmapSizeTable.Builder> sizeBuilderList = this.getSizeList();
            ArrayList<Map<Integer, BitmapGlyphInfo>> locaList = new ArrayList<Map<Integer, BitmapGlyphInfo>>(sizeBuilderList.size());
            boolean sizeIndex = false;
            for (BitmapSizeTable.Builder sizeBuilder : sizeBuilderList) {
                Map<Integer, BitmapGlyphInfo> locaMap = sizeBuilder.generateLocaMap();
                locaList.add(locaMap);
            }
            return locaList;
        }

        private List<BitmapSizeTable.Builder> getSizeList() {
            if (this.sizeTableBuilders == null) {
                this.sizeTableBuilders = this.initialize(this.internalReadData());
                super.setModelChanged();
            }
            return this.sizeTableBuilders;
        }

        private List<BitmapSizeTable.Builder> initialize(ReadableFontData data) {
            ArrayList<BitmapSizeTable.Builder> sizeBuilders = new ArrayList<BitmapSizeTable.Builder>();
            if (data != null) {
                int numSizes = data.readULongAsInt(Offset.numSizes.offset);
                for (int i = 0; i < numSizes; ++i) {
                    BitmapSizeTable.Builder sizeBuilder = BitmapSizeTable.Builder.createBuilder(data.slice(Offset.bitmapSizeTableArrayStart.offset + i * Offset.bitmapSizeTableLength.offset, Offset.bitmapSizeTableLength.offset), data);
                    sizeBuilders.add(sizeBuilder);
                }
            }
            return sizeBuilders;
        }

        @Override
        protected EblcTable subBuildTable(ReadableFontData data) {
            return new EblcTable(this.header(), data);
        }

        @Override
        protected void subDataSet() {
            this.revert();
        }

        @Override
        protected int subDataSizeToSerialize() {
            if (this.sizeTableBuilders == null) {
                return 0;
            }
            int size = Offset.headerLength.offset;
            boolean variable = false;
            boolean sizeIndex = false;
            for (BitmapSizeTable.Builder sizeBuilder : this.sizeTableBuilders) {
                int sizeBuilderSize = sizeBuilder.subDataSizeToSerialize();
                variable = sizeBuilderSize > 0 ? variable : true;
                size += Math.abs(sizeBuilderSize);
            }
            return variable ? -size : size;
        }

        @Override
        protected boolean subReadyToSerialize() {
            if (this.sizeTableBuilders == null) {
                return false;
            }
            for (BitmapSizeTable.Builder sizeBuilder : this.sizeTableBuilders) {
                if (sizeBuilder.subReadyToSerialize()) continue;
                return false;
            }
            return true;
        }

        @Override
        protected int subSerialize(WritableFontData newData) {
            int subTableBlockStartOffset;
            int sizeTableStartOffset;
            int size = newData.writeFixed(0, this.version);
            size += newData.writeULong(size, this.sizeTableBuilders.size());
            int sizeTableOffset = sizeTableStartOffset = size;
            int currentSubTableBlockStartOffset = subTableBlockStartOffset = sizeTableOffset + this.sizeTableBuilders.size() * Offset.bitmapSizeTableLength.offset;
            boolean sizeIndex = false;
            for (BitmapSizeTable.Builder sizeBuilder : this.sizeTableBuilders) {
                sizeBuilder.setIndexSubTableArrayOffset(currentSubTableBlockStartOffset);
                List<IndexSubTable.Builder<? extends IndexSubTable>> indexSubTableBuilderList = sizeBuilder.indexSubTableBuilders();
                int indexSubTableArrayOffset = currentSubTableBlockStartOffset;
                int indexSubTableOffset = indexSubTableArrayOffset + indexSubTableBuilderList.size() * Offset.indexSubHeaderLength.offset;
                boolean subTableIndex = false;
                for (IndexSubTable.Builder<? extends IndexSubTable> indexSubTableBuilder : indexSubTableBuilderList) {
                    indexSubTableArrayOffset += newData.writeUShort(indexSubTableArrayOffset, indexSubTableBuilder.firstGlyphIndex());
                    indexSubTableArrayOffset += newData.writeUShort(indexSubTableArrayOffset, indexSubTableBuilder.lastGlyphIndex());
                    indexSubTableArrayOffset += newData.writeULong(indexSubTableArrayOffset, indexSubTableOffset - currentSubTableBlockStartOffset);
                    int currentSubTableSize = indexSubTableBuilder.subSerialize(newData.slice(indexSubTableOffset));
                    int padding = FontMath.paddingRequired(currentSubTableSize, FontData.DataSize.ULONG.size());
                    indexSubTableOffset += currentSubTableSize;
                    indexSubTableOffset += newData.writePadding(indexSubTableOffset, padding);
                }
                sizeBuilder.setIndexTableSize(indexSubTableOffset - currentSubTableBlockStartOffset);
                sizeTableOffset += sizeBuilder.subSerialize(newData.slice(sizeTableOffset));
                currentSubTableBlockStartOffset = indexSubTableOffset;
            }
            return size + currentSubTableBlockStartOffset;
        }
    }

    static enum Offset {
        version(0),
        numSizes(4),
        headerLength(Offset.numSizes.offset + FontData.DataSize.ULONG.size()),
        bitmapSizeTableArrayStart(Offset.headerLength.offset),
        bitmapSizeTableLength(48),
        bitmapSizeTable_indexSubTableArrayOffset(0),
        bitmapSizeTable_indexTableSize(4),
        bitmapSizeTable_numberOfIndexSubTables(8),
        bitmapSizeTable_colorRef(12),
        bitmapSizeTable_hori(16),
        bitmapSizeTable_vert(28),
        bitmapSizeTable_startGlyphIndex(40),
        bitmapSizeTable_endGlyphIndex(42),
        bitmapSizeTable_ppemX(44),
        bitmapSizeTable_ppemY(45),
        bitmapSizeTable_bitDepth(46),
        bitmapSizeTable_flags(47),
        sbitLineMetricsLength(12),
        sbitLineMetrics_ascender(0),
        sbitLineMetrics_descender(1),
        sbitLineMetrics_widthMax(2),
        sbitLineMetrics_caretSlopeNumerator(3),
        sbitLineMetrics__caretSlopeDenominator(4),
        sbitLineMetrics_caretOffset(5),
        sbitLineMetrics_minOriginSB(6),
        sbitLineMetrics_minAdvanceSB(7),
        sbitLineMetrics_maxBeforeBL(8),
        sbitLineMetrics_minAfterBL(9),
        sbitLineMetrics_pad1(10),
        sbitLineMetrics_pad2(11),
        indexSubTableEntryLength(8),
        indexSubTableEntry_firstGlyphIndex(0),
        indexSubTableEntry_lastGlyphIndex(2),
        indexSubTableEntry_additionalOffsetToIndexSubtable(4),
        indexSubHeaderLength(8),
        indexSubHeader_indexFormat(0),
        indexSubHeader_imageFormat(2),
        indexSubHeader_imageDataOffset(4),
        indexSubTable1_offsetArray(Offset.indexSubHeaderLength.offset),
        indexSubTable1_builderDataSize(Offset.indexSubHeaderLength.offset),
        indexSubTable2Length(Offset.indexSubHeaderLength.offset + FontData.DataSize.ULONG.size() + BitmapGlyph.Offset.bigGlyphMetricsLength.offset),
        indexSubTable2_imageSize(Offset.indexSubHeaderLength.offset),
        indexSubTable2_bigGlyphMetrics(Offset.indexSubTable2_imageSize.offset + FontData.DataSize.ULONG.size()),
        indexSubTable2_builderDataSize(Offset.indexSubTable2_bigGlyphMetrics.offset + BigGlyphMetrics.Offset.metricsLength.offset),
        indexSubTable3_offsetArray(Offset.indexSubHeaderLength.offset),
        indexSubTable3_builderDataSize(Offset.indexSubTable3_offsetArray.offset),
        indexSubTable4_numGlyphs(Offset.indexSubHeaderLength.offset),
        indexSubTable4_glyphArray(Offset.indexSubTable4_numGlyphs.offset + FontData.DataSize.ULONG.size()),
        indexSubTable4_codeOffsetPairLength(2 * FontData.DataSize.USHORT.size()),
        indexSubTable4_codeOffsetPair_glyphCode(0),
        indexSubTable4_codeOffsetPair_offset(FontData.DataSize.USHORT.size()),
        indexSubTable4_builderDataSize(Offset.indexSubTable4_glyphArray.offset),
        indexSubTable5_imageSize(Offset.indexSubHeaderLength.offset),
        indexSubTable5_bigGlyphMetrics(Offset.indexSubTable5_imageSize.offset + FontData.DataSize.ULONG.size()),
        indexSubTable5_numGlyphs(Offset.indexSubTable5_bigGlyphMetrics.offset + BitmapGlyph.Offset.bigGlyphMetricsLength.offset),
        indexSubTable5_glyphArray(Offset.indexSubTable5_numGlyphs.offset + FontData.DataSize.ULONG.size()),
        indexSubTable5_builderDataSize(Offset.indexSubTable5_glyphArray.offset),
        codeOffsetPairLength(2 * FontData.DataSize.USHORT.size()),
        codeOffsetPair_glyphCode(0),
        codeOffsetPair_offset(FontData.DataSize.USHORT.size());

        final int offset;

        private Offset(int offset) {
            this.offset = offset;
        }
    }
}

