/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.barcodes.dmcode;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Placement {
    private int nrow;
    private int ncol;
    private short[] array;
    private static final Map<Integer, short[]> cache = new HashMap<Integer, short[]>();

    private Placement() {
    }

    public static short[] doPlacement(int nrow, int ncol) {
        int key = nrow * 1000 + ncol;
        short[] pc = cache.get(key);
        if (pc != null) {
            return pc;
        }
        Placement p = new Placement();
        p.nrow = nrow;
        p.ncol = ncol;
        p.array = new short[nrow * ncol];
        p.ecc200();
        cache.put(key, p.array);
        return p.array;
    }

    private void module(int row, int col, int chr, int bit) {
        if (row < 0) {
            row += this.nrow;
            col += 4 - (this.nrow + 4) % 8;
        }
        if (col < 0) {
            col += this.ncol;
            row += 4 - (this.ncol + 4) % 8;
        }
        this.array[row * this.ncol + col] = (short)(8 * chr + bit);
    }

    private void utah(int row, int col, int chr) {
        this.module(row - 2, col - 2, chr, 0);
        this.module(row - 2, col - 1, chr, 1);
        this.module(row - 1, col - 2, chr, 2);
        this.module(row - 1, col - 1, chr, 3);
        this.module(row - 1, col, chr, 4);
        this.module(row, col - 2, chr, 5);
        this.module(row, col - 1, chr, 6);
        this.module(row, col, chr, 7);
    }

    private void corner1(int chr) {
        this.module(this.nrow - 1, 0, chr, 0);
        this.module(this.nrow - 1, 1, chr, 1);
        this.module(this.nrow - 1, 2, chr, 2);
        this.module(0, this.ncol - 2, chr, 3);
        this.module(0, this.ncol - 1, chr, 4);
        this.module(1, this.ncol - 1, chr, 5);
        this.module(2, this.ncol - 1, chr, 6);
        this.module(3, this.ncol - 1, chr, 7);
    }

    private void corner2(int chr) {
        this.module(this.nrow - 3, 0, chr, 0);
        this.module(this.nrow - 2, 0, chr, 1);
        this.module(this.nrow - 1, 0, chr, 2);
        this.module(0, this.ncol - 4, chr, 3);
        this.module(0, this.ncol - 3, chr, 4);
        this.module(0, this.ncol - 2, chr, 5);
        this.module(0, this.ncol - 1, chr, 6);
        this.module(1, this.ncol - 1, chr, 7);
    }

    private void corner3(int chr) {
        this.module(this.nrow - 3, 0, chr, 0);
        this.module(this.nrow - 2, 0, chr, 1);
        this.module(this.nrow - 1, 0, chr, 2);
        this.module(0, this.ncol - 2, chr, 3);
        this.module(0, this.ncol - 1, chr, 4);
        this.module(1, this.ncol - 1, chr, 5);
        this.module(2, this.ncol - 1, chr, 6);
        this.module(3, this.ncol - 1, chr, 7);
    }

    private void corner4(int chr) {
        this.module(this.nrow - 1, 0, chr, 0);
        this.module(this.nrow - 1, this.ncol - 1, chr, 1);
        this.module(0, this.ncol - 3, chr, 2);
        this.module(0, this.ncol - 2, chr, 3);
        this.module(0, this.ncol - 1, chr, 4);
        this.module(1, this.ncol - 3, chr, 5);
        this.module(1, this.ncol - 2, chr, 6);
        this.module(1, this.ncol - 1, chr, 7);
    }

    private void ecc200() {
        Arrays.fill(this.array, (short)0);
        int chr = 1;
        int row = 4;
        int col = 0;
        do {
            if (row == this.nrow && col == 0) {
                this.corner1(chr++);
            }
            if (row == this.nrow - 2 && col == 0 && this.ncol % 4 != 0) {
                this.corner2(chr++);
            }
            if (row == this.nrow - 2 && col == 0 && this.ncol % 8 == 4) {
                this.corner3(chr++);
            }
            if (row == this.nrow + 4 && col == 2 && this.ncol % 8 == 0) {
                this.corner4(chr++);
            }
            do {
                if (row >= this.nrow || col < 0 || this.array[row * this.ncol + col] != 0) continue;
                this.utah(row, col, chr++);
            } while ((row -= 2) >= 0 && (col += 2) < this.ncol);
            ++row;
            col += 3;
            do {
                if (row < 0 || col >= this.ncol || this.array[row * this.ncol + col] != 0) continue;
                this.utah(row, col, chr++);
            } while ((row += 2) < this.nrow && (col -= 2) >= 0);
        } while ((row += 3) < this.nrow || ++col < this.ncol);
        if (this.array[this.nrow * this.ncol - 1] == 0) {
            this.array[this.nrow * this.ncol - this.ncol - 2] = 1;
            this.array[this.nrow * this.ncol - 1] = 1;
        }
    }
}

