/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.io.font.otf.lookuptype5;

import cfca.sadk.com.itextpdf.io.font.otf.ContextualSubTable;
import cfca.sadk.com.itextpdf.io.font.otf.ContextualSubstRule;
import cfca.sadk.com.itextpdf.io.font.otf.OpenTypeFontTableReader;
import cfca.sadk.com.itextpdf.io.font.otf.OtfClass;
import cfca.sadk.com.itextpdf.io.font.otf.SubstLookupRecord;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class SubTableLookup5Format2
extends ContextualSubTable {
    private static final long serialVersionUID = -2184080481143798249L;
    private Set<Integer> substCoverageGlyphIds;
    private List<List<ContextualSubstRule>> subClassSets;
    private OtfClass classDefinition;

    public SubTableLookup5Format2(OpenTypeFontTableReader openReader, int lookupFlag, Set<Integer> substCoverageGlyphIds, OtfClass classDefinition) {
        super(openReader, lookupFlag);
        this.substCoverageGlyphIds = substCoverageGlyphIds;
        this.classDefinition = classDefinition;
    }

    public void setSubClassSets(List<List<ContextualSubstRule>> subClassSets) {
        this.subClassSets = subClassSets;
    }

    @Override
    protected List<ContextualSubstRule> getSetOfRulesForStartGlyph(int startId) {
        if (this.substCoverageGlyphIds.contains(startId) && !this.openReader.isSkip(startId, this.lookupFlag)) {
            int gClass = this.classDefinition.getOtfClass(startId);
            return this.subClassSets.get(gClass);
        }
        return Collections.emptyList();
    }

    public static class SubstRuleFormat2
    extends ContextualSubstRule {
        private static final long serialVersionUID = 652574134066355802L;
        private int[] inputClassIds;
        private SubstLookupRecord[] substLookupRecords;
        private OtfClass classDefinition;

        public SubstRuleFormat2(SubTableLookup5Format2 subTable, int[] inputClassIds, SubstLookupRecord[] substLookupRecords) {
            this.inputClassIds = inputClassIds;
            this.substLookupRecords = substLookupRecords;
            this.classDefinition = subTable.classDefinition;
        }

        @Override
        public int getContextLength() {
            return this.inputClassIds.length + 1;
        }

        @Override
        public SubstLookupRecord[] getSubstLookupRecords() {
            return this.substLookupRecords;
        }

        @Override
        public boolean isGlyphMatchesInput(int glyphId, int atIdx) {
            return this.classDefinition.getOtfClass(glyphId) == this.inputClassIds[atIdx - 1];
        }
    }
}

