/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.io.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class FileUtil {
    private FileUtil() {
    }

    public static String getFontsDir() {
        String winDir = System.getenv("windir");
        String fileSeparator = System.getProperty("file.separator");
        return winDir + fileSeparator + "fonts";
    }

    @Deprecated
    public static String getFileName(String file) {
        return new File(file).getName();
    }

    public static boolean fileExists(String path) {
        if (path != null) {
            File f = new File(path);
            return f.exists() && f.isFile();
        }
        return false;
    }

    public static boolean directoryExists(String path) {
        if (path != null) {
            File f = new File(path);
            return f.exists() && f.isDirectory();
        }
        return false;
    }

    public static String[] listFilesInDirectory(String path, boolean recursive) {
        Object[] files;
        File root;
        if (path != null && (root = new File(path)).exists() && root.isDirectory() && (files = root.listFiles()) != null) {
            Arrays.sort(files);
            ArrayList<String> list = new ArrayList<String>();
            for (Object file : files) {
                if (((File)file).isDirectory() && recursive) {
                    FileUtil.listAllFiles(((File)file).getAbsolutePath(), list);
                    continue;
                }
                list.add(((File)file).getAbsolutePath());
            }
            return list.toArray(new String[list.size()]);
        }
        return null;
    }

    public static File[] listFilesInDirectoryByFilter(String outPath, FileFilter fileFilter) {
        File[] result = null;
        if (outPath != null && !outPath.isEmpty()) {
            result = new File(outPath).listFiles(fileFilter);
        }
        if (result != null) {
            Arrays.sort(result);
        }
        return result;
    }

    private static void listAllFiles(String dir, List<String> list) {
        Object[] files = new File(dir).listFiles();
        if (files != null) {
            Arrays.sort(files);
            for (Object file : files) {
                if (((File)file).isDirectory()) {
                    FileUtil.listAllFiles(((File)file).getAbsolutePath(), list);
                    continue;
                }
                list.add(((File)file).getAbsolutePath());
            }
        }
    }

    public static PrintWriter createPrintWriter(OutputStream output, String encoding) throws UnsupportedEncodingException {
        return new PrintWriter(new OutputStreamWriter(output, encoding));
    }

    public static OutputStream getBufferedOutputStream(String filename) throws FileNotFoundException {
        return new BufferedOutputStream(new FileOutputStream(filename));
    }

    public static OutputStream wrapWithBufferedOutputStream(OutputStream outputStream) {
        if (outputStream instanceof BufferedOutputStream) {
            return outputStream;
        }
        return new BufferedOutputStream(outputStream);
    }

    public static File createTempFile(String path) throws IOException {
        File tempFile = new File(path);
        if (tempFile.isDirectory()) {
            tempFile = File.createTempFile("pdf", null, tempFile);
        }
        return tempFile;
    }

    public static FileOutputStream getFileOutputStream(File tempFile) throws FileNotFoundException {
        return new FileOutputStream(tempFile);
    }

    public static RandomAccessFile getRandomAccessFile(File tempFile) throws FileNotFoundException {
        return new RandomAccessFile(tempFile, "rw");
    }

    public static void createDirectories(String outPath) {
        new File(outPath).mkdirs();
    }

    public static String getParentDirectory(String file) {
        return new File(file).getParent();
    }

    public static String getParentDirectory(File file) throws MalformedURLException {
        return file != null ? file.getParentFile().toURI().toURL().toExternalForm() : "";
    }
}

