/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.kernel.pdf.annot;

import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfArray;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDictionary;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfString;
import cfca.sadk.com.itextpdf.kernel.pdf.annot.PdfMarkupAnnotation;

public class PdfFreeTextAnnotation
extends PdfMarkupAnnotation {
    private static final long serialVersionUID = -7835504102518915220L;
    public static final int LEFT_JUSTIFIED = 0;
    public static final int CENTERED = 1;
    public static final int RIGHT_JUSTIFIED = 2;

    public PdfFreeTextAnnotation(Rectangle rect, String appearanceString) {
        super(rect);
        this.setDefaultAppearance(new PdfString(appearanceString));
    }

    public PdfFreeTextAnnotation(PdfDictionary pdfObject) {
        super(pdfObject);
    }

    @Override
    public PdfName getSubtype() {
        return PdfName.FreeText;
    }

    public PdfString getDefaultStyleString() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.DS);
    }

    public PdfFreeTextAnnotation setDefaultStyleString(PdfString defaultStyleString) {
        return (PdfFreeTextAnnotation)this.put(PdfName.DS, defaultStyleString);
    }

    public PdfArray getCalloutLine() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.CL);
    }

    public PdfFreeTextAnnotation setCalloutLine(float[] calloutLine) {
        return this.setCalloutLine(new PdfArray(calloutLine));
    }

    public PdfFreeTextAnnotation setCalloutLine(PdfArray calloutLine) {
        return (PdfFreeTextAnnotation)this.put(PdfName.CL, calloutLine);
    }

    public PdfName getLineEndingStyle() {
        return ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.LE);
    }

    public PdfFreeTextAnnotation setLineEndingStyle(PdfName lineEndingStyle) {
        return (PdfFreeTextAnnotation)this.put(PdfName.LE, lineEndingStyle);
    }
}

