/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.kernel.pdf.canvas;

import cfca.sadk.com.itextpdf.kernel.color.Color;
import cfca.sadk.com.itextpdf.kernel.color.DeviceGray;
import cfca.sadk.com.itextpdf.kernel.font.PdfFont;
import cfca.sadk.com.itextpdf.kernel.geom.Matrix;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfArray;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDictionary;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfNumber;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfObject;
import cfca.sadk.com.itextpdf.kernel.pdf.extgstate.PdfExtGState;
import java.io.Serializable;
import java.util.Arrays;

public class CanvasGraphicsState
implements Serializable {
    private static final long serialVersionUID = -9151840268986283292L;
    private Matrix ctm = new Matrix();
    private Color strokeColor = DeviceGray.BLACK;
    private Color fillColor = DeviceGray.BLACK;
    private float charSpacing = 0.0f;
    private float wordSpacing = 0.0f;
    private float scale = 100.0f;
    private float leading = 0.0f;
    private PdfFont font;
    private float fontSize;
    private int textRenderingMode = 0;
    private float textRise = 0.0f;
    private boolean textKnockout = true;
    private float lineWidth = 1.0f;
    private int lineCapStyle = 0;
    private int lineJoinStyle = 0;
    private float miterLimit = 10.0f;
    private PdfArray dashPattern = new PdfArray(Arrays.asList(new PdfArray(), new PdfNumber(0)));
    private PdfName renderingIntent = PdfName.RelativeColorimetric;
    private boolean automaticStrokeAdjustment = false;
    private PdfObject blendMode = PdfName.Normal;
    private PdfObject softMask = PdfName.None;
    private float strokeAlpha = 1.0f;
    private float fillAlpha = 1.0f;
    private boolean alphaIsShape = false;
    private boolean strokeOverprint = false;
    private boolean fillOverprint = false;
    private int overprintMode = 0;
    private PdfObject blackGenerationFunction;
    private PdfObject blackGenerationFunction2;
    private PdfObject underColorRemovalFunction;
    private PdfObject underColorRemovalFunction2;
    private PdfObject transferFunction;
    private PdfObject transferFunction2;
    private PdfObject halftone;
    private float flatnessTolerance = 1.0f;
    private Float smoothnessTolerance;
    private PdfObject htp;

    protected CanvasGraphicsState() {
    }

    public CanvasGraphicsState(CanvasGraphicsState source) {
        this.copyFrom(source);
    }

    public void updateFromExtGState(PdfDictionary extGState) {
        this.updateFromExtGState(new PdfExtGState(extGState), extGState.getIndirectReference() == null ? null : extGState.getIndirectReference().getDocument());
    }

    public Matrix getCtm() {
        return this.ctm;
    }

    public void updateCtm(float a, float b, float c, float d, float e, float f) {
        this.updateCtm(new Matrix(a, b, c, d, e, f));
    }

    public void updateCtm(Matrix newCtm) {
        this.ctm = newCtm.multiply(this.ctm);
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }

    public void setStrokeColor(Color strokeColor) {
        this.strokeColor = strokeColor;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
    }

    public int getLineCapStyle() {
        return this.lineCapStyle;
    }

    public void setLineCapStyle(int lineCapStyle) {
        this.lineCapStyle = lineCapStyle;
    }

    public int getLineJoinStyle() {
        return this.lineJoinStyle;
    }

    public void setLineJoinStyle(int lineJoinStyle) {
        this.lineJoinStyle = lineJoinStyle;
    }

    public float getMiterLimit() {
        return this.miterLimit;
    }

    public void setMiterLimit(float miterLimit) {
        this.miterLimit = miterLimit;
    }

    public PdfArray getDashPattern() {
        return this.dashPattern;
    }

    public void setDashPattern(PdfArray dashPattern) {
        this.dashPattern = dashPattern;
    }

    public PdfName getRenderingIntent() {
        return this.renderingIntent;
    }

    public void setRenderingIntent(PdfName renderingIntent) {
        this.renderingIntent = renderingIntent;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
    }

    public PdfFont getFont() {
        return this.font;
    }

    public void setFont(PdfFont font) {
        this.font = font;
    }

    public int getTextRenderingMode() {
        return this.textRenderingMode;
    }

    public void setTextRenderingMode(int textRenderingMode) {
        this.textRenderingMode = textRenderingMode;
    }

    public float getTextRise() {
        return this.textRise;
    }

    public void setTextRise(float textRise) {
        this.textRise = textRise;
    }

    public float getFlatnessTolerance() {
        return this.flatnessTolerance;
    }

    public void setFlatnessTolerance(float flatnessTolerance) {
        this.flatnessTolerance = flatnessTolerance;
    }

    public void setWordSpacing(float wordSpacing) {
        this.wordSpacing = wordSpacing;
    }

    public float getWordSpacing() {
        return this.wordSpacing;
    }

    public void setCharSpacing(float characterSpacing) {
        this.charSpacing = characterSpacing;
    }

    public float getCharSpacing() {
        return this.charSpacing;
    }

    public float getLeading() {
        return this.leading;
    }

    public void setLeading(float leading) {
        this.leading = leading;
    }

    public float getHorizontalScaling() {
        return this.scale;
    }

    public void setHorizontalScaling(float scale) {
        this.scale = scale;
    }

    public boolean getStrokeOverprint() {
        return this.strokeOverprint;
    }

    public boolean getFillOverprint() {
        return this.fillOverprint;
    }

    public int getOverprintMode() {
        return this.overprintMode;
    }

    public PdfObject getBlackGenerationFunction() {
        return this.blackGenerationFunction;
    }

    public PdfObject getBlackGenerationFunction2() {
        return this.blackGenerationFunction2;
    }

    public PdfObject getUnderColorRemovalFunction() {
        return this.underColorRemovalFunction;
    }

    public PdfObject getUnderColorRemovalFunction2() {
        return this.underColorRemovalFunction2;
    }

    public PdfObject getTransferFunction() {
        return this.transferFunction;
    }

    public PdfObject getTransferFunction2() {
        return this.transferFunction2;
    }

    public PdfObject getHalftone() {
        return this.halftone;
    }

    public Float getSmoothnessTolerance() {
        return this.smoothnessTolerance;
    }

    public boolean getAutomaticStrokeAdjustment() {
        return this.automaticStrokeAdjustment;
    }

    public PdfObject getBlendMode() {
        return this.blendMode;
    }

    public PdfObject getSoftMask() {
        return this.softMask;
    }

    public float getStrokeOpacity() {
        return this.strokeAlpha;
    }

    public float getFillOpacity() {
        return this.fillAlpha;
    }

    public boolean getAlphaIsShape() {
        return this.alphaIsShape;
    }

    public boolean getTextKnockout() {
        return this.textKnockout;
    }

    public PdfObject getHTP() {
        return this.htp;
    }

    public void updateFromExtGState(PdfExtGState extGState) {
        this.updateFromExtGState(extGState, null);
    }

    void updateFromExtGState(PdfExtGState extGState, PdfDocument pdfDocument) {
        Boolean tk;
        Boolean ais;
        Float ca;
        PdfObject sMask;
        PdfObject bm;
        Boolean sa;
        Float sm;
        Float fl;
        PdfObject local_htp;
        PdfObject ht;
        PdfObject tr2;
        PdfObject tr;
        PdfObject ucr2;
        PdfObject ucr;
        PdfObject bg2;
        PdfObject bg;
        PdfArray fnt;
        Integer opm;
        Boolean op;
        PdfName ri;
        PdfArray d;
        Float ml;
        Integer lj;
        Integer lc;
        Float lw = extGState.getLineWidth();
        if (lw != null) {
            this.lineWidth = lw.floatValue();
        }
        if ((lc = extGState.getLineCapStyle()) != null) {
            this.lineCapStyle = lc;
        }
        if ((lj = extGState.getLineJoinStyle()) != null) {
            this.lineJoinStyle = lj;
        }
        if ((ml = extGState.getMiterLimit()) != null) {
            this.miterLimit = ml.floatValue();
        }
        if ((d = extGState.getDashPattern()) != null) {
            this.dashPattern = d;
        }
        if ((ri = extGState.getRenderingIntent()) != null) {
            this.renderingIntent = ri;
        }
        if ((op = extGState.getStrokeOverprintFlag()) != null) {
            this.strokeOverprint = op;
        }
        if ((op = extGState.getFillOverprintFlag()) != null) {
            this.fillOverprint = op;
        }
        if ((opm = extGState.getOverprintMode()) != null) {
            this.overprintMode = opm;
        }
        if ((fnt = extGState.getFont()) != null) {
            PdfNumber fntSz;
            PdfDictionary fontDictionary = fnt.getAsDictionary(0);
            if (this.font == null || this.font.getPdfObject() != fontDictionary) {
                this.font = pdfDocument.getFont(fontDictionary);
            }
            if ((fntSz = fnt.getAsNumber(1)) != null) {
                this.fontSize = fntSz.floatValue();
            }
        }
        if ((bg = extGState.getBlackGenerationFunction()) != null) {
            this.blackGenerationFunction = bg;
        }
        if ((bg2 = extGState.getBlackGenerationFunction2()) != null) {
            this.blackGenerationFunction2 = bg2;
        }
        if ((ucr = extGState.getUndercolorRemovalFunction()) != null) {
            this.underColorRemovalFunction = ucr;
        }
        if ((ucr2 = extGState.getUndercolorRemovalFunction2()) != null) {
            this.underColorRemovalFunction2 = ucr2;
        }
        if ((tr = extGState.getTransferFunction()) != null) {
            this.transferFunction = tr;
        }
        if ((tr2 = extGState.getTransferFunction2()) != null) {
            this.transferFunction2 = tr2;
        }
        if ((ht = extGState.getHalftone()) != null) {
            this.halftone = ht;
        }
        if ((local_htp = extGState.getHTP()) != null) {
            this.htp = local_htp;
        }
        if ((fl = extGState.getFlatnessTolerance()) != null) {
            this.flatnessTolerance = fl.floatValue();
        }
        if ((sm = extGState.getSmothnessTolerance()) != null) {
            this.smoothnessTolerance = sm;
        }
        if ((sa = extGState.getAutomaticStrokeAdjustmentFlag()) != null) {
            this.automaticStrokeAdjustment = sa;
        }
        if ((bm = extGState.getBlendMode()) != null) {
            this.blendMode = bm;
        }
        if ((sMask = extGState.getSoftMask()) != null) {
            this.softMask = sMask;
        }
        if ((ca = extGState.getStrokeOpacity()) != null) {
            this.strokeAlpha = ca.floatValue();
        }
        if ((ca = extGState.getFillOpacity()) != null) {
            this.fillAlpha = ca.floatValue();
        }
        if ((ais = extGState.getAlphaSourceFlag()) != null) {
            this.alphaIsShape = ais;
        }
        if ((tk = extGState.getTextKnockoutFlag()) != null) {
            this.textKnockout = tk;
        }
    }

    private void copyFrom(CanvasGraphicsState source) {
        this.ctm = source.ctm;
        this.strokeColor = source.strokeColor;
        this.fillColor = source.fillColor;
        this.charSpacing = source.charSpacing;
        this.wordSpacing = source.wordSpacing;
        this.scale = source.scale;
        this.leading = source.leading;
        this.font = source.font;
        this.fontSize = source.fontSize;
        this.textRenderingMode = source.textRenderingMode;
        this.textRise = source.textRise;
        this.textKnockout = source.textKnockout;
        this.lineWidth = source.lineWidth;
        this.lineCapStyle = source.lineCapStyle;
        this.lineJoinStyle = source.lineJoinStyle;
        this.miterLimit = source.miterLimit;
        this.dashPattern = source.dashPattern;
        this.renderingIntent = source.renderingIntent;
        this.automaticStrokeAdjustment = source.automaticStrokeAdjustment;
        this.blendMode = source.blendMode;
        this.softMask = source.softMask;
        this.strokeAlpha = source.strokeAlpha;
        this.fillAlpha = source.fillAlpha;
        this.alphaIsShape = source.alphaIsShape;
        this.strokeOverprint = source.strokeOverprint;
        this.fillOverprint = source.fillOverprint;
        this.overprintMode = source.overprintMode;
        this.blackGenerationFunction = source.blackGenerationFunction;
        this.blackGenerationFunction2 = source.blackGenerationFunction2;
        this.underColorRemovalFunction = source.underColorRemovalFunction;
        this.underColorRemovalFunction2 = source.underColorRemovalFunction2;
        this.transferFunction = source.transferFunction;
        this.transferFunction2 = source.transferFunction2;
        this.halftone = source.halftone;
        this.flatnessTolerance = source.flatnessTolerance;
        this.smoothnessTolerance = source.smoothnessTolerance;
        this.htp = source.htp;
    }
}

