/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.svg.renderers.impl;

import cfca.sadk.com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import cfca.sadk.com.itextpdf.styledxmlparser.css.util.CssUtils;
import cfca.sadk.com.itextpdf.svg.renderers.ISvgNodeRenderer;
import cfca.sadk.com.itextpdf.svg.renderers.SvgDrawContext;
import cfca.sadk.com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import cfca.sadk.com.itextpdf.svg.renderers.impl.SvgNodeUtil;
import cfca.sadk.com.itextpdf.svg.utils.DrawUtils;

public class EllipseSvgNodeRenderer
extends AbstractSvgNodeRenderer {
    float cx;
    float cy;
    float rx;
    float ry;

    @Override
    protected void doDraw(SvgDrawContext context) {
        PdfCanvas cv = context.getCurrentCanvas();
        cv.writeLiteral("% ellipse\n");
        if (this.setParameters()) {
            cv.moveTo(this.cx + this.rx, this.cy);
            DrawUtils.arc(this.cx - this.rx, this.cy - this.ry, this.cx + this.rx, this.cy + this.ry, 0.0f, 360.0f, cv);
        }
    }

    protected boolean setParameters() {
        this.cx = 0.0f;
        this.cy = 0.0f;
        if (this.getAttribute("cx") != null) {
            this.cx = CssUtils.parseAbsoluteLength(this.getAttribute("cx"));
        }
        if (this.getAttribute("cy") != null) {
            this.cy = CssUtils.parseAbsoluteLength(this.getAttribute("cy"));
        }
        float[] startPoint = SvgNodeUtil.getStartPoint(this);
        this.cx -= CssUtils.parseAbsoluteLength(String.valueOf(startPoint[0]));
        this.cy -= CssUtils.parseAbsoluteLength(String.valueOf(startPoint[1]));
        if (this.getAttribute("rx") == null || !(CssUtils.parseAbsoluteLength(this.getAttribute("rx")) > 0.0f)) {
            return false;
        }
        this.rx = CssUtils.parseAbsoluteLength(this.getAttribute("rx"));
        if (this.getAttribute("ry") == null || !(CssUtils.parseAbsoluteLength(this.getAttribute("ry")) > 0.0f)) {
            return false;
        }
        this.ry = CssUtils.parseAbsoluteLength(this.getAttribute("ry"));
        return true;
    }

    @Override
    public ISvgNodeRenderer createDeepCopy() {
        EllipseSvgNodeRenderer copy = new EllipseSvgNodeRenderer();
        this.deepCopyAttributesAndStyles(copy);
        return copy;
    }
}

