/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.svg.renderers.impl;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.com.itextpdf.kernel.color.Color;
import cfca.sadk.com.itextpdf.kernel.font.PdfFont;
import cfca.sadk.com.itextpdf.kernel.geom.AffineTransform;
import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.CanvasGraphicsState;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import cfca.sadk.com.itextpdf.kernel.pdf.extgstate.PdfExtGState;
import cfca.sadk.com.itextpdf.layout.Canvas;
import cfca.sadk.com.itextpdf.layout.property.TextAlignment;
import cfca.sadk.com.itextpdf.styledxmlparser.css.util.CssUtils;
import cfca.sadk.com.itextpdf.svg.exceptions.SvgProcessingException;
import cfca.sadk.com.itextpdf.svg.renderers.ISvgNodeRenderer;
import cfca.sadk.com.itextpdf.svg.renderers.SvgDrawContext;
import cfca.sadk.com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import cfca.sadk.com.itextpdf.svg.renderers.impl.ISvgTextNodeRenderer;
import cfca.sadk.com.itextpdf.svg.renderers.impl.PathSvgNodeRenderer;
import cfca.sadk.com.itextpdf.svg.renderers.impl.SvgNodeUtil;
import cfca.sadk.com.itextpdf.svg.utils.SvgTextUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextPathSvgNodeRenderer
extends AbstractSvgNodeRenderer
implements ISvgTextNodeRenderer {
    private static Logger businessLog = LoggerFactory.getLogger(TextPathSvgNodeRenderer.class);
    protected static final AffineTransform TEXTFLIP = new AffineTransform(1.0, 0.0, 0.0, -1.0, 0.0, 0.0);
    private static final double eps = 1.0E-5;
    private static final double TIMES = 1.3333;
    private static final String BASIC_STRING = "\u4e2d\u6587Aabgi-";
    private static final String LETTER_SPACING = "letter-spacing";
    private static final String STARTOFFSET = "startoffset";
    double x0;
    double x1;
    double x2;
    double x3;
    double y0;
    double y1;
    double y2;
    double y3;

    @Override
    public ISvgNodeRenderer createDeepCopy() {
        TextPathSvgNodeRenderer copy = new TextPathSvgNodeRenderer();
        this.deepCopyAttributesAndStyles(copy);
        return copy;
    }

    @Override
    public float getTextContentLength(float parentFontSize, PdfFont font) {
        float contentLength = 0.0f;
        if (font != null && this.attributesAndStyles != null && this.attributesAndStyles.containsKey("text_content")) {
            float fontSize = SvgTextUtil.resolveFontSize(this, parentFontSize);
            String content = (String)this.attributesAndStyles.get("text_content");
            contentLength = font.getWidth(content, fontSize);
        }
        return contentLength;
    }

    @Override
    public float[] getRelativeTranslation() {
        return new float[]{0.0f, 0.0f};
    }

    @Override
    public boolean containsRelativeMove() {
        return false;
    }

    @Override
    public boolean containsAbsolutePositionChange() {
        return false;
    }

    @Override
    public float[][] getAbsolutePositionChanges() {
        float[] part = new float[]{0.0f};
        return new float[][]{part, part};
    }

    @Override
    protected void doDraw(SvgDrawContext context) throws SvgProcessingException {
        if (this.attributesAndStyles != null && this.attributesAndStyles.containsKey("xlink:href")) {
            float dyOfPath;
            businessLog.info("attributesAndStyles=" + this.attributesAndStyles);
            PdfCanvas currentCanvas = context.getCurrentCanvas();
            currentCanvas.concatMatrix(this.calculateTransformation(context));
            String pathID = (String)this.attributesAndStyles.get("xlink:href");
            String text = (String)this.attributesAndStyles.get("text_content");
            String fontFamily = (String)this.attributesAndStyles.get("font-family");
            String fontSizeStr = (String)this.attributesAndStyles.get("font-size");
            String fontWeightStr = (String)this.attributesAndStyles.get("font-weight");
            String letterSpacingStr = (String)this.attributesAndStyles.get(LETTER_SPACING);
            String opacity = (String)this.attributesAndStyles.get("opacity");
            String x = this.getParent().getAttribute("x");
            String dyStr = this.getParent().getAttribute("dy");
            businessLog.info("TextPathSvgNodeRenderer text=" + text);
            String startOffsetStr = null;
            startOffsetStr = null != x && !"".equals(x) ? x : (String)this.attributesAndStyles.get(STARTOFFSET);
            try {
                dyOfPath = CssUtils.parseAbsoluteLength(dyStr);
            }
            catch (Exception e) {
                dyOfPath = 0.0f;
                businessLog.info("dyStr is [{}]", (Object)dyStr);
            }
            PathSvgNodeRenderer pathNode = (PathSvgNodeRenderer)context.getNamedObject(this.normalizeName(pathID));
            String d = pathNode.getAttribute("d");
            String[] ellipseParam = this.getParamFromD(d);
            float cx = CssUtils.parseAbsoluteLength(ellipseParam[0]);
            float cy = CssUtils.parseAbsoluteLength(ellipseParam[1]);
            float viewHeight = context.getCurrentViewPort().getHeight();
            cy = viewHeight - cy;
            float[] startPoints = SvgNodeUtil.getStartPoint(this);
            cx -= CssUtils.parseAbsoluteLength(String.valueOf(startPoints[0]));
            cy += CssUtils.parseAbsoluteLength(String.valueOf(startPoints[1]));
            float rx = CssUtils.parseAbsoluteLength(ellipseParam[2]);
            float ry = CssUtils.parseAbsoluteLength(ellipseParam[3]);
            String sweepFlag = ellipseParam[4];
            double startOffset = CssUtils.parseAbsoluteLength(this.getNumFromStr(startOffsetStr, "startOffset"));
            double letterSpacing = CssUtils.parseAbsoluteLength(this.getNumFromStr(letterSpacingStr == null ? "0" : letterSpacingStr, "letterSpacing"));
            float fontSize = CssUtils.parseAbsoluteFontSize(this.getNumFromStr(fontSizeStr, "fontSize"));
            PdfFont font = this.resolveFont(context, text);
            PdfDocument pdfDoc = currentCanvas.getDocument();
            businessLog.info("strokeColor opacity=" + opacity);
            PdfExtGState opacityGraphicsState = new PdfExtGState();
            Float strokeOpacity = Float.valueOf(opacity);
            opacityGraphicsState.setStrokeOpacity(strokeOpacity.floatValue() * strokeOpacity.floatValue());
            currentCanvas.setExtGState(opacityGraphicsState);
            Canvas cc = new Canvas(currentCanvas, pdfDoc, new Rectangle(2.0f * (rx + ry), 2.0f * (rx + ry)));
            cc.setFont(font);
            cc.setFontSize(fontSize);
            currentCanvas.setFontAndSize(font, fontSize);
            currentCanvas.saveState().moveTo(cx + rx, cy);
            List<double[]> ar = PdfCanvas.bezierArc(cx - rx, cy - ry, cx + rx, cy + ry, 0.0, 360.0);
            CanvasGraphicsState gs = currentCanvas.getGraphicsState();
            Color strokeColor = gs.getFillColor();
            cc.setStrokeColor(strokeColor);
            double[] startPoint = new double[]{cx + rx, cy};
            if (!ar.isEmpty()) {
                this.x0 = startPoint[0];
                this.y0 = startPoint[1];
                this.x1 = ar.get(0)[2];
                this.y1 = ar.get(0)[3];
                this.x2 = ar.get(0)[4];
                this.y2 = ar.get(0)[5];
                this.x3 = ar.get(0)[6];
                this.y3 = ar.get(0)[7];
            }
            currentCanvas.stroke().restoreState();
            businessLog.info("sweepFlag=" + sweepFlag);
            boolean isBold = false;
            boolean isItalic = false;
            if ("bold".equals(fontWeightStr)) {
                isBold = true;
                fontSize = this.getBoldFontSize(fontFamily, fontSize, text);
            } else if ("italic".equals(fontWeightStr)) {
                isItalic = true;
            } else if ("bolditalic".equals(fontWeightStr)) {
                isBold = true;
                isItalic = true;
                fontSize = this.getBoldFontSize(fontFamily, fontSize, text);
            }
            if ("1".equals(sweepFlag)) {
                float descent = (float)((double)font.getDescent(BASIC_STRING, fontSize) * 1.3333);
                float preFontWidth = 0.0f;
                for (int i = 0; i < text.length(); ++i) {
                    String chara;
                    boolean containUCS4 = false;
                    if (text.codePointAt(i) != text.charAt(i)) {
                        chara = text.substring(i, i + 2);
                        containUCS4 = true;
                    } else {
                        chara = text.substring(i, i + 1);
                    }
                    float fontWidth = font.getWidth(chara, fontSize);
                    startOffset = i != 0 ? startOffset + (double)(fontWidth / 2.0f) + (double)(preFontWidth / 2.0f) + letterSpacing : (startOffset += (double)(fontWidth / 2.0f));
                    businessLog.info("chara=" + chara + ",startOffset=" + startOffset);
                    this.drawACharOnBezierPath1(startPoint, ar, chara, startOffset, descent, cc, isBold, isItalic, dyOfPath);
                    if (containUCS4) {
                        ++i;
                    }
                    preFontWidth = fontWidth;
                }
            } else if ("0".equals(sweepFlag)) {
                float descent = (float)((double)font.getDescent(BASIC_STRING, fontSize) * 1.3333);
                float preFontWidth = 0.0f;
                for (int i = 0; i < text.length(); ++i) {
                    String chara;
                    boolean containUCS4 = false;
                    if (text.codePointAt(i) != text.charAt(i)) {
                        chara = text.substring(i, i + 2);
                        containUCS4 = true;
                    } else {
                        chara = text.substring(i, i + 1);
                    }
                    float fontWidth = font.getWidth(chara, fontSize);
                    startOffset = i != 0 ? startOffset + (double)(fontWidth / 2.0f) + (double)(preFontWidth / 2.0f) + letterSpacing : (startOffset += (double)(fontWidth / 2.0f));
                    businessLog.info("chara=" + chara + ",startOffset=" + startOffset);
                    this.drawACharOnBezierPath0(startPoint, ar, chara, startOffset, fontSize, descent, cc, isBold, isItalic, dyOfPath);
                    if (containUCS4) {
                        ++i;
                    }
                    preFontWidth = fontWidth;
                }
            }
            cc.close();
        }
    }

    private String[] getParamFromD(String d) throws SvgProcessingException {
        String[] param = new String[5];
        String numRegex = "(([1-9][0-9]*([.][0-9]+)?)|(0([.][0-9]+)?))";
        String pointRegex = numRegex + " *( |,) *" + numRegex;
        String regex = " *M *" + pointRegex + "( *A *" + pointRegex + " +0 +(0|1) +(0|1) +" + pointRegex + " *)+";
        if (!d.matches(regex)) {
            throw new SvgProcessingException("unable to handle this kind of path");
        }
        ArrayList<String> paramList = new ArrayList<String>();
        Pattern p = Pattern.compile(numRegex);
        Matcher m = p.matcher(d);
        while (m.find()) {
            paramList.add(m.group());
        }
        String cy = (String)paramList.get(1);
        String rx = (String)paramList.get(2);
        String ry = (String)paramList.get(3);
        String cx = String.valueOf(Double.parseDouble((String)paramList.get(0)) + Double.parseDouble(rx));
        String sweepFlag = (String)paramList.get(6);
        this.checkParamOfD(paramList, cx, cy, rx, ry);
        param[0] = cx;
        param[1] = cy;
        param[2] = rx;
        param[3] = ry;
        param[4] = sweepFlag;
        return param;
    }

    private void checkParamOfD(List<String> paramList, String cx, String cy, String rx, String ry) throws SvgProcessingException {
        double _cx = Double.parseDouble(cx);
        double _cy = Double.parseDouble(cy);
        double _rx = Double.parseDouble(rx);
        double _ry = Double.parseDouble(ry);
        String sweepFlag = paramList.get(6);
        int times = paramList.size() / 7;
        for (int i = 0; i < times; ++i) {
            if (!sweepFlag.equals(paramList.get(6 + i * 7))) {
                throw new SvgProcessingException("unable to handle this kind of path --- sweep-flag of the " + i + "th not equals sweep-flag=" + sweepFlag);
            }
            if (!rx.equals(paramList.get(2 + i * 7))) {
                throw new SvgProcessingException("unable to handle this kind of path --- rx of the " + i + "th A not equals rx=" + rx);
            }
            if (!ry.equals(paramList.get(3 + i * 7))) {
                throw new SvgProcessingException("unable to handle this kind of path --- ry of the " + i + "th A not equals ry=" + ry);
            }
            double x0 = Double.parseDouble(paramList.get(7 + i * 7));
            double y0 = Double.parseDouble(paramList.get(8 + i * 7));
            if (!(Math.pow(x0 - _cx, 2.0) / Math.pow(_rx, 2.0) + Math.pow(y0 - _cy, 2.0) / Math.pow(_ry, 2.0) - 1.0 > 1.0E-5)) continue;
            throw new SvgProcessingException("unable to handle this kind of path --- the " + i + "th (x,y)=(" + x0 + "," + y0 + ")");
        }
    }

    private void drawACharOnBezierPath0(double[] startPoint, List<double[]> path, String ch, double offset, double fontSize, float descent, Canvas cc, boolean isBold, boolean isItalic, float dyOfPath) {
        double len = this.getBezierLengh(0.0, 1.0, 1.0E-5);
        int times = (int)Math.floor(offset / len);
        int quadrant = times % 4;
        double stLen = offset - (double)times * len;
        if (quadrant == 3) {
            double[] qua1 = path.get(1);
            this.x0 = path.get(0)[6];
            this.y0 = path.get(0)[7];
            this.x1 = qua1[2];
            this.y1 = qua1[3];
            this.x2 = qua1[4];
            this.y2 = qua1[5];
            this.x3 = qua1[6];
            this.y3 = qua1[7];
            double t = this.getTByLen(stLen, 1.0E-5);
            double dy = this.y0 * (2.0 * t - t * t - 1.0) + this.y1 * (3.0 * t * t - 4.0 * t + 1.0) + this.y2 * (2.0 * t - 3.0 * t * t) + this.y3 * t * t;
            double dx = this.x0 * (2.0 * t - t * t - 1.0) + this.x1 * (3.0 * t * t - 4.0 * t + 1.0) + this.x2 * (2.0 * t - 3.0 * t * t) + this.x3 * t * t;
            double alpha = Math.atan(dy / dx);
            double _x = this.x0 * Math.pow(1.0 - t, 3.0) + 3.0 * this.x1 * t * (1.0 - t) * (1.0 - t) + 3.0 * this.x2 * t * t * (1.0 - t) + this.x3 * Math.pow(t, 3.0);
            double _y = this.y0 * Math.pow(1.0 - t, 3.0) + 3.0 * this.y1 * t * (1.0 - t) * (1.0 - t) + 3.0 * this.y2 * t * t * (1.0 - t) + this.y3 * Math.pow(t, 3.0);
            cc.showTextAligned(ch, (float)((_x -= ((double)(-descent) - fontSize + (double)dyOfPath) * Math.sin(alpha)) - fontSize * Math.sin(alpha)), (float)((_y += ((double)(-descent) - fontSize + (double)dyOfPath) * Math.cos(alpha)) + fontSize * Math.cos(alpha)), TextAlignment.CENTER, (float)(alpha + Math.PI), isBold, isItalic);
        } else if (quadrant == 2) {
            double[] qua2 = path.get(0);
            this.x0 = startPoint[0];
            this.y0 = startPoint[1];
            this.x1 = qua2[2];
            this.y1 = qua2[3];
            this.x2 = qua2[4];
            this.y2 = qua2[5];
            this.x3 = qua2[6];
            this.y3 = qua2[7];
            double t = this.getTByLen(stLen, 1.0E-5);
            double dy = this.y0 * (2.0 * t - t * t - 1.0) + this.y1 * (3.0 * t * t - 4.0 * t + 1.0) + this.y2 * (2.0 * t - 3.0 * t * t) + this.y3 * t * t;
            double dx = this.x0 * (2.0 * t - t * t - 1.0) + this.x1 * (3.0 * t * t - 4.0 * t + 1.0) + this.x2 * (2.0 * t - 3.0 * t * t) + this.x3 * t * t;
            double alpha = Math.atan(dy / dx);
            double _x = this.x0 * Math.pow(1.0 - t, 3.0) + 3.0 * this.x1 * t * (1.0 - t) * (1.0 - t) + 3.0 * this.x2 * t * t * (1.0 - t) + this.x3 * Math.pow(t, 3.0);
            double _y = this.y0 * Math.pow(1.0 - t, 3.0) + 3.0 * this.y1 * t * (1.0 - t) * (1.0 - t) + 3.0 * this.y2 * t * t * (1.0 - t) + this.y3 * Math.pow(t, 3.0);
            cc.showTextAligned(ch, (float)((_x -= ((double)(-descent) - fontSize + (double)dyOfPath) * Math.sin(alpha)) - fontSize * Math.sin(alpha)), (float)((_y += ((double)(-descent) - fontSize + (double)dyOfPath) * Math.cos(alpha)) + fontSize * Math.cos(alpha)), TextAlignment.CENTER, (float)(alpha + Math.PI), isBold, isItalic);
        } else if (quadrant == 1) {
            double[] qua3 = path.get(3);
            this.x0 = path.get(2)[6];
            this.y0 = path.get(2)[7];
            this.x1 = qua3[2];
            this.y1 = qua3[3];
            this.x2 = qua3[4];
            this.y2 = qua3[5];
            this.x3 = qua3[6];
            this.y3 = qua3[7];
            double t = this.getTByLen(stLen, 1.0E-5);
            double dy = this.y0 * (2.0 * t - t * t - 1.0) + this.y1 * (3.0 * t * t - 4.0 * t + 1.0) + this.y2 * (2.0 * t - 3.0 * t * t) + this.y3 * t * t;
            double dx = this.x0 * (2.0 * t - t * t - 1.0) + this.x1 * (3.0 * t * t - 4.0 * t + 1.0) + this.x2 * (2.0 * t - 3.0 * t * t) + this.x3 * t * t;
            double alpha = Math.atan(dy / dx);
            double _x = this.x0 * Math.pow(1.0 - t, 3.0) + 3.0 * this.x1 * t * (1.0 - t) * (1.0 - t) + 3.0 * this.x2 * t * t * (1.0 - t) + this.x3 * Math.pow(t, 3.0);
            double _y = this.y0 * Math.pow(1.0 - t, 3.0) + 3.0 * this.y1 * t * (1.0 - t) * (1.0 - t) + 3.0 * this.y2 * t * t * (1.0 - t) + this.y3 * Math.pow(t, 3.0);
            cc.showTextAligned(ch, (float)((_x += ((double)(-descent) - fontSize + (double)dyOfPath) * Math.sin(alpha)) + fontSize * Math.sin(alpha)), (float)((_y -= ((double)(-descent) - fontSize + (double)dyOfPath) * Math.cos(alpha)) - fontSize * Math.cos(alpha)), TextAlignment.CENTER, (float)alpha, isBold, isItalic);
        } else {
            double[] qua4 = path.get(2);
            this.x0 = path.get(1)[6];
            this.y0 = path.get(1)[7];
            this.x1 = qua4[2];
            this.y1 = qua4[3];
            this.x2 = qua4[4];
            this.y2 = qua4[5];
            this.x3 = qua4[6];
            this.y3 = qua4[7];
            double t = this.getTByLen(stLen, 1.0E-5);
            double dy = this.y0 * (2.0 * t - t * t - 1.0) + this.y1 * (3.0 * t * t - 4.0 * t + 1.0) + this.y2 * (2.0 * t - 3.0 * t * t) + this.y3 * t * t;
            double dx = this.x0 * (2.0 * t - t * t - 1.0) + this.x1 * (3.0 * t * t - 4.0 * t + 1.0) + this.x2 * (2.0 * t - 3.0 * t * t) + this.x3 * t * t;
            double alpha = Math.atan(dy / dx);
            double _x = this.x0 * Math.pow(1.0 - t, 3.0) + 3.0 * this.x1 * t * (1.0 - t) * (1.0 - t) + 3.0 * this.x2 * t * t * (1.0 - t) + this.x3 * Math.pow(t, 3.0);
            double _y = this.y0 * Math.pow(1.0 - t, 3.0) + 3.0 * this.y1 * t * (1.0 - t) * (1.0 - t) + 3.0 * this.y2 * t * t * (1.0 - t) + this.y3 * Math.pow(t, 3.0);
            cc.showTextAligned(ch, (float)((_x += ((double)(-descent) - fontSize + (double)dyOfPath) * Math.sin(alpha)) + fontSize * Math.sin(alpha)), (float)((_y -= ((double)(-descent) - fontSize + (double)dyOfPath) * Math.cos(alpha)) - fontSize * Math.cos(alpha)), TextAlignment.CENTER, (float)alpha, isBold, isItalic);
        }
    }

    private void drawACharOnBezierPath1(double[] startPoint, List<double[]> path, String ch, double offset, double descent, Canvas cc, boolean isBold, boolean isItalic, float dyOfPath) {
        double len = this.getBezierLengh(0.0, 1.0, 1.0E-5);
        int times = (int)Math.floor(offset / len);
        int quadrant = times % 4;
        double stLen = offset - (double)times * len;
        if (quadrant == 0) {
            double[] qua1 = path.get(1);
            this.x0 = path.get(0)[6];
            this.y0 = path.get(0)[7];
            this.x1 = qua1[2];
            this.y1 = qua1[3];
            this.x2 = qua1[4];
            this.y2 = qua1[5];
            this.x3 = qua1[6];
            this.y3 = qua1[7];
            double t = this.getTByLen(len - stLen, 1.0E-5);
            double dy = this.y0 * (2.0 * t - t * t - 1.0) + this.y1 * (3.0 * t * t - 4.0 * t + 1.0) + this.y2 * (2.0 * t - 3.0 * t * t) + this.y3 * t * t;
            double dx = this.x0 * (2.0 * t - t * t - 1.0) + this.x1 * (3.0 * t * t - 4.0 * t + 1.0) + this.x2 * (2.0 * t - 3.0 * t * t) + this.x3 * t * t;
            double alpha = Math.atan(dy / dx);
            double _x = this.x0 * Math.pow(1.0 - t, 3.0) + 3.0 * this.x1 * t * (1.0 - t) * (1.0 - t) + 3.0 * this.x2 * t * t * (1.0 - t) + this.x3 * Math.pow(t, 3.0);
            double _y = this.y0 * Math.pow(1.0 - t, 3.0) + 3.0 * this.y1 * t * (1.0 - t) * (1.0 - t) + 3.0 * this.y2 * t * t * (1.0 - t) + this.y3 * Math.pow(t, 3.0);
            cc.showTextAligned(ch, (float)(_x -= (descent - (double)dyOfPath) * Math.sin(alpha)), (float)(_y += (descent - (double)dyOfPath) * Math.cos(alpha)), TextAlignment.CENTER, (float)alpha, isBold, isItalic);
        } else if (quadrant == 1) {
            double[] qua2 = path.get(0);
            this.x0 = startPoint[0];
            this.y0 = startPoint[1];
            this.x1 = qua2[2];
            this.y1 = qua2[3];
            this.x2 = qua2[4];
            this.y2 = qua2[5];
            this.x3 = qua2[6];
            this.y3 = qua2[7];
            double t = this.getTByLen(len - stLen, 1.0E-5);
            double dy = this.y0 * (2.0 * t - t * t - 1.0) + this.y1 * (3.0 * t * t - 4.0 * t + 1.0) + this.y2 * (2.0 * t - 3.0 * t * t) + this.y3 * t * t;
            double dx = this.x0 * (2.0 * t - t * t - 1.0) + this.x1 * (3.0 * t * t - 4.0 * t + 1.0) + this.x2 * (2.0 * t - 3.0 * t * t) + this.x3 * t * t;
            double alpha = Math.atan(dy / dx);
            double _x = this.x0 * Math.pow(1.0 - t, 3.0) + 3.0 * this.x1 * t * (1.0 - t) * (1.0 - t) + 3.0 * this.x2 * t * t * (1.0 - t) + this.x3 * Math.pow(t, 3.0);
            double _y = this.y0 * Math.pow(1.0 - t, 3.0) + 3.0 * this.y1 * t * (1.0 - t) * (1.0 - t) + 3.0 * this.y2 * t * t * (1.0 - t) + this.y3 * Math.pow(t, 3.0);
            cc.showTextAligned(ch, (float)(_x -= (descent - (double)dyOfPath) * Math.sin(alpha)), (float)(_y += (descent - (double)dyOfPath) * Math.cos(alpha)), TextAlignment.CENTER, (float)alpha, isBold, isItalic);
        } else if (quadrant == 2) {
            double[] qua3 = path.get(3);
            this.x0 = path.get(2)[6];
            this.y0 = path.get(2)[7];
            this.x1 = qua3[2];
            this.y1 = qua3[3];
            this.x2 = qua3[4];
            this.y2 = qua3[5];
            this.x3 = qua3[6];
            this.y3 = qua3[7];
            double t = this.getTByLen(len - stLen, 1.0E-5);
            double dy = this.y0 * (2.0 * t - t * t - 1.0) + this.y1 * (3.0 * t * t - 4.0 * t + 1.0) + this.y2 * (2.0 * t - 3.0 * t * t) + this.y3 * t * t;
            double dx = this.x0 * (2.0 * t - t * t - 1.0) + this.x1 * (3.0 * t * t - 4.0 * t + 1.0) + this.x2 * (2.0 * t - 3.0 * t * t) + this.x3 * t * t;
            double alpha = Math.atan(dy / dx);
            double _x = this.x0 * Math.pow(1.0 - t, 3.0) + 3.0 * this.x1 * t * (1.0 - t) * (1.0 - t) + 3.0 * this.x2 * t * t * (1.0 - t) + this.x3 * Math.pow(t, 3.0);
            double _y = this.y0 * Math.pow(1.0 - t, 3.0) + 3.0 * this.y1 * t * (1.0 - t) * (1.0 - t) + 3.0 * this.y2 * t * t * (1.0 - t) + this.y3 * Math.pow(t, 3.0);
            cc.showTextAligned(ch, (float)(_x += (descent - (double)dyOfPath) * Math.sin(alpha)), (float)(_y -= (descent - (double)dyOfPath) * Math.cos(alpha)), TextAlignment.CENTER, (float)(alpha + Math.PI), isBold, isItalic);
        } else {
            double[] qua4 = path.get(2);
            this.x0 = path.get(1)[6];
            this.y0 = path.get(1)[7];
            this.x1 = qua4[2];
            this.y1 = qua4[3];
            this.x2 = qua4[4];
            this.y2 = qua4[5];
            this.x3 = qua4[6];
            this.y3 = qua4[7];
            double t = this.getTByLen(len - stLen, 1.0E-5);
            double dy = this.y0 * (2.0 * t - t * t - 1.0) + this.y1 * (3.0 * t * t - 4.0 * t + 1.0) + this.y2 * (2.0 * t - 3.0 * t * t) + this.y3 * t * t;
            double dx = this.x0 * (2.0 * t - t * t - 1.0) + this.x1 * (3.0 * t * t - 4.0 * t + 1.0) + this.x2 * (2.0 * t - 3.0 * t * t) + this.x3 * t * t;
            double alpha = Math.atan(dy / dx);
            double _x = this.x0 * Math.pow(1.0 - t, 3.0) + 3.0 * this.x1 * t * (1.0 - t) * (1.0 - t) + 3.0 * this.x2 * t * t * (1.0 - t) + this.x3 * Math.pow(t, 3.0);
            double _y = this.y0 * Math.pow(1.0 - t, 3.0) + 3.0 * this.y1 * t * (1.0 - t) * (1.0 - t) + 3.0 * this.y2 * t * t * (1.0 - t) + this.y3 * Math.pow(t, 3.0);
            cc.showTextAligned(ch, (float)(_x += (descent - (double)dyOfPath) * Math.sin(alpha)), (float)(_y -= (descent - (double)dyOfPath) * Math.cos(alpha)), TextAlignment.CENTER, (float)(alpha + Math.PI), isBold, isItalic);
        }
    }

    private double getTByLen(double len, double eps) {
        double l = 0.0;
        double r = 1.0;
        double rl = this.getBezierLengh(0.0, r, eps);
        if (rl < len) {
            return -1.0;
        }
        while (r - l >= eps) {
            double mid = (l + r) / 2.0;
            if (this.getBezierLengh(0.0, mid, eps) > len) {
                r = mid;
                continue;
            }
            l = mid;
        }
        return (l + r) / 2.0;
    }

    private double bezierFunction(double t) {
        double dyddt = 3.0 * this.y0 * (2.0 * t - t * t - 1.0) + 3.0 * this.y1 * (3.0 * t * t - 4.0 * t + 1.0) + 3.0 * this.y2 * (2.0 * t - 3.0 * t * t) + 3.0 * this.y3 * t * t;
        double dxddt = 3.0 * this.x0 * (2.0 * t - t * t - 1.0) + 3.0 * this.x1 * (3.0 * t * t - 4.0 * t + 1.0) + 3.0 * this.x2 * (2.0 * t - 3.0 * t * t) + 3.0 * this.x3 * t * t;
        return Math.pow(Math.pow(dxddt, 2.0) + Math.pow(dyddt, 2.0), 0.5);
    }

    private double simpson(double a, double b) {
        double c = (a + b) / 2.0;
        return (this.bezierFunction(a) + 4.0 * this.bezierFunction(c) + this.bezierFunction(b)) * (b - a) / 6.0;
    }

    private double asr(double a, double b, double eps, double A) {
        double R;
        double c = a + (b - a) / 2.0;
        double L = this.simpson(a, c);
        if (Math.abs(L + (R = this.simpson(c, b)) - A) <= 15.0 * eps) {
            return L + R + (L + R - A) / 15.0;
        }
        return this.asr(a, c, eps / 2.0, L) + this.asr(c, b, eps / 2.0, R);
    }

    private double getBezierLengh(double a, double b, double eps) {
        return this.asr(a, b, eps, this.simpson(a, b));
    }

    private float getBoldFontSize(String fontFamily, float fontSize, String text) {
        float realFontSize = 0.0f;
        realFontSize = fontFamily != null && (fontFamily.contains("\u5fae\u8f6f\u96c5\u9ed1") || fontFamily.toLowerCase().replaceAll(" ", "").contains("microsoftyahei")) ? fontSize : (fontSize < 28.0f ? fontSize + 1.0f : fontSize + 2.0f);
        return realFontSize;
    }
}

