/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.svg.renderers.path.impl;

import cfca.sadk.com.itextpdf.io.util.MessageFormatUtil;
import cfca.sadk.com.itextpdf.kernel.geom.Point;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import cfca.sadk.com.itextpdf.styledxmlparser.css.util.CssUtils;
import cfca.sadk.com.itextpdf.svg.renderers.path.impl.AbstractPathShape;
import cfca.sadk.com.itextpdf.svg.renderers.path.impl.DefaultOperatorConverter;
import cfca.sadk.com.itextpdf.svg.renderers.path.impl.IControlPointCurve;
import cfca.sadk.com.itextpdf.svg.renderers.path.impl.IOperatorConverter;
import java.util.Arrays;

public class QuadraticCurveTo
extends AbstractPathShape
implements IControlPointCurve {
    static final int ARGUMENT_SIZE = 4;

    public QuadraticCurveTo() {
        this(false);
    }

    public QuadraticCurveTo(boolean relative) {
        this(relative, new DefaultOperatorConverter());
    }

    public QuadraticCurveTo(boolean relative, IOperatorConverter copier) {
        super(relative, copier);
    }

    @Override
    public void draw(PdfCanvas canvas) {
        float x1 = CssUtils.parseAbsoluteLength(this.coordinates[0]);
        float y1 = CssUtils.parseAbsoluteLength(this.coordinates[1]);
        float x = CssUtils.parseAbsoluteLength(this.coordinates[2]);
        float y = CssUtils.parseAbsoluteLength(this.coordinates[3]);
        canvas.curveTo(x1, y1, x, y);
    }

    @Override
    public void setCoordinates(String[] inputCoordinates, Point startPoint) {
        if (inputCoordinates.length < 4) {
            throw new IllegalArgumentException(MessageFormatUtil.format("(x1 y1 x y)+ parameters are expected for quadratic curves. Got: {0}", Arrays.toString(this.coordinates)));
        }
        this.coordinates = new String[4];
        System.arraycopy(inputCoordinates, 0, this.coordinates, 0, 4);
        double[] initialPoint = new double[]{startPoint.getX(), startPoint.getY()};
        if (this.isRelative()) {
            this.coordinates = this.copier.makeCoordinatesAbsolute(this.coordinates, initialPoint);
        }
    }

    @Override
    public Point getLastControlPoint() {
        return this.createPoint(this.coordinates[0], this.coordinates[1]);
    }
}

