/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.base.bean.appearance;

import cfca.sadk.com.itextpdf.kernel.color.Color;
import cfca.sadk.com.itextpdf.kernel.font.PdfFont;
import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.layout.property.TextAlignment;
import cfca.sadk.com.itextpdf.layout.property.VerticalAlignment;
import cfca.sadk.seal.base.bean.appearance.GraphicAppearance;
import cfca.sadk.seal.base.exception.SealException;

public class MixAppearance
extends GraphicAppearance {
    private String signText;
    private float textRectHeight;
    private float imageRectHeight;
    private float fontSize = 0.0f;
    private Color fontColor;
    private PdfFont font;
    private TextAlignment alignmentH = TextAlignment.CENTER;
    private VerticalAlignment alignmentV = VerticalAlignment.TOP;
    private VerticalAlignment graphicAlignmentV = VerticalAlignment.MIDDLE;
    private boolean changeImageHeight = true;
    private boolean reverseRectangle = false;

    public String getSignText() {
        return this.signText;
    }

    public void setSignText(String signText) {
        this.signText = signText;
    }

    public float getTextRectHeight() {
        return this.textRectHeight;
    }

    public float getImageRectHeight() {
        return this.imageRectHeight;
    }

    public void setTextRectHeight(float textRectHeight) throws SealException {
        Rectangle rect = this.getRectangle();
        if (rect == null) {
            throw new SealException("invoke setRectangle() first!");
        }
        if (textRectHeight <= 10.0f || textRectHeight > rect.getHeight()) {
            throw new SealException("The value of textRectHeight must be greater than 10 and less than " + rect.getHeight() + "!");
        }
        this.textRectHeight = textRectHeight;
    }

    public void setImageRectHeight(float imageRectHeight) throws SealException {
        Rectangle rect = this.getRectangle();
        if (rect == null) {
            throw new SealException("invoke setRectangle() first!");
        }
        if (imageRectHeight <= 10.0f || imageRectHeight > rect.getHeight()) {
            throw new SealException("The value of imageRectHeight must be greater than 10 and less than " + rect.getHeight() + "!");
        }
        this.imageRectHeight = imageRectHeight;
    }

    public void setTextRectHeightPercent(float textRectHeightPercent) throws SealException {
        Rectangle rect = this.getRectangle();
        if (rect == null) {
            throw new SealException("invoke setRectangle() first!");
        }
        if (textRectHeightPercent <= 0.0f || textRectHeightPercent > 1.0f) {
            throw new SealException("The value of textRectHeightPercent must be greater than 0 and less than or equal to 1 ");
        }
        this.setTextRectHeight(rect.getHeight() * textRectHeightPercent);
    }

    public void setImageRectHeightPercent(float imageRectHeightPercent) throws SealException {
        Rectangle rect = this.getRectangle();
        if (rect == null) {
            throw new SealException("invoke setRectangle() first!");
        }
        if (imageRectHeightPercent <= 0.0f || imageRectHeightPercent > 1.0f) {
            throw new SealException("The value of imageRectHeightPercent must be greater than 0 and less than or equal to 1 ");
        }
        this.setImageRectHeight(rect.getHeight() * imageRectHeightPercent);
    }

    @Override
    public void setRectangle(Rectangle rectangle) {
        if (null == rectangle) {
            throw new IllegalArgumentException("rectangle is null!");
        }
        super.setRectangle(rectangle);
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(float fontSize) throws SealException {
        if (fontSize <= 0.0f) {
            throw new SealException("fontSize must be greater than zero!");
        }
        this.fontSize = fontSize;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(Color fontColor) {
        this.fontColor = fontColor;
    }

    public PdfFont getFont() {
        return this.font;
    }

    public void setFont(PdfFont font) {
        this.font = font;
    }

    public TextAlignment getAlignmentH() {
        return this.alignmentH;
    }

    public void setAlignmentH(TextAlignment alignmentH) {
        this.alignmentH = alignmentH;
    }

    public VerticalAlignment getAlignmentV() {
        return this.alignmentV;
    }

    public void setAlignmentV(VerticalAlignment alignmentV) {
        this.alignmentV = alignmentV;
    }

    public boolean isChangeImageHeight() {
        return this.changeImageHeight;
    }

    public void setChangeImageHeight(boolean changeImageHeight) {
        this.changeImageHeight = changeImageHeight;
    }

    public boolean isReverseRectangle() {
        return this.reverseRectangle;
    }

    public void setReverseRectangle(boolean reverseRectangle) {
        this.reverseRectangle = reverseRectangle;
    }

    public VerticalAlignment getGraphicAlignmentV() {
        return this.graphicAlignmentV;
    }

    public void setGraphicAlignmentV(VerticalAlignment graphicAlignmentV) {
        this.graphicAlignmentV = graphicAlignmentV;
    }
}

