/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.base.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.com.itextpdf.io.source.RASInputStream;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDictionary;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.signatures.ITSAClient;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.seal.base.bean.sign.SignInfoConfig;
import cfca.sadk.seal.base.config.SysEnv;
import cfca.sadk.seal.base.exception.SealException;
import cfca.sadk.seal.base.external.AbstractExternalP7Signer;
import cfca.sadk.seal.base.util.Constants;
import cfca.sadk.seal.base.util.MethodCostTimeUtil;
import cfca.sadk.seal.base.util.ParamsCheckUtil;
import cfca.sadk.seal.base.util.PdfHashUtil;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;

public class CFCAP7Signer
extends AbstractExternalP7Signer {
    private static Logger businessLog = LoggerFactory.getLogger(CFCAP7Signer.class);
    protected Mechanism mechanism = null;
    protected Session session = null;
    protected X509Cert[] signCerts;
    protected X509Cert signCert = null;
    protected PrivateKey privatekey = null;
    protected boolean isContainChain = false;
    private int estimatedSize = 8192;
    private ITSAClient tsaClient = null;
    private boolean isAsyn = false;
    private byte[] hashValue = null;
    private boolean isSecondHash = false;

    public CFCAP7Signer(SignInfoConfig signatureConfig) throws SealException {
        ParamsCheckUtil.checkPrimaryParam(signatureConfig);
        this.signInfoConfig = signatureConfig;
        this.estimatedSize = signatureConfig.getPKCS7SigEstimatedSize();
        this.mechanism = signatureConfig.getSignAlg();
        this.privatekey = signatureConfig.getPrivateKey();
        this.session = this.getSession(signatureConfig.getSession());
        this.tsaClient = signatureConfig.getTsaClient();
        this.signCerts = signatureConfig.getCerts();
        ParamsCheckUtil.checkCertValidity(this.signCerts[0]);
        this.signCert = signatureConfig.getSignCert();
        this.isContainChain = signatureConfig.isP7ContainChain();
        this.isAsyn = signatureConfig.isAsyn();
        this.isSecondHash = signatureConfig.isSecondHash();
    }

    @Override
    public void modifySigningDictionary(PdfDictionary signDic) {
        signDic.put(PdfName.Filter, PdfName.Adobe_PPKLite);
        if (Mechanisms.isSM2WithSM3((Mechanism)this.mechanism)) {
            if (this.isSecondHash) {
                signDic.put(PdfName.SubFilter, SysEnv.isUseCFCASubFilter() ? Constants.CFCA_SM2_ATTACH_FILTER : Constants.SM2_ATTACH_FILTER);
            } else {
                signDic.put(PdfName.SubFilter, SysEnv.isUseCFCASubFilter() ? Constants.CFCA_SM2_FILTER : Constants.SM2_FILTER);
            }
        } else if (this.isSecondHash && Mechanisms.M_SHA1_RSA.equals((Object)this.mechanism)) {
            signDic.put(PdfName.SubFilter, PdfName.Adbe_pkcs7_sha1);
        } else {
            signDic.put(PdfName.SubFilter, PdfName.Adbe_pkcs7_detached);
        }
    }

    @Override
    public byte[] sign(InputStream paramInputStream) throws GeneralSecurityException {
        byte[] hash = null;
        byte[] signedData = null;
        String methodid = MethodCostTimeUtil.recordStartTime("----CFCAP7Signer.sign");
        try {
            if (Mechanisms.isSM2WithSM3((Mechanism)this.mechanism)) {
                SM2PublicKey sm2PublicKey = null;
                if (!this.isSecondHash && (sm2PublicKey = (SM2PublicKey)this.signCert.getPublicKey()) == null) {
                    throw new GeneralSecurityException("sm2PublicKey is null");
                }
                hash = PdfHashUtil.calculateHashOfSourceData((RASInputStream)paramInputStream, this.mechanism, sm2PublicKey);
            } else {
                hash = PdfHashUtil.calculateHashOfSourceData((RASInputStream)paramInputStream, this.mechanism, null);
            }
            byte[] binarySignValue = new byte[64];
            X509Cert[] tmpSignCerts = this.signCerts;
            byte[] timeStampPKCS7 = null;
            if (!this.isContainChain) {
                tmpSignCerts = new X509Cert[]{this.signCerts[0]};
            }
            if (this.isAsyn) {
                this.hashValue = hash;
            } else {
                String methodid11 = MethodCostTimeUtil.recordStartTime("----CFCAP7Signer.sign.singleSign");
                binarySignValue = this.session.signByHash(this.mechanism, this.privatekey, hash);
                MethodCostTimeUtil.recordEndTime(methodid11);
            }
            timeStampPKCS7 = this.getTimeStamp(this.tsaClient, this.SM2RStoASN1(binarySignValue));
            if (null != this.tsaClient) {
                ParamsCheckUtil.checkTimestampValidity(this.tsaClient.getSignTime(), this.signCert);
            }
            String methodid2 = MethodCostTimeUtil.recordStartTime("----CFCAP7Signer.sign.packagePKCS7");
            signedData = this.packagePKCS7(this.session, null, binarySignValue, this.mechanism, timeStampPKCS7, null, tmpSignCerts);
            MethodCostTimeUtil.recordEndTime(methodid2);
            this.estimatedSize = signedData.length;
            byte[] byArray = signedData;
            return byArray;
        }
        catch (GeneralSecurityException e) {
            businessLog.error("CFCAP7Signer sign failed", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("CFCAP7Signer sign failed", (Throwable)e);
            throw new GeneralSecurityException("CFCAP7Signer sign failed", e);
        }
        finally {
            MethodCostTimeUtil.recordEndTime(methodid);
        }
    }

    @Override
    public int getEstimatedSize() {
        return this.estimatedSize + 64;
    }

    @Override
    public byte[] getHashValue() {
        return this.hashValue;
    }
}

