/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.base.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.seal.base.bean.svg.SVGData;
import cfca.sadk.seal.base.exception.SealException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class SVGUtil {
    private static Logger businessLog = LoggerFactory.getLogger(SVGUtil.class);

    public static float[] getSVGPixel(byte[] svgData) throws Exception {
        float[] widthAndHeight = new float[2];
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder bulider = dbf.newDocumentBuilder();
        org.w3c.dom.Document doc = bulider.parse(new ByteArrayInputStream(svgData));
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        NodeList nodes = (NodeList)xpath.evaluate(".//*[name()='svg']", doc, XPathConstants.NODESET);
        NamedNodeMap svgAttr = nodes.item(0).getAttributes();
        String width = svgAttr.getNamedItem("width").getNodeValue();
        String height = svgAttr.getNamedItem("height").getNodeValue();
        if (width.contains("px") && height.contains("px")) {
            widthAndHeight[0] = Float.valueOf(width.replace("px", "")).floatValue();
            widthAndHeight[1] = Float.valueOf(height.replace("px", "")).floatValue();
        } else if (width.contains("%") && height.contains("%")) {
            String viewbox = svgAttr.getNamedItem("viewBox").getNodeValue();
            String[] datas = viewbox.split(",");
            if (0.0f != Float.valueOf(datas[0]).floatValue() && 0.0f != Float.valueOf(datas[1]).floatValue()) {
                throw new SealException("viewBox must start with (0,0)");
            }
            widthAndHeight[0] = Float.valueOf(datas[2]).floatValue();
            widthAndHeight[1] = Float.valueOf(datas[3]).floatValue();
        } else {
            widthAndHeight[0] = Float.valueOf(width).floatValue();
            widthAndHeight[1] = Float.valueOf(height).floatValue();
        }
        return widthAndHeight;
    }

    public static SVGData resetSVGPixel(byte[] svgData, float rectWidth, float rectHeight) throws Exception {
        SVGData svgDataBean = new SVGData();
        byte[] newSvgBytes = svgData;
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(svgData);
            SAXReader saxReader = new SAXReader();
            Document document = saxReader.read((InputStream)inputStream);
            Element root = document.getRootElement();
            Attribute widthAttr = root.attribute("width");
            Attribute heightAttr = root.attribute("height");
            String width = widthAttr.getValue();
            String height = heightAttr.getValue();
            float svgWidth = 0.0f;
            float svgHeight = 0.0f;
            if (width.contains("px") && height.contains("px")) {
                svgWidth = Float.valueOf(width.replace("px", "")).floatValue();
                svgHeight = Float.valueOf(height.replace("px", "")).floatValue();
            } else if (width.contains("%") && height.contains("%")) {
                String viewbox = root.attribute("viewBox").getValue();
                String[] datas = viewbox.split(",");
                if (0.0f != Float.valueOf(datas[0]).floatValue() && 0.0f != Float.valueOf(datas[1]).floatValue()) {
                    throw new SealException("viewBox must start with (0,0)");
                }
                svgWidth = Float.valueOf(datas[2]).floatValue();
                svgHeight = Float.valueOf(datas[3]).floatValue();
            } else {
                svgWidth = Float.valueOf(width).floatValue();
                svgHeight = Float.valueOf(height).floatValue();
            }
            float radio = Math.min(rectWidth * 96.0f / 72.0f / svgWidth, rectHeight * 96.0f / 72.0f / svgHeight);
            float realWidth = svgWidth * radio;
            float realHeight = svgHeight * radio;
            widthAttr.setValue(String.valueOf(realWidth));
            heightAttr.setValue(String.valueOf(realHeight));
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            SVGUtil.writeXml(document, output);
            svgDataBean.setWidth(realWidth * 72.0f / 96.0f);
            svgDataBean.setHeight(realHeight * 72.0f / 96.0f);
            newSvgBytes = output.toByteArray();
        }
        catch (Exception e) {
            businessLog.error("resetSVGPixel failed:", (Throwable)e);
        }
        svgDataBean.setSvgBytes(newSvgBytes);
        return svgDataBean;
    }

    public static void writeXml(Document document, ByteArrayOutputStream outputStream) throws IOException {
        if (null == document) {
            throw new IllegalArgumentException("document is null!");
        }
        if (null == outputStream) {
            throw new IllegalArgumentException("outputStream is null!");
        }
        XMLWriter writer = null;
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF8");
            writer = new XMLWriter((OutputStream)outputStream, format);
            writer.write(document);
            writer.close();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (null != writer) {
                writer.close();
            }
        }
    }
}

