/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.base.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.com.itextpdf.forms.PdfAcroForm;
import cfca.sadk.com.itextpdf.forms.PdfSigFieldLockDictionary;
import cfca.sadk.com.itextpdf.forms.fields.PdfFormField;
import cfca.sadk.com.itextpdf.forms.fields.PdfSignatureFormField;
import cfca.sadk.com.itextpdf.io.source.IRandomAccessSource;
import cfca.sadk.com.itextpdf.io.source.RASInputStream;
import cfca.sadk.com.itextpdf.io.source.RandomAccessFileOrArray;
import cfca.sadk.com.itextpdf.io.source.RandomAccessSourceFactory;
import cfca.sadk.com.itextpdf.io.source.WindowRandomAccessSource;
import cfca.sadk.com.itextpdf.io.util.StreamUtil;
import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfArray;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDate;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDictionary;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfNumber;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfPage;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfReader;
import cfca.sadk.com.itextpdf.kernel.pdf.annot.PdfWidgetAnnotation;
import cfca.sadk.com.itextpdf.signatures.PdfPKCS7;
import cfca.sadk.com.itextpdf.signatures.SignatureUtil;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.org.bouncycastle.asn1.cms.ContentInfo;
import cfca.sadk.org.bouncycastle.asn1.sm2.ASN1SM2Signature;
import cfca.sadk.org.bouncycastle.asn1.tsp.MessageImprint;
import cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import cfca.sadk.org.bouncycastle.tsp.TimeStampToken;
import cfca.sadk.paperless.util.PaperlessP7Util;
import cfca.sadk.seal.base.bean.sign.SealVerifyResult;
import cfca.sadk.seal.base.bean.sign.VerifyInfo;
import cfca.sadk.seal.base.config.SysEnv;
import cfca.sadk.seal.base.exception.SealException;
import cfca.sadk.seal.base.util.Constants;
import cfca.sadk.seal.base.util.KMPUtil;
import cfca.sadk.seal.base.util.MechanismUtil;
import cfca.sadk.seal.base.util.MethodCostTimeUtil;
import cfca.sadk.seal.base.util.PDFUtil;
import cfca.sadk.seal.base.util.ParamsCheckUtil;
import cfca.sadk.seal.base.util.PdfHashUtil;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.util.HashUtil;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VerifyProxy {
    private SignatureUtil signatureUtil = null;
    private PdfDocument pdfDocument = null;
    public static final BouncyCastleProvider provider = new BouncyCastleProvider();
    private static Logger businessLog = LoggerFactory.getLogger(VerifyProxy.class);
    public static final String XREF = "xref";
    public static final String EOF = "%%EOF";
    private static byte[] xrefBytes = null;
    private static byte[] eofBytes = null;
    private static int[] xrefNext = null;
    private static int[] eofNext = null;
    private String errorMessage = null;

    public VerifyProxy() {
    }

    public VerifyProxy(PdfDocument pdfDocument) {
        this.signatureUtil = new SignatureUtil(pdfDocument, true);
    }

    public VerifyProxy(byte[] sourceData) throws IOException {
        String methodid = MethodCostTimeUtil.recordStartTime("VerifyProxy construct");
        this.errorMessage = ParamsCheckUtil.checkIsValidPdfFile(sourceData, false);
        PdfReader pdfReader = new PdfReader(sourceData);
        this.pdfDocument = new PdfDocument(pdfReader);
        this.signatureUtil = new SignatureUtil(this.pdfDocument, true);
        MethodCostTimeUtil.recordEndTime(methodid);
    }

    public VerifyProxy(InputStream inputStream, byte[] openPassword) throws IOException {
        String methodid = MethodCostTimeUtil.recordStartTime("VerifyProxy construct");
        byte[] sourceData = StreamUtil.inputStreamToArray(inputStream);
        this.errorMessage = ParamsCheckUtil.checkIsValidPdfFile(sourceData, false);
        PdfReader pdfReader = new PdfReader(sourceData);
        if (null != openPassword) {
            pdfReader.setOpenPassword(openPassword);
        }
        this.pdfDocument = new PdfDocument(pdfReader);
        this.signatureUtil = new SignatureUtil(this.pdfDocument, true);
        MethodCostTimeUtil.recordEndTime(methodid);
    }

    public VerifyProxy(PdfReader pdfReader, byte[] openPassword) throws IOException {
        String methodid = MethodCostTimeUtil.recordStartTime("VerifyProxy construct");
        if (null != openPassword) {
            pdfReader.setOpenPassword(openPassword);
        }
        this.pdfDocument = new PdfDocument(pdfReader);
        this.signatureUtil = new SignatureUtil(this.pdfDocument, true);
        MethodCostTimeUtil.recordEndTime(methodid);
    }

    public VerifyProxy(byte[] sourceData, byte[] openPassword) throws IOException {
        long start = System.currentTimeMillis();
        this.errorMessage = ParamsCheckUtil.checkIsValidPdfFile(sourceData, false);
        PdfReader pdfReader = new PdfReader(sourceData);
        if (null != openPassword) {
            pdfReader.setOpenPassword(openPassword);
        }
        this.pdfDocument = new PdfDocument(pdfReader);
        this.signatureUtil = new SignatureUtil(this.pdfDocument, true);
        long end = System.currentTimeMillis();
        businessLog.info("VerifyProxy load pdf file cost = " + (end - start) + " ms");
    }

    public List<String> getSignatureNames() {
        return this.signatureUtil.getSignatureNames();
    }

    public SealVerifyResult verifySignature() throws GeneralSecurityException {
        return this.verifySignature(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SealVerifyResult verifySignature(boolean isCheckSignature, boolean isCheckModified) throws GeneralSecurityException {
        long start = System.currentTimeMillis();
        SealVerifyResult verifyResult = new SealVerifyResult();
        HashMap<String, VerifyInfo> resultMap = verifyResult.getVerifyInfos();
        try {
            List<String> signedNames = this.signatureUtil.getSignatureNames();
            HashMap<Integer, PdfPKCS7> valuePkcs7Map = new HashMap<Integer, PdfPKCS7>();
            if (signedNames.size() > 0) {
                if (this.errorMessage != null) {
                    verifyResult.setFailReason(this.errorMessage);
                    verifyResult.setFailType(9);
                    SealVerifyResult sealVerifyResult = verifyResult;
                    return sealVerifyResult;
                }
                if (isCheckSignature) {
                    for (int i = 0; i < signedNames.size(); ++i) {
                        long end;
                        VerifyInfo verifyInfo = new VerifyInfo();
                        String name = signedNames.get(i);
                        PdfDictionary tmpSigDict = this.signatureUtil.getSignatureDictionary(name);
                        int objNumber = tmpSigDict.getIndirectReference().getObjNumber();
                        PdfPKCS7 previousPkcs7 = valuePkcs7Map.put(objNumber, null);
                        PdfPKCS7 pkcs7 = null;
                        if (previousPkcs7 == null) {
                            pkcs7 = this.signatureUtil.verifySignature(name, provider.getName());
                            valuePkcs7Map.put(objNumber, pkcs7);
                        } else {
                            PdfPKCS7 tmpPkcs7 = previousPkcs7;
                            pkcs7 = new PdfPKCS7(tmpPkcs7);
                            pkcs7.setSignName(name);
                            valuePkcs7Map.put(objNumber, pkcs7);
                        }
                        byte[] pkcs7Data = pkcs7.getContentsKey();
                        X509Certificate signCert = pkcs7.getSignCert();
                        Date signDate = null;
                        try {
                            signDate = this.getTimeStampTime(pkcs7Data, pkcs7.getDigest());
                        }
                        catch (SealException e2) {
                            verifyResult.setFailType(11);
                            verifyResult.setFailReason(e2.getMessage());
                            SealVerifyResult sealVerifyResult = verifyResult;
                            this.close();
                            end = System.currentTimeMillis();
                            businessLog.info("verifySignature cost= " + (end - start) + " ms");
                            return sealVerifyResult;
                        }
                        if (signDate == null) {
                            String signDateString = this.signatureUtil.getSignature(name).getDate().getValue();
                            signDate = PdfDate.decode(signDateString).getTime();
                        }
                        X509Cert x509SignCert = new X509Cert(signCert.getEncoded());
                        try {
                            ParamsCheckUtil.checkCertValidity(x509SignCert, signDate);
                        }
                        catch (Exception e1) {
                            String errorMessage = e1.getMessage();
                            verifyResult.setVerifyResult(false);
                            verifyResult.setFailReason(errorMessage);
                            if (errorMessage.contains("x509Cert is not valid")) {
                                verifyResult.setFailType(5);
                            } else if (errorMessage.contains("x509Cert is expired")) {
                                verifyResult.setFailType(6);
                            } else if (errorMessage.contains("x509Cert is not trusted")) {
                                verifyResult.setFailType(8);
                            } else if (errorMessage.contains("x509Cert is revoked")) {
                                verifyResult.setFailType(7);
                            } else if (errorMessage.contains("can not get the user issuer's cert")) {
                                verifyResult.setFailType(8);
                            }
                            SealVerifyResult sealVerifyResult = verifyResult;
                            this.close();
                            long end2 = System.currentTimeMillis();
                            businessLog.info("verifySignature cost= " + (end2 - start) + " ms");
                            return sealVerifyResult;
                        }
                        boolean isContainDS = ParamsCheckUtil.verifyKeyUsageForDS(x509SignCert);
                        if (!isContainDS) {
                            verifyResult.setFailReason("verifySignature for " + name + " failed!");
                            verifyResult.setFailType(10);
                            SealVerifyResult errorMessage = verifyResult;
                            return errorMessage;
                        }
                        verifyInfo.setPdfPKCS7(pkcs7);
                        X509Certificate x509Certificate = (X509Certificate)pkcs7.getSignCertificateChain()[0];
                        verifyInfo.setX509Certificate(x509Certificate);
                        verifyInfo.setSignatureName(name);
                        verifyInfo.setSignOrder(i + 1);
                        end = System.currentTimeMillis();
                        businessLog.info("verifySignature before getPageNum cost= " + (end - start) + " ms");
                        PdfFormField form = this.signatureUtil.getAcroForm().getField(name);
                        PdfWidgetAnnotation widget = form.getWidgets().get(0);
                        Rectangle signRect = widget.getRectangle().toRectangle();
                        verifyInfo.setRect(signRect);
                        PdfPage page = widget.getPage();
                        int pageNum = this.pdfDocument.getPageNumber(page);
                        verifyInfo.setPageNum(pageNum);
                        resultMap.put(name, verifyInfo);
                        if (previousPkcs7 != null) continue;
                        if (!pkcs7.verify()) {
                            verifyResult.setFailReason("verifySignature for " + name + " failed!");
                            verifyResult.setFailType(2);
                            SealVerifyResult sealVerifyResult = verifyResult;
                            return sealVerifyResult;
                        }
                        PdfName filterSubtype = pkcs7.getFilterSubtype();
                        if (!filterSubtype.equals(PdfName.Adbe_pkcs7_sha1) && !filterSubtype.equals(Constants.CFCA_SM2_ATTACH_FILTER) && !filterSubtype.equals(Constants.SM2_ATTACH_FILTER)) continue;
                        Map<String, PdfArray> signatureNames = this.signatureUtil.getSigByteRanges();
                        PdfArray byteRange = signatureNames.get(name);
                        RandomAccessFileOrArray raf = this.pdfDocument.getReader().getSafeFile();
                        RASInputStream inputStream = new RASInputStream(new RandomAccessSourceFactory().createRanged(raf.createSourceView(), SignatureUtil.asLongArray(byteRange)));
                        Mechanism hashAlg = null;
                        if (filterSubtype.equals(PdfName.Adbe_pkcs7_sha1)) {
                            hashAlg = Mechanisms.M_SHA1_RSA;
                        } else if (filterSubtype.equals(Constants.CFCA_SM2_ATTACH_FILTER) || filterSubtype.equals(Constants.SM2_ATTACH_FILTER)) {
                            hashAlg = Mechanisms.M_SM3_SM2;
                        }
                        byte[] digest = PdfHashUtil.calculateHashOfSourceData(inputStream, hashAlg, null);
                        boolean verifyDigest = Arrays.equals(digest, pkcs7.getRsaData());
                        if (verifyDigest) continue;
                        verifyResult.setVerifyResult(verifyDigest);
                        verifyResult.setFailReason("P7Attach signature verify hashData failed");
                        verifyResult.setFailType(4);
                        SealVerifyResult sealVerifyResult = verifyResult;
                        return sealVerifyResult;
                    }
                    verifyResult.setVerifyResult(true);
                }
                long end = System.currentTimeMillis();
                businessLog.info("verifySignature check all signature cost= " + (end - start) + " ms");
                int signatureNums = signedNames.size();
                String lastSignature = signedNames.get(signatureNums - 1);
                if (this.signatureUtil.signatureCoversWholeDocument(lastSignature)) {
                    boolean changedFlag = false;
                    Map<String, PdfArray> signatureNames = this.signatureUtil.getSigByteRanges();
                    for (int m = 0; m < signatureNums - 1; ++m) {
                        String secondSigName;
                        PdfArray secondByteRange;
                        String firstSigName = signedNames.get(m);
                        PdfArray firstByteRange = signatureNames.get(firstSigName);
                        if (m + 1 > signatureNums - 1 || firstByteRange.equals(secondByteRange = signatureNames.get(secondSigName = signedNames.get(m + 1)))) continue;
                        int startPosition = firstByteRange.getAsNumber(2).intValue() + firstByteRange.getAsNumber(3).intValue();
                        int length = secondByteRange.getAsNumber(1).intValue() - startPosition;
                        RandomAccessFileOrArray raf = this.pdfDocument.getReader().getSafeFile();
                        RASInputStream inputStream = new RASInputStream(new WindowRandomAccessSource(raf.createSourceView(), startPosition, length));
                        byte[] diff = PDFUtil.getSourceData(inputStream);
                        if (null == diff || diff.length <= 0 || KMPUtil.kmp(diff, xrefBytes, xrefNext) == -1 && KMPUtil.kmp(diff, eofBytes, eofNext) == -1) continue;
                        String detailInfo = "";
                        try {
                            PdfAcroForm acroForm = this.signatureUtil.getAcroForm();
                            PdfSignatureFormField sigField = (PdfSignatureFormField)acroForm.getField(secondSigName);
                            PdfSigFieldLockDictionary fieldLock = sigField.getSigFieldLockDictionary();
                            if (fieldLock != null) {
                                detailInfo = " ,locked by " + secondSigName;
                            }
                        }
                        catch (Exception e) {
                            businessLog.warn("check lock after signature failed", (Throwable)e);
                        }
                        changedFlag = true;
                        verifyResult.setVerifyResult(false);
                        verifyResult.setUnCoverageData(diff);
                        verifyResult.setFailType(3);
                        verifyResult.setFailReason("verify failed: changed after signature! fieldName=" + firstSigName + detailInfo);
                        break;
                    }
                    if (!changedFlag) {
                        verifyResult.setVerifyResult(true);
                    }
                } else {
                    verifyResult.setFailType(3);
                    verifyResult.setVerifyResult(false);
                    verifyResult.setFailReason("verify failed: changed after signature! fieldName=" + lastSignature);
                    long fileLength = this.signatureUtil.getDocument().getReader().getFileLength();
                    PdfArray maxByteArray = this.signatureUtil.getSignatureDictionary(lastSignature).getAsArray(PdfName.ByteRange);
                    long finalSigLength = maxByteArray.getAsNumber(2).longValue() + maxByteArray.getAsNumber(3).longValue();
                    long unCoveredLength = fileLength - finalSigLength;
                    if (unCoveredLength > 0L) {
                        RandomAccessFileOrArray raf = this.pdfDocument.getReader().getSafeFile();
                        RASInputStream inputStream = new RASInputStream(new WindowRandomAccessSource(raf.createSourceView(), finalSigLength, unCoveredLength));
                        byte[] uncoveredData = PDFUtil.getSourceData(inputStream);
                        verifyResult.setUnCoverageData(uncoveredData);
                    }
                }
            } else {
                verifyResult.setFailType(1);
                verifyResult.setFailReason("verify failed: no signature found!");
            }
            verifyResult.setVerifyInfos(resultMap);
            this.close();
        }
        catch (SealException e) {
            businessLog.error("verifySignature failed ", (Throwable)e);
            String errorMessage = e.getMessage();
            if (errorMessage.contains("x509Cert is not valid")) {
                verifyResult.setFailType(5);
            } else if (errorMessage.contains("x509Cert is expired")) {
                verifyResult.setFailType(6);
            } else if (errorMessage.contains("x509Cert is revoked")) {
                verifyResult.setFailType(7);
            } else if (errorMessage.contains("x509Cert is not trusted")) {
                verifyResult.setFailType(8);
            }
            verifyResult.setFailReason(e.getMessage());
        }
        catch (Exception e) {
            businessLog.error("verifySignature failed ", (Throwable)e);
            verifyResult.setFailType(2);
            verifyResult.setFailReason(e.getMessage());
        }
        finally {
            this.close();
            long end = System.currentTimeMillis();
            businessLog.info("verifySignature cost= " + (end - start) + " ms");
        }
        return verifyResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getUncoveredBytes(byte[] sourceData) throws GeneralSecurityException {
        try {
            PdfReader pdfReader = new PdfReader(sourceData);
            this.pdfDocument = new PdfDocument(pdfReader);
            this.signatureUtil = new SignatureUtil(this.pdfDocument, true);
            List<String> signedNames = this.signatureUtil.getSignatureNames();
            HashMap<Integer, PdfPKCS7> valuePkcs7Map = new HashMap<Integer, PdfPKCS7>();
            for (String name : signedNames) {
                PdfDictionary tmpSigDict = this.signatureUtil.getSignatureDictionary(name);
                int objNumber = tmpSigDict.getIndirectReference().getObjNumber();
                PdfPKCS7 previousPdfPkcs7 = valuePkcs7Map.put(objNumber, null);
                if (previousPdfPkcs7 != null) {
                    valuePkcs7Map.put(objNumber, previousPdfPkcs7);
                    continue;
                }
                PdfPKCS7 pkcs7 = this.signatureUtil.verifySignature(name, provider.getName());
                valuePkcs7Map.put(objNumber, pkcs7);
                if (pkcs7.verify()) continue;
                throw new GeneralSecurityException("verify failed for signatureName:" + name);
            }
            String lastSignature = signedNames.get(signedNames.size() - 1);
            int revisions = this.signatureUtil.getTotalRevisions();
            int finalRevisions = this.signatureUtil.getRevision(lastSignature);
            businessLog.info("revisions=" + revisions + " finalRevisions=" + finalRevisions);
            long[] uncoveredByteRange = new long[2];
            PdfArray maxByteArray = this.signatureUtil.getSignatureDictionary(lastSignature).getAsArray(PdfName.ByteRange);
            uncoveredByteRange[0] = maxByteArray.getAsNumber(2).longValue() + maxByteArray.getAsNumber(3).longValue();
            uncoveredByteRange[1] = pdfReader.getFileLength() - uncoveredByteRange[0];
            PdfArray uncoveredRange = new PdfArray();
            PdfNumber pdfNumber0 = new PdfNumber(uncoveredByteRange[0]);
            PdfNumber pdfNumber1 = new PdfNumber(uncoveredByteRange[1]);
            uncoveredRange.add(pdfNumber0);
            uncoveredRange.add(pdfNumber1);
            IRandomAccessSource readerSource = this.pdfDocument.getReader().getSafeFile().createSourceView();
            RASInputStream rg = new RASInputStream(new RandomAccessSourceFactory().createRanged(readerSource, SignatureUtil.asLongArray(uncoveredRange)));
            byte[] uncoveredData = PDFUtil.getSourceData(rg);
            if (uncoveredData.length == 0) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = uncoveredData;
            return byArray;
        }
        catch (IOException e) {
            businessLog.error("IOException:", (Throwable)e);
        }
        catch (Exception e) {
            businessLog.error("Exception:", (Throwable)e);
        }
        finally {
            this.close();
        }
        return null;
    }

    private Date getTimeStampTime(byte[] pkcs7Bytes, byte[] signedData) throws SealException {
        long start = System.currentTimeMillis();
        Date date = null;
        try {
            PaperlessP7Util util = PaperlessP7Util.getInstance((byte[])pkcs7Bytes);
            date = util.getTSADate();
            byte[] tsaSignedData = util.getTSATimestampToken();
            ContentInfo contentInfo = ContentInfo.getInstance((Object)tsaSignedData);
            TimeStampToken timeStampToken = new TimeStampToken(contentInfo);
            String hashOID = timeStampToken.getTimeStampInfo().getMessageImprintAlgOID().getId();
            Mechanism digestAlg = MechanismUtil.getMechanism(hashOID);
            byte[] hashData = null;
            hashData = digestAlg.equals((Object)Mechanisms.M_SM3_SM2) ? HashUtil.SM3HashData((byte[])signedData, (Session)BCSoftLib.INSTANCE()) : HashUtil.RSAHashData((byte[])signedData, (Mechanism)digestAlg, (Session)BCSoftLib.INSTANCE(), (boolean)false);
            MessageImprint imprint = timeStampToken.getTimeStampInfo().toASN1Structure().getMessageImprint();
            byte[] imphashed = imprint.getHashedMessage();
            boolean tsaVerifyResult = Arrays.equals(hashData, imphashed);
            if (!tsaVerifyResult) {
                if (digestAlg.equals((Object)Mechanisms.M_SM3_SM2)) {
                    ASN1SM2Signature convert = new ASN1SM2Signature(signedData);
                    byte[] raw64Sign = convert.getRSRaw64Bytes();
                    hashData = HashUtil.SM3HashData((byte[])raw64Sign, (Session)BCSoftLib.INSTANCE());
                    tsaVerifyResult = Arrays.equals(hashData, imphashed);
                }
                if (!tsaVerifyResult) {
                    String errorInfo = "TSA verify failed,MessageImprint is mismatched!";
                    if (SysEnv.isCheckTSA()) {
                        throw new SealException(errorInfo);
                    }
                    businessLog.warn(errorInfo);
                }
            }
        }
        catch (SealException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
        long end = System.currentTimeMillis();
        businessLog.info("getTimeStampTime() cost= " + (end - start) + " ms");
        return date;
    }

    public void close() {
        if (null != this.pdfDocument) {
            this.pdfDocument.close();
        }
    }

    static {
        try {
            xrefBytes = XREF.getBytes("UTF8");
            eofBytes = EOF.getBytes("UTF8");
            xrefNext = KMPUtil.kmpnext(xrefBytes);
            eofNext = KMPUtil.kmpnext(eofBytes);
        }
        catch (UnsupportedEncodingException e) {
            businessLog.error("VerifyProxy init failed!", (Throwable)e);
        }
    }
}

